/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.delete;

import com.google.common.base.Preconditions;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.delete.PageFilter;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import java.util.List;
import java.util.Objects;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public final class PositionDeleteFilter {
    private final Roaring64NavigableMap deletedRows;

    public PositionDeleteFilter(Roaring64NavigableMap deletedRows) {
        Objects.requireNonNull(deletedRows, "deletedRows is null");
        Preconditions.checkArgument((!deletedRows.isEmpty() ? 1 : 0) != 0, (Object)"deletedRows is empty");
        this.deletedRows = deletedRows;
    }

    public PageFilter createPredicate(List<DeltaLakeColumnHandle> columns) {
        int filePositionChannel = PositionDeleteFilter.rowPositionChannel(columns);
        return page -> {
            int positionCount = page.getPositionCount();
            int[] retained = new int[positionCount];
            int retainedCount = 0;
            Block block = page.getBlock(filePositionChannel);
            for (int position = 0; position < positionCount; ++position) {
                long filePosition = BigintType.BIGINT.getLong(block, position);
                if (this.deletedRows.contains(filePosition)) continue;
                retained[retainedCount] = position;
                ++retainedCount;
            }
            if (retainedCount == positionCount) {
                return page;
            }
            return page.getPositions(retained, 0, retainedCount);
        };
    }

    private static int rowPositionChannel(List<DeltaLakeColumnHandle> columns) {
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).getBaseColumnName().equals("$row_position")) continue;
            return i;
        }
        throw new IllegalArgumentException("No row position column");
    }
}

