/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;

public class RemoveFileEntry {
    private final String path;
    private final Map<String, String> partitionValues;
    private final long deletionTimestamp;
    private final boolean dataChange;

    @JsonCreator
    public RemoveFileEntry(@JsonProperty(value="path") String path, @JsonProperty(value="partitionValues") @Nullable Map<String, String> partitionValues, @JsonProperty(value="deletionTimestamp") long deletionTimestamp, @JsonProperty(value="dataChange") boolean dataChange) {
        this.path = path;
        this.partitionValues = partitionValues;
        this.deletionTimestamp = deletionTimestamp;
        this.dataChange = dataChange;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @Nullable
    @JsonProperty
    public Map<String, String> getPartitionValues() {
        return this.partitionValues;
    }

    @JsonProperty
    public long getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    @JsonProperty
    public boolean isDataChange() {
        return this.dataChange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoveFileEntry that = (RemoveFileEntry)o;
        return this.deletionTimestamp == that.deletionTimestamp && this.dataChange == that.dataChange && Objects.equals(this.path, that.path) && Objects.equals(this.partitionValues, that.partitionValues);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.partitionValues, this.deletionTimestamp, this.dataChange);
    }

    public String toString() {
        return "RemoveFileEntry{path='" + this.path + "', partitionValues=" + String.valueOf(this.partitionValues) + ", deletionTimestamp=" + this.deletionTimestamp + ", dataChange=" + this.dataChange + "}";
    }
}

