/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.util;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.List;

public final class DeltaLakeWriteUtils {
    private static final DateTimeFormatter DELTA_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DELTA_TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().toFormatter();

    private DeltaLakeWriteUtils() {
    }

    public static List<String> createPartitionValues(List<Type> partitionColumnTypes, Page partitionColumns, int position) {
        ImmutableList.Builder partitionValues = ImmutableList.builder();
        for (int field = 0; field < partitionColumns.getChannelCount(); ++field) {
            String value = DeltaLakeWriteUtils.toPartitionValue(partitionColumnTypes.get(field), partitionColumns.getBlock(field), position);
            if (!CharMatcher.inRange((char)' ', (char)'~').matchesAllOf((CharSequence)value)) {
                String encoded = BaseEncoding.base16().withSeparator(" ", 2).encode(value.getBytes(StandardCharsets.UTF_8));
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, "Hive partition keys can only contain printable ASCII characters (0x20 - 0x7E). Invalid value: " + encoded);
            }
            partitionValues.add((Object)value);
        }
        return partitionValues.build();
    }

    private static String toPartitionValue(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return "__HIVE_DEFAULT_PARTITION__";
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return String.valueOf(BooleanType.BOOLEAN.getBoolean(block, position));
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return String.valueOf(BigintType.BIGINT.getLong(block, position));
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return String.valueOf(IntegerType.INTEGER.getInt(block, position));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return String.valueOf(SmallintType.SMALLINT.getShort(block, position));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return String.valueOf(TinyintType.TINYINT.getByte(block, position));
        }
        if (RealType.REAL.equals((Object)type)) {
            return String.valueOf(RealType.REAL.getFloat(block, position));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return String.valueOf(DoubleType.DOUBLE.getDouble(block, position));
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            return varcharType.getSlice(block, position).toStringUtf8();
        }
        if (DateType.DATE.equals((Object)type)) {
            return LocalDate.ofEpochDay(DateType.DATE.getInt(block, position)).format(DELTA_DATE_FORMATTER);
        }
        if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type) || TimestampType.TIMESTAMP_MICROS.equals((Object)type)) {
            long epochMicros = type.getLong(block, position);
            long epochSeconds = Math.floorDiv(epochMicros, 1000000);
            int nanosOfSecond = Math.floorMod(epochMicros, 1000000) * 1000;
            return LocalDateTime.ofEpochSecond(epochSeconds, nanosOfSecond, ZoneOffset.UTC).format(DELTA_TIMESTAMP_FORMATTER);
        }
        if (TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.equals((Object)type)) {
            long epochMillis = DateTimeEncoding.unpackMillisUtc((long)type.getLong(block, position));
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneOffset.UTC).format(DELTA_TIMESTAMP_FORMATTER);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return Decimals.readBigDecimal((DecimalType)decimalType, (Block)block, (int)position).stripTrailingZeros().toPlainString();
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type for partition: " + String.valueOf(type));
    }
}

