/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;

public class AlluxioFileSystemCacheConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    static final String CACHE_DIRECTORIES = "fs.cache.directories";
    static final String CACHE_MAX_SIZES = "fs.cache.max-sizes";
    static final String CACHE_MAX_PERCENTAGES = "fs.cache.max-disk-usage-percentages";
    private List<String> cacheDirectories;
    private List<DataSize> maxCacheSizes = ImmutableList.of();
    private Optional<Duration> cacheTTL = Optional.of(Duration.valueOf((String)"7d"));
    private List<Integer> maxCacheDiskUsagePercentages = ImmutableList.of();
    private DataSize cachePageSize = DataSize.valueOf((String)"1MB");

    @NotNull
    public List<String> getCacheDirectories() {
        return this.cacheDirectories;
    }

    @Config(value="fs.cache.directories")
    @ConfigDescription(value="Base directory to cache data. Use a comma-separated list to cache data in multiple directories.")
    public AlluxioFileSystemCacheConfig setCacheDirectories(String cacheDirectories) {
        this.cacheDirectories = cacheDirectories == null ? null : SPLITTER.splitToList((CharSequence)cacheDirectories);
        return this;
    }

    public List<DataSize> getMaxCacheSizes() {
        return this.maxCacheSizes;
    }

    @Config(value="fs.cache.max-sizes")
    @ConfigDescription(value="The maximum cache size for a cache directory. Use a comma-separated list of sizes to specify allowed maximum values for each directory.")
    public AlluxioFileSystemCacheConfig setMaxCacheSizes(String maxCacheSizes) {
        this.maxCacheSizes = (List)SPLITTER.splitToStream((CharSequence)MoreObjects.firstNonNull((Object)maxCacheSizes, (Object)"")).map(DataSize::valueOf).collect(ImmutableList.toImmutableList());
        return this;
    }

    public @NotNull Optional<@MinDuration(value="0s") Duration> getCacheTTL() {
        return this.cacheTTL;
    }

    @Config(value="fs.cache.ttl")
    @ConfigDescription(value="Duration to keep files in the cache prior to eviction")
    public AlluxioFileSystemCacheConfig setCacheTTL(Duration cacheTTL) {
        this.cacheTTL = Optional.of(cacheTTL);
        return this;
    }

    public AlluxioFileSystemCacheConfig disableTTL() {
        this.cacheTTL = Optional.empty();
        return this;
    }

    public List<@Min(value=0L) @Max(value=100L) Integer> getMaxCacheDiskUsagePercentages() {
        return this.maxCacheDiskUsagePercentages;
    }

    @Config(value="fs.cache.max-disk-usage-percentages")
    @ConfigDescription(value="The maximum percentage (0-100) of total disk size the cache can use. Use a comma-separated list of percentage values if supplying several cache directories.")
    public AlluxioFileSystemCacheConfig setMaxCacheDiskUsagePercentages(String maxCacheDiskUsagePercentages) {
        this.maxCacheDiskUsagePercentages = (List)SPLITTER.splitToStream((CharSequence)MoreObjects.firstNonNull((Object)maxCacheDiskUsagePercentages, (Object)"")).map(Integer::valueOf).collect(ImmutableList.toImmutableList());
        return this;
    }

    @NotNull
    @MaxDataSize(value="15MB")
    @MinDataSize(value="64kB")
    public @NotNull @MaxDataSize(value="15MB") @MinDataSize(value="64kB") DataSize getCachePageSize() {
        return this.cachePageSize;
    }

    @Config(value="fs.cache.page-size")
    @ConfigDescription(value="Page size for cache")
    public AlluxioFileSystemCacheConfig setCachePageSize(DataSize cachePageSize) {
        this.cachePageSize = cachePageSize;
        return this;
    }
}

