/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.file.ByteArrayTargetBuffer;
import alluxio.file.ByteBufferTargetBuffer;
import alluxio.file.NettyBufTargetBuffer;
import alluxio.file.ReadTargetBuffer;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface PositionReader
extends Closeable {
    default public int read(long position, byte[] buffer, int length) throws IOException {
        return this.read(position, new ByteArrayTargetBuffer(buffer, 0), length);
    }

    default public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        return this.read(position, new ByteArrayTargetBuffer(buffer, offset), length);
    }

    default public int read(long position, ByteBuffer buffer, int length) throws IOException {
        return this.read(position, new ByteBufferTargetBuffer(buffer), length);
    }

    default public int read(long position, ByteBuf buffer, int length) throws IOException {
        return this.read(position, new NettyBufTargetBuffer(buffer), length);
    }

    default public int read(long position, ReadTargetBuffer buffer, int length) throws IOException {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length should be non-negative");
        Preconditions.checkArgument((position >= 0L ? 1 : 0) != 0, (Object)"position should be non-negative");
        Preconditions.checkArgument((buffer.remaining() >= (long)length ? 1 : 0) != 0, (Object)"given buffer should have enough space to write given length");
        if (length == 0) {
            return 0;
        }
        return this.readInternal(position, buffer, length);
    }

    public int readInternal(long var1, ReadTargetBuffer var3, int var4) throws IOException;

    @Override
    default public void close() throws IOException {
    }
}

