/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.PositionReader;
import alluxio.util.io.BufferUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class PositionReaderTest {
    private final PositionReader mReader;
    private final int mFileLen;
    private final Random mRandom = new Random();

    public PositionReaderTest(PositionReader reader, int fileLen) {
        this.mReader = reader;
        this.mFileLen = fileLen;
    }

    public void testAllCornerCases() throws IOException {
        this.byteArrayInvalidLength();
        this.byteArrayInvalidLength2();
        this.byteArrayNegativeLength();
        this.byteArrayNegativeLength2();
        this.byteArrayNegativePosition();
        this.byteArrayNegativePosition2();
        this.byteArrayZeroLength();
        this.byteArrayZeroLength2();
        this.byteBufferInvalidLength();
        this.byteBufferNegativeLength();
        this.byteBufferNegativePosition();
        this.byteBufferZeroLength();
        this.byteBufInvalidLength();
        this.byteBufNegativeLength();
        this.byteBufNegativePosition();
        this.byteBufZeroLength();
    }

    public void testReadRandomPart() throws IOException {
        this.byteArrayReadRandomPart();
        this.byteBufferReadRandomPart();
        this.byteBufReadRandomPart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concurrentReadPart() throws Exception {
        int threadNum = Math.min(this.mFileLen, 10);
        if (threadNum <= 1) {
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(threadNum);
        try {
            ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>();
            for (int i = 0; i < 10; ++i) {
                int seed = this.mRandom.nextInt(3);
                tasks.add(() -> {
                    try {
                        switch (seed) {
                            case 0: {
                                this.byteArrayReadRandomPart();
                                break;
                            }
                            case 1: {
                                this.byteBufferReadRandomPart();
                                break;
                            }
                            case 2: {
                                this.byteBufReadRandomPart();
                                break;
                            }
                            default: {
                                throw new IOException("should not happen");
                            }
                        }
                        return true;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            List results = executor.invokeAll(tasks);
            for (Future result : results) {
                if (((Boolean)result.get()).booleanValue()) continue;
                throw new IOException("Data corrupted");
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private void byteBufferReadRandomPart() throws IOException {
        int testNum = Math.min(this.mFileLen, 50);
        ByteBuffer buf = ByteBuffer.allocate(this.mFileLen);
        for (int i = 0; i < testNum; ++i) {
            int totalRead;
            int currentRead;
            int position = this.mRandom.nextInt(this.mFileLen);
            int length = this.mRandom.nextInt(this.mFileLen - position);
            if (length == 0) continue;
            buf.position(0);
            buf.limit(length);
            for (totalRead = 0; totalRead < length && (currentRead = this.mReader.read((long)(position + totalRead), buf, length - totalRead)) > 0; totalRead += currentRead) {
            }
            if (totalRead != length) {
                throw new IOException(String.format("Failed to read data from position %s of length %s from reader, only read %s", position, length, totalRead));
            }
            if (BufferUtils.equalIncreasingByteBuffer(position, length, buf)) continue;
            throw new IOException("Data corrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void byteBufReadRandomPart() throws IOException {
        int testNum = Math.min(this.mFileLen, 50);
        ByteBuf buf = Unpooled.buffer((int)this.mFileLen);
        try {
            for (int i = 0; i < testNum; ++i) {
                int totalRead;
                int currentRead;
                int position = this.mRandom.nextInt(this.mFileLen);
                int length = this.mRandom.nextInt(this.mFileLen - position);
                if (length == 0) continue;
                buf.clear();
                buf.capacity(length);
                for (totalRead = 0; totalRead < length && (currentRead = this.mReader.read((long)(position + totalRead), buf, length - totalRead)) > 0; totalRead += currentRead) {
                }
                if (totalRead != length) {
                    throw new IOException(String.format("Failed to read data from position %s of length %s from reader, only read %s", position, length, totalRead));
                }
                if (BufferUtils.equalIncreasingByteBuf(position, length, buf)) continue;
                throw new IOException("Data corrupted");
            }
        }
        finally {
            buf.release();
        }
    }

    private void byteArrayReadRandomPart() throws IOException {
        int testNum = Math.min(this.mFileLen, 50);
        byte[] buf = new byte[this.mFileLen];
        for (int i = 0; i < testNum; ++i) {
            int totalRead;
            int currentRead;
            int position = this.mRandom.nextInt(this.mFileLen);
            int length = this.mRandom.nextInt(this.mFileLen - position);
            if (length == 0) continue;
            for (totalRead = 0; totalRead < length && (currentRead = this.mReader.read((long)(position + totalRead), buf, length - totalRead)) > 0; totalRead += currentRead) {
            }
            if (totalRead != length) {
                throw new IOException(String.format("Failed to read data from position %s of length %s from reader, only read %s", position, length, totalRead));
            }
            if (BufferUtils.startsWithIncreasingByteArray(position, length, buf)) continue;
            throw new IOException("Data corrupted");
        }
    }

    private void byteBufferZeroLength() throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(1);
        if (this.mReader.read(0L, buf, 0) != 0) {
            throw new IOException("read length 0 should return 0");
        }
        buf.flip();
        if (buf.remaining() != 0) {
            throw new IOException("read length 0 should not read any data from buf");
        }
    }

    private void byteBufZeroLength() throws IOException {
        ByteBuf buf = Unpooled.buffer((int)1);
        if (this.mReader.read(0L, buf, 0) != 0) {
            throw new IOException("read length 0 should return 0");
        }
        try {
            buf.readByte();
            throw new IOException("read length 0 should not read any data from buf");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
    }

    private void byteArrayZeroLength() throws IOException {
        byte[] byteArray = new byte[1];
        if (this.mReader.read(0L, byteArray, 0) != 0) {
            throw new IOException("read length 0 should return 0");
        }
    }

    private void byteArrayZeroLength2() throws IOException {
        byte[] byteArray = new byte[1];
        if (this.mReader.read(0L, byteArray, 0, 0) != 0) {
            throw new IOException("read length 0 should return 0");
        }
    }

    private void byteBufferInvalidLength() throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(1);
        try {
            this.mReader.read(0L, buf, 2);
            throw new IOException("Read length should not be bigger than given buffer length");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    private void byteBufInvalidLength() throws IOException {
        ByteBuf buf = Unpooled.buffer((int)1);
        try {
            this.mReader.read(0L, buf, 2);
            throw new IOException("Read length should not be bigger than given buffer length");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    private void byteArrayInvalidLength() throws IOException {
        byte[] byteArray = new byte[1];
        try {
            this.mReader.read(0L, byteArray, 2);
            throw new IOException("Read length should not be bigger than given byteArray length");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    private void byteArrayInvalidLength2() throws IOException {
        byte[] byteArray = new byte[1];
        try {
            this.mReader.read(0L, byteArray, 0, 2);
            throw new IOException("Read length should not be bigger than given byteArray length");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    private void byteBufferNegativeLength() throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(1);
        try {
            this.mReader.read(0L, buf, -1);
            throw new IOException("Read should error out when given length is negative");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    private void byteBufNegativeLength() throws IOException {
        ByteBuf buf = Unpooled.buffer((int)1);
        try {
            try {
                this.mReader.read(0L, buf, -1);
                throw new IOException("Read should error out when given length is negative");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                buf.release();
            }
        }
        catch (Throwable throwable) {
            buf.release();
            throw throwable;
        }
    }

    private void byteArrayNegativeLength() throws IOException {
        byte[] byteArray = new byte[1];
        try {
            this.mReader.read(0L, byteArray, -1);
            throw new IOException("Read should error out when given length is negative");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    private void byteArrayNegativeLength2() throws IOException {
        byte[] byteArray = new byte[1];
        try {
            this.mReader.read(0L, byteArray, 0, -1);
            throw new IOException("Read should error out when given length is negative");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    private void byteBufferNegativePosition() throws IOException {
        if (this.mFileLen < 1) {
            return;
        }
        ByteBuffer buf = ByteBuffer.allocate(1);
        try {
            this.mReader.read(-1L, buf, 1);
            throw new IOException("Read should error out when given position is negative");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    private void byteBufNegativePosition() throws IOException {
        if (this.mFileLen < 1) {
            return;
        }
        ByteBuf buf = Unpooled.buffer((int)1);
        try {
            try {
                this.mReader.read(-1L, buf, 1);
                throw new IOException("Read should error out when given position is negative");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                buf.release();
            }
        }
        catch (Throwable throwable) {
            buf.release();
            throw throwable;
        }
    }

    private void byteArrayNegativePosition() throws IOException {
        if (this.mFileLen < 1) {
            return;
        }
        byte[] byteArray = new byte[1];
        try {
            this.mReader.read(-1L, byteArray, 1);
            throw new IOException("Read should error out when given position is negative");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    private void byteArrayNegativePosition2() throws IOException {
        if (this.mFileLen < 1) {
            return;
        }
        byte[] byteArray = new byte[1];
        try {
            this.mReader.read(-1L, byteArray, 0, 1);
            throw new IOException("Read should error out when given position is negative");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }
}

