/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client;

import alluxio.client.AlluxioStorageType;
import alluxio.client.UnderStorageType;
import alluxio.grpc.WritePType;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public enum WriteType {
    MUST_CACHE(1),
    TRY_CACHE(2),
    CACHE_THROUGH(3),
    THROUGH(4),
    ASYNC_THROUGH(5),
    NONE(6);

    private final int mValue;

    private WriteType(int value) {
        this.mValue = value;
    }

    public AlluxioStorageType getAlluxioStorageType() {
        if (this.isCache()) {
            return AlluxioStorageType.STORE;
        }
        return AlluxioStorageType.NO_STORE;
    }

    public UnderStorageType getUnderStorageType() {
        if (this.isThrough()) {
            return UnderStorageType.SYNC_PERSIST;
        }
        return UnderStorageType.NO_PERSIST;
    }

    public int getValue() {
        return this.mValue;
    }

    public boolean isCache() {
        return this.mValue == WriteType.CACHE_THROUGH.mValue || this.mValue == WriteType.TRY_CACHE.mValue;
    }

    public boolean isThrough() {
        return this.mValue == WriteType.CACHE_THROUGH.mValue || this.mValue == WriteType.THROUGH.mValue;
    }

    public static WriteType fromProto(WritePType writePType) {
        return WriteType.values()[writePType.getNumber() - 1];
    }

    public WritePType toProto() {
        return WritePType.values()[this.mValue - 1];
    }
}

