/*
 * Decompiled with CFR 0.152.
 */
package alluxio.exception.runtime;

import alluxio.exception.runtime.FailedPreconditionRuntimeException;
import alluxio.exception.runtime.InternalRuntimeException;
import alluxio.exception.runtime.InvalidArgumentRuntimeException;
import alluxio.exception.runtime.NotFoundRuntimeException;
import alluxio.exception.runtime.PermissionDeniedRuntimeException;
import alluxio.exception.runtime.UnauthenticatedRuntimeException;
import alluxio.exception.runtime.UnimplementedRuntimeException;
import alluxio.exception.runtime.UnknownRuntimeException;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.ErrorInfo;
import alluxio.grpc.ErrorType;
import alluxio.grpc.RetryInfo;
import com.google.common.base.Preconditions;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.ProtoUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Nullable;
import javax.security.sasl.SaslException;

public class AlluxioRuntimeException
extends RuntimeException {
    private final Status mStatus;
    private final Any[] mDetails;
    private final boolean mRetryable;
    private final ErrorType mErrorType;

    public AlluxioRuntimeException(Status status, String message, @Nullable Throwable cause, ErrorType errorType, boolean retryable, Any ... details) {
        super(message, cause);
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Preconditions.checkArgument((status != Status.OK ? 1 : 0) != 0, (Object)"OK is not an error status");
        this.mStatus = status.withCause(cause).withDescription(message);
        this.mDetails = details;
        this.mRetryable = retryable;
        this.mErrorType = errorType;
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public boolean isRetryable() {
        return this.mRetryable;
    }

    public StatusException toGrpcStatusException() {
        return this.mStatus.withCause(this.getCause()).withDescription(this.getMessage()).asException(this.getMetadata());
    }

    private Metadata getMetadata() {
        Metadata trailers = new Metadata();
        trailers.put(ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance()), (Object)RetryInfo.newBuilder().setIsRetryable(this.mRetryable).build());
        trailers.put(ProtoUtils.keyForProto((Message)ErrorInfo.getDefaultInstance()), (Object)ErrorInfo.newBuilder().setErrorType(this.mErrorType).build());
        if (this.mDetails != null) {
            for (Any detail : this.mDetails) {
                trailers.put(ProtoUtils.keyForProto((Message)Any.getDefaultInstance()), (Object)detail);
            }
        }
        return trailers;
    }

    public StatusRuntimeException toGrpcStatusRuntimeException() {
        return this.mStatus.withCause(this.getCause()).withDescription(this.getMessage()).asRuntimeException(this.getMetadata());
    }

    public static AlluxioRuntimeException from(RejectedExecutionException ex) {
        return new AlluxioRuntimeException(Status.RESOURCE_EXHAUSTED, "StageOverload", ex, ErrorType.User, true, new Any[0]);
    }

    public static AlluxioRuntimeException from(Throwable t) {
        if (t instanceof AlluxioRuntimeException) {
            return (AlluxioRuntimeException)t;
        }
        if (t instanceof AlluxioStatusException) {
            return AlluxioRuntimeException.from((AlluxioStatusException)t);
        }
        if (t instanceof IOException) {
            return AlluxioRuntimeException.from((IOException)t);
        }
        if (t instanceof RuntimeException) {
            return AlluxioRuntimeException.from((RuntimeException)t);
        }
        return new UnknownRuntimeException(t);
    }

    public static AlluxioRuntimeException from(RuntimeException t) {
        if (t instanceof RejectedExecutionException) {
            return AlluxioRuntimeException.from((RejectedExecutionException)t);
        }
        if (t instanceof IllegalArgumentException) {
            return new InvalidArgumentRuntimeException(t);
        }
        if (t instanceof IllegalStateException || t instanceof NullPointerException) {
            return new InternalRuntimeException(t);
        }
        if (t instanceof CompletionException) {
            return AlluxioRuntimeException.from(t.getCause());
        }
        if (t instanceof UnsupportedOperationException) {
            return new UnimplementedRuntimeException(t, ErrorType.External);
        }
        if (t instanceof SecurityException) {
            return new PermissionDeniedRuntimeException(t);
        }
        return new UnknownRuntimeException(t);
    }

    public static AlluxioRuntimeException from(AlluxioStatusException t) {
        return new AlluxioRuntimeException(t.getStatus(), t.getMessage(), t.getCause(), ErrorType.User, false, new Any[0]);
    }

    public static AlluxioRuntimeException from(IOException ioe) {
        if (ioe instanceof AlluxioStatusException) {
            return AlluxioRuntimeException.from((AlluxioStatusException)ioe);
        }
        if (ioe instanceof FileNotFoundException) {
            return new NotFoundRuntimeException(ioe);
        }
        if (ioe instanceof MalformedURLException) {
            return new InvalidArgumentRuntimeException(ioe);
        }
        if (ioe instanceof UserPrincipalNotFoundException || ioe instanceof SaslException) {
            return new UnauthenticatedRuntimeException(ioe);
        }
        if (ioe instanceof ClosedChannelException) {
            return new FailedPreconditionRuntimeException(ioe);
        }
        return new UnknownRuntimeException(ioe);
    }

    @Override
    @Nullable
    public String getMessage() {
        String message = super.getMessage();
        if (message == null && this.getCause() != null) {
            message = this.getCause().getMessage();
        }
        if (message == null) {
            message = this.mStatus.getDescription();
        }
        return message;
    }
}

