/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job;

import alluxio.grpc.CopyJobPOptions;
import alluxio.job.JobRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CopyJobRequest
implements JobRequest {
    private static final String TYPE = "copy";
    private static final long serialVersionUID = -8565405317284410500L;
    private final String mDst;
    private final CopyJobPOptions mOptions;
    private final String mSrc;

    public CopyJobRequest(@JsonProperty(value="src") String src, @JsonProperty(value="dst") String dst, @JsonProperty(value="copyJobPOptions") CopyJobPOptions options) {
        this.mSrc = (String)Preconditions.checkNotNull((Object)src, (Object)"The source path cannot be null");
        this.mDst = (String)Preconditions.checkNotNull((Object)dst, (Object)"The destination path cannot be null");
        this.mOptions = (CopyJobPOptions)Preconditions.checkNotNull((Object)options, (Object)"The job options cannot be null");
    }

    public String getSrc() {
        return this.mSrc;
    }

    public String getDst() {
        return this.mDst;
    }

    public CopyJobPOptions getOptions() {
        return this.mOptions;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Src", (Object)this.mSrc).add("Dst", (Object)this.mDst).add("Options", (Object)this.mOptions).toString();
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

