/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.selectionpolicy;

import alluxio.exception.status.UnavailableException;
import alluxio.master.MasterInquireClient;
import alluxio.master.selectionpolicy.AbstractMasterSelectionPolicy;
import alluxio.master.selectionpolicy.MasterSelectionPolicy;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import javax.annotation.Nullable;

public class SelectionPolicyAnyStandbyMaster
extends AbstractMasterSelectionPolicy {
    @Nullable
    private final Random mRandom;

    protected SelectionPolicyAnyStandbyMaster() {
        this.mRandom = null;
    }

    protected SelectionPolicyAnyStandbyMaster(long shuffleSeed) {
        this.mRandom = new Random(shuffleSeed);
    }

    @Override
    public synchronized InetSocketAddress getGrpcMasterAddress(MasterInquireClient masterInquireClient) throws UnavailableException {
        ArrayList<InetSocketAddress> masterAddresses = new ArrayList<InetSocketAddress>(masterInquireClient.getMasterRpcAddresses());
        if (this.mRandom != null) {
            masterAddresses.sort(Comparator.comparing(InetSocketAddress::toString));
            Collections.shuffle(masterAddresses, this.mRandom);
        } else {
            Collections.shuffle(masterAddresses);
        }
        for (InetSocketAddress address : masterAddresses) {
            if (address.equals(this.getPrimaryMasterAddressCached(masterInquireClient))) continue;
            return address;
        }
        throw new UnavailableException("No standby masters available");
    }

    @Override
    public MasterSelectionPolicy.Type getType() {
        return MasterSelectionPolicy.Type.ANY_STANDBY_MASTER;
    }
}

