/*
 * Decompiled with CFR 0.152.
 */
package alluxio.membership;

import alluxio.conf.AlluxioConfiguration;
import alluxio.membership.AlluxioEtcdClient;
import alluxio.membership.MembershipManager;
import alluxio.membership.WorkerClusterView;
import alluxio.membership.WorkerServiceEntity;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerState;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonParseException;
import io.etcd.jetcd.KeyValue;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryMembershipManager
implements MembershipManager {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceRegistryMembershipManager.class);
    private AlluxioEtcdClient mAlluxioEtcdClient;

    public static ServiceRegistryMembershipManager create(AlluxioConfiguration conf) {
        return new ServiceRegistryMembershipManager(conf);
    }

    public ServiceRegistryMembershipManager(AlluxioConfiguration conf) {
        this(conf, AlluxioEtcdClient.getInstance(conf));
    }

    public ServiceRegistryMembershipManager(AlluxioConfiguration conf, AlluxioEtcdClient alluxioEtcdClient) {
        this.mAlluxioEtcdClient = alluxioEtcdClient;
    }

    @Override
    public void join(WorkerInfo workerInfo) throws IOException {
        LOG.info("Try joining Service Registry for worker:{} ", (Object)workerInfo);
        WorkerServiceEntity entity = new WorkerServiceEntity(workerInfo.getIdentity(), workerInfo.getAddress());
        this.mAlluxioEtcdClient.mServiceDiscovery.registerAndStartSync(entity);
        LOG.info("register to service registry for worker:{} ", (Object)workerInfo);
    }

    @Override
    public WorkerClusterView getAllMembers() throws IOException {
        return this.getLiveMembers();
    }

    @Override
    public WorkerClusterView getLiveMembers() throws IOException {
        Iterable<WorkerInfo> workerInfoIterable = this.parseWorkersFromEtcdKvPairs(this.mAlluxioEtcdClient.mServiceDiscovery.getAllLiveServices()).map(w -> new WorkerInfo().setIdentity(w.getIdentity()).setAddress(w.getWorkerNetAddress()).setState(WorkerState.LIVE))::iterator;
        return new WorkerClusterView(workerInfoIterable);
    }

    @Override
    public WorkerClusterView getFailedMembers() {
        return new WorkerClusterView(Collections.emptyList());
    }

    private Stream<WorkerServiceEntity> parseWorkersFromEtcdKvPairs(List<KeyValue> workerKvs) {
        return workerKvs.stream().map(this::parseWorkerServiceEntity).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<WorkerServiceEntity> parseWorkerServiceEntity(KeyValue etcdKvPair) {
        try {
            WorkerServiceEntity entity = new WorkerServiceEntity();
            entity.deserialize(etcdKvPair.getValue().getBytes());
            return Optional.of(entity);
        }
        catch (JsonParseException ex) {
            return Optional.empty();
        }
    }

    @Override
    @VisibleForTesting
    public String showAllMembers() {
        try {
            WorkerClusterView registeredWorkers = this.getAllMembers();
            String printFormat = "%s\t%s\t%s%n";
            StringBuilder sb = new StringBuilder(String.format(printFormat, "WorkerId", "Address", "Status"));
            for (WorkerInfo entity : registeredWorkers) {
                String entryLine = String.format(printFormat, entity.getIdentity(), entity.getAddress().getHost() + ":" + entity.getAddress().getRpcPort(), "ONLINE");
                sb.append(entryLine);
            }
            return sb.toString();
        }
        catch (IOException ex) {
            return String.format("Exception happened:%s", ex.getMessage());
        }
    }

    @Override
    @VisibleForTesting
    public void stopHeartBeat(WorkerInfo worker) throws IOException {
        WorkerServiceEntity entity = new WorkerServiceEntity(worker.getIdentity(), worker.getAddress());
        this.mAlluxioEtcdClient.mServiceDiscovery.unregisterService(entity.getServiceEntityName());
    }

    @Override
    public void decommission(WorkerInfo worker) throws IOException {
    }

    @Override
    public void close() throws Exception {
    }
}

