/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.AlluxioURI;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.file.options.DescendantType;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.underfs.Fingerprint;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsLoadResult;
import alluxio.underfs.UfsMode;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.ListOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.ThreadFactoryUtils;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.io.Closer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BaseUnderFileSystem
implements UnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(BaseUnderFileSystem.class);
    public static final Pair<AccessControlList, DefaultAccessControlList> EMPTY_ACL = new Pair<Object, Object>(null, null);
    protected final AlluxioURI mUri;
    protected final UnderFileSystemConfiguration mUfsConf;
    private final ExecutorService mAsyncIOExecutor;

    protected BaseUnderFileSystem(AlluxioURI uri, UnderFileSystemConfiguration ufsConf) {
        this.mUri = (AlluxioURI)Preconditions.checkNotNull((Object)uri, (Object)"uri");
        this.mUfsConf = (UnderFileSystemConfiguration)Preconditions.checkNotNull((Object)ufsConf, (Object)"ufsConf");
        this.mAsyncIOExecutor = Executors.newCachedThreadPool(ThreadFactoryUtils.build(uri.getPath() + "IOThread", true));
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register(() -> {
                if (this.mAsyncIOExecutor != null) {
                    this.mAsyncIOExecutor.shutdown();
                }
            });
        }
    }

    @Override
    public OutputStream create(String path) throws IOException {
        return this.create(path, CreateOptions.defaults(this.mUfsConf).setCreateParent(true));
    }

    @Override
    public boolean deleteDirectory(String path) throws IOException {
        return this.deleteDirectory(path, DeleteOptions.defaults());
    }

    @Override
    public boolean exists(String path) throws IOException {
        return this.isFile(path) || this.isDirectory(path);
    }

    @Override
    public Pair<AccessControlList, DefaultAccessControlList> getAclPair(String path) throws IOException {
        return EMPTY_ACL;
    }

    @Override
    public void setAclEntries(String path, List<AclEntry> aclEntries) throws IOException {
    }

    @Override
    public AlluxioConfiguration getConfiguration() {
        return this.mUfsConf;
    }

    @Override
    public String getFingerprint(String path) {
        try {
            UfsStatus status = this.getStatus(path);
            Pair<AccessControlList, DefaultAccessControlList> aclPair = this.getAclPair(path);
            if (aclPair == null || aclPair.getFirst() == null || !aclPair.getFirst().hasExtended()) {
                return Fingerprint.create(this.getUnderFSType(), status).serialize();
            }
            return Fingerprint.create(this.getUnderFSType(), status, null, aclPair.getFirst()).serialize();
        }
        catch (Exception e) {
            LOG.debug("Failed fingerprint. path: {} error: {}", (Object)path, (Object)e.toString());
            return "";
        }
    }

    @Override
    public Fingerprint getParsedFingerprint(String path) {
        return this.getParsedFingerprint(path, null);
    }

    @Override
    public Fingerprint getParsedFingerprint(String path, @Nullable String contentHash) {
        try {
            UfsStatus status = this.getStatus(path);
            Pair<AccessControlList, DefaultAccessControlList> aclPair = this.getAclPair(path);
            if (aclPair == null || aclPair.getFirst() == null || !aclPair.getFirst().hasExtended()) {
                return Fingerprint.create(this.getUnderFSType(), status, contentHash);
            }
            return Fingerprint.create(this.getUnderFSType(), status, contentHash, aclPair.getFirst());
        }
        catch (IOException e) {
            return Fingerprint.INVALID_FINGERPRINT;
        }
    }

    @Override
    public UfsMode getOperationMode(Map<String, UfsMode> physicalUfsState) {
        UfsMode ufsMode = physicalUfsState.get(this.mUri.getRootPath());
        if (ufsMode != null) {
            return ufsMode;
        }
        return UfsMode.READ_WRITE;
    }

    @Override
    public List<String> getPhysicalStores() {
        return new ArrayList<String>(Arrays.asList(this.mUri.getRootPath()));
    }

    @Override
    public boolean isObjectStorage() {
        return false;
    }

    @Override
    public boolean isSeekable() {
        return false;
    }

    @Override
    @Nullable
    public Iterator<UfsStatus> listStatusIterable(String path, ListOptions options, String startAfter, int batchSize) throws IOException {
        Object[] result = this.listStatus(path, options);
        if (result == null) {
            return null;
        }
        return Iterators.forArray((Object[])result);
    }

    @Override
    public void performListingAsync(String path, @Nullable String continuationToken, @Nullable String startAfter, DescendantType descendantType, boolean checkStatus, Consumer<UfsLoadResult> onComplete, Consumer<Throwable> onError) {
        this.mAsyncIOExecutor.submit(() -> {
            try {
                int itemCount;
                UfsStatus[] items;
                UfsStatus baseStatus;
                block13: {
                    baseStatus = null;
                    if (checkStatus) {
                        try {
                            baseStatus = this.getStatus(path);
                            if (baseStatus == null && !this.isObjectStorage()) {
                                onComplete.accept(new UfsLoadResult(Stream.empty(), 0, null, null, false, false, false));
                                return;
                            }
                            if (baseStatus != null && (descendantType == DescendantType.NONE || baseStatus.isFile())) {
                                onComplete.accept(new UfsLoadResult(Stream.of(baseStatus), 1, null, new AlluxioURI(baseStatus.getName()), false, baseStatus.isFile(), this.isObjectStorage()));
                                return;
                            }
                        }
                        catch (FileNotFoundException e) {
                            if (this.isObjectStorage()) break block13;
                            onComplete.accept(new UfsLoadResult(Stream.empty(), 0, null, null, false, false, false));
                            return;
                        }
                    }
                }
                if ((items = this.listStatus(path, ListOptions.defaults().setRecursive(descendantType == DescendantType.ALL))) != null) {
                    if (descendantType == DescendantType.NONE && items.length > 0) {
                        assert (this.isObjectStorage() && this instanceof ObjectUnderFileSystem);
                        ObjectUnderFileSystem.ObjectPermissions permissions = ((ObjectUnderFileSystem)this).getPermissions();
                        items = new UfsStatus[]{new UfsDirectoryStatus("", permissions.getOwner(), permissions.getGroup(), permissions.getMode())};
                    }
                    Arrays.sort(items, Comparator.comparing(UfsStatus::getName));
                    for (UfsStatus item : items) {
                        item.setName(PathUtils.concatPath((Object)path, (Object)item.getName()));
                    }
                }
                if (items != null && items.length == 0) {
                    items = null;
                }
                UfsStatus firstItem = baseStatus != null ? baseStatus : (items != null ? items[0] : null);
                UfsStatus lastItem = items == null ? firstItem : items[items.length - 1];
                Stream<Object> itemStream = items == null ? Stream.empty() : Arrays.stream(items);
                int n = itemCount = items == null ? 0 : items.length;
                if (baseStatus != null) {
                    itemStream = Stream.concat(Stream.of(baseStatus), itemStream);
                    ++itemCount;
                }
                onComplete.accept(new UfsLoadResult(itemStream, itemCount, null, lastItem == null ? null : new AlluxioURI(lastItem.getName()), false, firstItem != null && firstItem.isFile(), this.isObjectStorage()));
            }
            catch (Throwable t) {
                onError.accept(t);
            }
        });
    }

    @Override
    @Nullable
    public UfsStatus[] listStatus(String path, ListOptions options) throws IOException {
        if (!options.isRecursive()) {
            return this.listStatus(path);
        }
        path = BaseUnderFileSystem.validatePath(path);
        ArrayList<UfsStatus> returnPaths = new ArrayList<UfsStatus>();
        ArrayDeque<Pair<String, UfsStatus>> pathsToProcess = new ArrayDeque<Pair<String, UfsStatus>>();
        UfsStatus[] statuses = this.listStatus(path);
        if (statuses == null) {
            return null;
        }
        for (UfsStatus status : statuses) {
            pathsToProcess.add(new Pair<String, UfsStatus>(PathUtils.concatPath((Object)path, (Object)status.getName()), status));
        }
        while (!pathsToProcess.isEmpty()) {
            UfsStatus[] children;
            Pair pathToProcessPair = (Pair)pathsToProcess.remove();
            String pathToProcess = (String)pathToProcessPair.getFirst();
            UfsStatus pathStatus = (UfsStatus)pathToProcessPair.getSecond();
            int beginIndex = path.endsWith("/") ? path.length() : path.length() + 1;
            returnPaths.add(pathStatus.setName(pathToProcess.substring(beginIndex)));
            if (!pathStatus.isDirectory() || (children = this.listStatus(pathToProcess)) == null) continue;
            for (UfsStatus child : children) {
                pathsToProcess.add(new Pair<String, UfsStatus>(PathUtils.concatPath((Object)pathToProcess, (Object)child.getName()), child));
            }
        }
        return returnPaths.toArray(new UfsStatus[0]);
    }

    @Override
    public InputStream open(String path) throws IOException {
        return this.open(path, OpenOptions.defaults());
    }

    @Override
    public boolean mkdirs(String path) throws IOException {
        return this.mkdirs(path, MkdirsOptions.defaults(this.mUfsConf));
    }

    @Override
    public AlluxioURI resolveUri(AlluxioURI ufsBaseUri, String alluxioPath) {
        return new AlluxioURI(ufsBaseUri, PathUtils.concatPath((Object)ufsBaseUri.getPath(), (Object)alluxioPath), false);
    }

    protected static String validatePath(String path) {
        return new AlluxioURI(path).toString();
    }
}

