/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.retry.CountingRetry;
import alluxio.retry.RetryPolicy;
import alluxio.retry.RetryUtils;
import alluxio.underfs.ContentHashable;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class ObjectMultipartUploadOutputStream
extends OutputStream
implements ContentHashable {
    protected static final Logger LOG = LoggerFactory.getLogger(ObjectMultipartUploadOutputStream.class);
    protected static final long MINIMUM_PART_SIZE = 0x500000L;
    protected static final long MAXIMUM_PART_SIZE = 0x140000000L;
    protected final String mBucketName;
    protected final String mKey;
    protected final Supplier<RetryPolicy> mRetryPolicy = () -> new CountingRetry(5);
    protected final byte[] mSingleCharWrite = new byte[1];
    protected final long mPartitionSize;
    private final AtomicInteger mPartNumber;
    private final ListeningExecutorService mExecutor;
    private final List<ListenableFuture<?>> mFutures = new ArrayList();
    protected boolean mClosed = false;
    protected long mPartitionOffset;
    @Nullable
    private Long mUploadPartTimeoutMills;
    private boolean mMultiPartUploadInitialized = false;
    @Nullable
    private byte[] mUploadPartArray;

    public ObjectMultipartUploadOutputStream(String bucketName, String key, ListeningExecutorService executor, long multipartUploadPartitionSize, AlluxioConfiguration ufsConf) {
        Preconditions.checkArgument((bucketName != null && !bucketName.isEmpty() ? 1 : 0) != 0, (Object)"Bucket name must not be null or empty.");
        this.mBucketName = bucketName;
        this.mExecutor = executor;
        this.mKey = key;
        this.mPartNumber = new AtomicInteger(1);
        this.mPartitionSize = Math.min(Math.max(0x500000L, multipartUploadPartitionSize), 0x140000000L);
        if (ufsConf.isSet(PropertyKey.UNDERFS_OBJECT_STORE_MULTIPART_UPLOAD_TIMEOUT)) {
            this.mUploadPartTimeoutMills = ufsConf.getDuration(PropertyKey.UNDERFS_OBJECT_STORE_MULTIPART_UPLOAD_TIMEOUT).toMillis();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.mSingleCharWrite[0] = (byte)b;
        this.write(this.mSingleCharWrite);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null || len == 0) {
            return;
        }
        Preconditions.checkNotNull((Object)b);
        Preconditions.checkArgument((off >= 0 && off <= b.length && len >= 0 && off + len <= b.length ? 1 : 0) != 0);
        if (this.mUploadPartArray == null) {
            this.initNewUploadPartArray();
        }
        if (this.mPartitionOffset + (long)len <= this.mPartitionSize) {
            System.arraycopy(b, off, this.mUploadPartArray, (int)this.mPartitionOffset, len);
            this.mPartitionOffset += (long)len;
        } else {
            int firstLen = (int)(this.mPartitionSize - this.mPartitionOffset);
            System.arraycopy(b, off, this.mUploadPartArray, (int)this.mPartitionOffset, firstLen);
            this.mPartitionOffset += (long)firstLen;
            this.uploadPart();
            this.write(b, off + firstLen, len - firstLen);
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.mMultiPartUploadInitialized) {
            return;
        }
        if (this.mPartitionOffset > 0x500000L) {
            this.uploadPart();
        }
        this.waitForAllPartsUpload();
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        if (!this.mMultiPartUploadInitialized) {
            if (this.mUploadPartArray == null) {
                LOG.debug("Multipart upload output stream closed without uploading any data.");
                RetryUtils.retry("put empty object for key" + this.mKey, () -> this.createEmptyObject(this.mKey), this.mRetryPolicy.get());
            } else {
                byte[] buf = this.mUploadPartArray;
                this.mUploadPartArray = null;
                try {
                    RetryUtils.retry("put object for key" + this.mKey, () -> this.putObject(this.mKey, buf, this.mPartitionOffset), this.mRetryPolicy.get());
                }
                catch (Exception e) {
                    LOG.error("Failed to upload {}", (Object)this.mKey, (Object)e);
                    throw new IOException(e);
                }
            }
            return;
        }
        try {
            if (this.mUploadPartArray != null) {
                int partNumber = this.mPartNumber.getAndIncrement();
                byte[] buf = this.mUploadPartArray;
                this.uploadPart(buf, partNumber, true, this.mPartitionOffset);
                this.mUploadPartArray = null;
            }
            this.waitForAllPartsUpload();
            RetryUtils.retry("complete multipart upload", this::completeMultipartUploadInternal, this.mRetryPolicy.get());
        }
        catch (Exception e) {
            LOG.error("Failed to upload {}", (Object)this.mKey, (Object)e);
            throw new IOException(e);
        }
    }

    private void initNewUploadPartArray() {
        this.mUploadPartArray = new byte[(int)this.mPartitionSize];
        this.mPartitionOffset = 0L;
        LOG.debug("Init new mUploadPartArray @ {}", (Object)this.mUploadPartArray);
    }

    protected void uploadPart() throws IOException {
        if (this.mUploadPartArray == null) {
            return;
        }
        if (!this.mMultiPartUploadInitialized) {
            RetryUtils.retry("init multipart upload", this::initMultipartUploadInternal, this.mRetryPolicy.get());
            this.mMultiPartUploadInitialized = true;
        }
        int partNumber = this.mPartNumber.getAndIncrement();
        byte[] buf = this.mUploadPartArray;
        this.uploadPart(buf, partNumber, false, this.mPartitionOffset);
        this.mUploadPartArray = null;
    }

    protected void uploadPart(byte[] buf, int partNumber, boolean isLastPart, long length) throws IOException {
        Callable<Object> callable = () -> {
            try {
                RetryUtils.retry("upload part for key " + this.mKey + " and part number " + partNumber, () -> this.uploadPartInternal(buf, partNumber, isLastPart, length), this.mRetryPolicy.get());
                return null;
            }
            catch (Exception e) {
                LOG.error("Failed to upload part {} for key {}", new Object[]{partNumber, this.mKey, e});
                throw new IOException(e);
            }
        };
        ListenableFuture futureTag = this.mExecutor.submit(callable);
        this.mFutures.add(futureTag);
    }

    protected void abortMultiPartUpload() throws IOException {
        RetryUtils.retry("abort multipart upload for key " + this.mKey, this::abortMultipartUploadInternal, this.mRetryPolicy.get());
    }

    protected void waitForAllPartsUpload() throws IOException {
        try {
            for (ListenableFuture<?> future : this.mFutures) {
                if (this.mUploadPartTimeoutMills == null) {
                    future.get();
                    continue;
                }
                future.get(this.mUploadPartTimeoutMills.longValue(), TimeUnit.MILLISECONDS);
            }
        }
        catch (ExecutionException e) {
            Futures.allAsList(this.mFutures).cancel(true);
            this.abortMultiPartUpload();
            throw new IOException("Part upload failed in multipart upload with to " + this.mKey, e);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted object upload.", (Throwable)e);
            Futures.allAsList(this.mFutures).cancel(true);
            this.abortMultiPartUpload();
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            LOG.error("timeout when upload part");
            Futures.allAsList(this.mFutures).cancel(true);
            this.abortMultiPartUpload();
            throw new IOException("timeout when upload part " + this.mKey, e);
        }
        this.mFutures.clear();
    }

    protected abstract void uploadPartInternal(byte[] var1, int var2, boolean var3, long var4) throws IOException;

    protected abstract void initMultipartUploadInternal() throws IOException;

    protected abstract void completeMultipartUploadInternal() throws IOException;

    protected abstract void abortMultipartUploadInternal() throws IOException;

    protected abstract void createEmptyObject(String var1) throws IOException;

    protected abstract void putObject(String var1, byte[] var2, long var3) throws IOException;
}

