/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.cli.CommandUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.util.StreamUtils;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationUtils.class);
    private static final String MASTERS = "masters";
    private static final String WORKERS = "workers";

    private ConfigurationUtils() {
    }

    public static List<InetSocketAddress> getEmbeddedJournalAddresses(AlluxioConfiguration conf, NetworkAddressUtils.ServiceType serviceType) {
        Preconditions.checkState((serviceType == NetworkAddressUtils.ServiceType.MASTER_RAFT || serviceType == NetworkAddressUtils.ServiceType.JOB_MASTER_RAFT ? 1 : 0) != 0);
        if (serviceType == NetworkAddressUtils.ServiceType.MASTER_RAFT) {
            return ConfigurationUtils.getMasterEmbeddedJournalAddresses(conf);
        }
        return ConfigurationUtils.getJobMasterEmbeddedJournalAddresses(conf);
    }

    public static List<InetSocketAddress> getMasterEmbeddedJournalAddresses(AlluxioConfiguration conf) {
        PropertyKey property = PropertyKey.MASTER_EMBEDDED_JOURNAL_ADDRESSES;
        if (conf.isSet(property)) {
            return ConfigurationUtils.parseInetSocketAddresses(conf.getList(property));
        }
        return Arrays.asList(NetworkAddressUtils.getConnectAddress(NetworkAddressUtils.ServiceType.MASTER_RAFT, conf));
    }

    public static List<InetSocketAddress> getJobMasterEmbeddedJournalAddresses(AlluxioConfiguration conf) {
        PropertyKey jobMasterProperty = PropertyKey.JOB_MASTER_EMBEDDED_JOURNAL_ADDRESSES;
        if (conf.isSet(jobMasterProperty)) {
            return ConfigurationUtils.parseInetSocketAddresses(conf.getList(jobMasterProperty));
        }
        PropertyKey masterProperty = PropertyKey.MASTER_EMBEDDED_JOURNAL_ADDRESSES;
        int jobRaftPort = NetworkAddressUtils.getPort(NetworkAddressUtils.ServiceType.JOB_MASTER_RAFT, conf);
        if (conf.isSet(masterProperty)) {
            return ConfigurationUtils.overridePort(ConfigurationUtils.getMasterEmbeddedJournalAddresses(conf), jobRaftPort);
        }
        return Arrays.asList(NetworkAddressUtils.getConnectAddress(NetworkAddressUtils.ServiceType.JOB_MASTER_RAFT, conf));
    }

    public static List<InetSocketAddress> getMasterRpcAddresses(AlluxioConfiguration conf) {
        if (conf.isSet(PropertyKey.MASTER_RPC_ADDRESSES)) {
            return ConfigurationUtils.parseInetSocketAddresses(conf.getList(PropertyKey.MASTER_RPC_ADDRESSES));
        }
        int rpcPort = NetworkAddressUtils.getPort(NetworkAddressUtils.ServiceType.MASTER_RPC, conf);
        return ConfigurationUtils.overridePort(ConfigurationUtils.getEmbeddedJournalAddresses(conf, NetworkAddressUtils.ServiceType.MASTER_RAFT), rpcPort);
    }

    public static List<InetSocketAddress> getJobMasterRpcAddresses(AlluxioConfiguration conf) {
        if (conf.isSet(PropertyKey.JOB_MASTER_RPC_ADDRESSES)) {
            return ConfigurationUtils.parseInetSocketAddresses(conf.getList(PropertyKey.JOB_MASTER_RPC_ADDRESSES));
        }
        int jobRpcPort = NetworkAddressUtils.getPort(NetworkAddressUtils.ServiceType.JOB_MASTER_RPC, conf);
        if (conf.isSet(PropertyKey.MASTER_RPC_ADDRESSES)) {
            List<InetSocketAddress> addrs = ConfigurationUtils.parseInetSocketAddresses(conf.getList(PropertyKey.MASTER_RPC_ADDRESSES));
            return ConfigurationUtils.overridePort(addrs, jobRpcPort);
        }
        return ConfigurationUtils.overridePort(ConfigurationUtils.getEmbeddedJournalAddresses(conf, NetworkAddressUtils.ServiceType.JOB_MASTER_RAFT), jobRpcPort);
    }

    public static List<InetSocketAddress> overridePort(List<InetSocketAddress> addrs, int port) {
        return StreamUtils.map(addr -> InetSocketAddress.createUnresolved(addr.getHostString(), port), addrs);
    }

    public static List<InetSocketAddress> parseInetSocketAddresses(List<String> addresses) {
        ArrayList<InetSocketAddress> inetSocketAddresses = new ArrayList<InetSocketAddress>(addresses.size());
        for (String address : addresses) {
            try {
                inetSocketAddresses.add(NetworkAddressUtils.parseInetSocketAddress(address));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to parse host:port: " + address, e);
            }
        }
        return inetSocketAddresses;
    }

    public static boolean jobMasterHostConfigured(AlluxioConfiguration conf) {
        boolean usingZk = conf.getBoolean(PropertyKey.ZOOKEEPER_ENABLED) && conf.isSet(PropertyKey.ZOOKEEPER_ADDRESS);
        return conf.isSet(PropertyKey.JOB_MASTER_HOSTNAME) || usingZk || ConfigurationUtils.getJobMasterRpcAddresses(conf).size() > 1;
    }

    public static String getMasterHostNotConfiguredMessage(String serviceName) {
        return ConfigurationUtils.getHostNotConfiguredMessage(serviceName, "master", PropertyKey.MASTER_HOSTNAME, PropertyKey.MASTER_EMBEDDED_JOURNAL_ADDRESSES);
    }

    public static String getJobMasterHostNotConfiguredMessage(String serviceName) {
        return ConfigurationUtils.getHostNotConfiguredMessage(serviceName, "job master", PropertyKey.JOB_MASTER_HOSTNAME, PropertyKey.JOB_MASTER_EMBEDDED_JOURNAL_ADDRESSES);
    }

    private static String getHostNotConfiguredMessage(String serviceName, String masterName, PropertyKey masterHostnameKey, PropertyKey embeddedJournalKey) {
        return ExceptionMessage.UNABLE_TO_DETERMINE_MASTER_HOSTNAME.getMessage(serviceName, masterName, masterHostnameKey.getName(), PropertyKey.ZOOKEEPER_ENABLED.getName(), PropertyKey.ZOOKEEPER_ADDRESS.getName(), embeddedJournalKey.getName());
    }

    public static float checkRatio(AlluxioConfiguration conf, PropertyKey key) {
        double value = conf.getDouble(key);
        Preconditions.checkState((value <= 1.0 ? 1 : 0) != 0, (String)"Property %s must not exceed 1, but it is set to %s", (Object)key.getName(), (Object)value);
        Preconditions.checkState((value >= 0.0 ? 1 : 0) != 0, (String)"Property %s must be non-negative, but it is set to %s", (Object)key.getName(), (Object)value);
        return (float)value;
    }

    public static boolean masterHostConfigured(AlluxioConfiguration conf) {
        boolean usingZk = conf.getBoolean(PropertyKey.ZOOKEEPER_ENABLED) && conf.isSet(PropertyKey.ZOOKEEPER_ADDRESS);
        return conf.isSet(PropertyKey.MASTER_HOSTNAME) || usingZk || ConfigurationUtils.getMasterRpcAddresses(conf).size() > 1;
    }

    public static boolean isHaMode(AlluxioConfiguration conf) {
        return conf.getBoolean(PropertyKey.ZOOKEEPER_ENABLED) || ConfigurationUtils.getMasterRpcAddresses(conf).size() > 1;
    }

    public static String valueAsString(String value) {
        return value == null ? "(no value set)" : value;
    }

    public static String getSchemeAuthority(AlluxioConfiguration conf) {
        if (conf.getBoolean(PropertyKey.ZOOKEEPER_ENABLED)) {
            return "alluxio://zk@" + conf.get(PropertyKey.ZOOKEEPER_ADDRESS);
        }
        List<InetSocketAddress> addresses = ConfigurationUtils.getMasterRpcAddresses(conf);
        if (addresses.size() > 1) {
            return "alluxio://" + addresses.stream().map(InetSocketAddress::toString).collect(Collectors.joining(","));
        }
        return "alluxio://" + conf.get(PropertyKey.MASTER_HOSTNAME) + ":" + conf.get(PropertyKey.MASTER_RPC_PORT);
    }

    public static List<String> parseAsList(String value, String delimiter) {
        return Lists.newArrayList((Iterable)Splitter.on((String)delimiter).trimResults().omitEmptyStrings().split((CharSequence)value));
    }

    @Nullable
    private static Set<String> readNodeList(String fileName, AlluxioConfiguration conf) {
        String confDir = conf.getString(PropertyKey.CONF_DIR);
        return CommandUtils.readNodeList(confDir, fileName);
    }

    public static Set<String> getMasterHostnames(AlluxioConfiguration conf) {
        return ConfigurationUtils.readNodeList(MASTERS, conf);
    }

    public static Set<String> getWorkerHostnames(AlluxioConfiguration conf) {
        return ConfigurationUtils.readNodeList(WORKERS, conf);
    }

    public static Set<String> getServerHostnames(AlluxioConfiguration conf) {
        return Sets.union(ConfigurationUtils.getMasterHostnames(conf), ConfigurationUtils.getWorkerHostnames(conf));
    }
}

