/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.AlluxioURI;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.DeleteOptions;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class UnderFileSystemUtils {
    public static void deleteDirIfExists(UnderFileSystem ufs, String path) throws IOException {
        if (ufs.isDirectory(path) && !ufs.deleteDirectory(path, DeleteOptions.defaults().setRecursive(true))) {
            throw new IOException("Folder " + path + " already exists but can not be deleted.");
        }
    }

    public static void mkdirIfNotExists(UnderFileSystem ufs, String path) throws IOException {
        if (!ufs.isDirectory(path) && !ufs.mkdirs(path)) {
            throw new IOException("Failed to make folder: " + path);
        }
    }

    public static void touch(UnderFileSystem ufs, String path) throws IOException {
        OutputStream os = ufs.create(path);
        os.close();
    }

    public static void deleteFileIfExists(UnderFileSystem ufs, String path) {
        try {
            if (ufs.isFile(path)) {
                ufs.deleteFile(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isGcs(UnderFileSystem ufs) {
        return "gcs".equals(ufs.getUnderFSType());
    }

    public static boolean isLocal(UnderFileSystem ufs) {
        return "local".equals(ufs.getUnderFSType());
    }

    public static boolean isHdfs(UnderFileSystem ufs) {
        return "hdfs".equals(ufs.getUnderFSType());
    }

    public static boolean isOss(UnderFileSystem ufs) {
        return "oss".equals(ufs.getUnderFSType());
    }

    public static boolean isS3(UnderFileSystem ufs) {
        return "s3".equals(ufs.getUnderFSType()) || "s3a".equals(ufs.getUnderFSType());
    }

    public static boolean isWeb(UnderFileSystem ufs) {
        return "web".equals(ufs.getUnderFSType());
    }

    public static boolean isCephFS(UnderFileSystem ufs) {
        return "cephfs".equals(ufs.getUnderFSType());
    }

    public static String getBucketName(AlluxioURI uri) {
        return uri.getAuthority().toString();
    }

    public static String approximateContentHash(long length, long modTime) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append("len:");
        sb.append(length);
        sb.append(", ");
        sb.append("modtime:");
        sb.append(modTime);
        sb.append(')');
        return sb.toString();
    }

    private UnderFileSystemUtils() {
    }
}

