/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.WorkerIdentity;
import alluxio.wire.InvalidVersionParsingException;
import alluxio.wire.MissingRequiredFieldsParsingException;
import alluxio.wire.ProtoParsingException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.Longs;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

@JsonAdapter(value=GsonSerde.class)
@JsonDeserialize(converter=JacksonDeserializeConverter.class)
@JsonSerialize(using=JacksonSerializer.class)
@Immutable
public final class WorkerIdentity
implements Serializable {
    private static final long serialVersionUID = -3241509286694514179L;
    private final byte[] mId;
    private final int mVersion;
    private transient int mHashcode;

    WorkerIdentity(byte[] id, int version) {
        this.mId = id;
        this.mVersion = version;
    }

    public static WorkerIdentity fromProto(alluxio.grpc.WorkerIdentity proto) throws ProtoParsingException {
        return Parsers.fromProto(proto);
    }

    public alluxio.grpc.WorkerIdentity toProto() {
        return Parsers.toProto(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerIdentity that = (WorkerIdentity)o;
        return this.mVersion == that.mVersion && Arrays.equals(this.mId, that.mId);
    }

    public int hashCode() {
        int hashCode = this.mHashcode;
        if (hashCode == 0) {
            this.mHashcode = hashCode = Arrays.hashCode(this.mId) * 31 + this.mVersion;
        }
        return hashCode;
    }

    public static WorkerIdentity fromString(String workerIdentityStr) throws InvalidArgumentException {
        String prefix = "worker-";
        String errStr = "Unrecognized worker identity string";
        if (!workerIdentityStr.startsWith(prefix)) {
            throw new InvalidArgumentException(errStr + ": " + workerIdentityStr);
        }
        String idStr = workerIdentityStr.substring(prefix.length());
        try {
            return ParserV1.INSTANCE.fromUUID(idStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return ParserV0.INSTANCE.fromLong(Long.parseLong(idStr));
            }
            catch (NumberFormatException ex) {
                throw new InvalidArgumentException(errStr + ": " + workerIdentityStr);
            }
        }
    }

    public String toString() {
        return String.format("worker-%s", Parsers.getParserOfVersion(this.mVersion).getVersionSpecificRepresentation(this));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Parser parser;
        in.defaultReadObject();
        try {
            parser = Parsers.getParserOfVersion(this.mVersion);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidObjectException("Unrecognized identity version: " + this.mVersion);
        }
        try {
            parser.fromProto(parser.toProto(this));
        }
        catch (ProtoParsingException e) {
            throw new InvalidObjectException("Validation after deserialization failed: data corruption during serialization and/or transmission of the object: " + e);
        }
    }

    public static enum HashFunnel implements Funnel<WorkerIdentity>
    {
        INSTANCE;


        public void funnel(@Nonnull WorkerIdentity from, PrimitiveSink into) {
            into.putBytes(from.mId).putInt(from.mVersion);
        }
    }

    public static class JacksonDeserializeConverter
    extends StdConverter<JacksonDeserializeIntermediate, WorkerIdentity> {
        public WorkerIdentity convert(JacksonDeserializeIntermediate value) {
            WorkerIdentity.Builder protoBuilder = alluxio.grpc.WorkerIdentity.newBuilder();
            if (value.mIdHexEncoded != null) {
                try {
                    byte[] identifier = Hex.decodeHex((String)value.mIdHexEncoded);
                    protoBuilder.setIdentifier(UnsafeByteOperations.unsafeWrap((byte[])identifier));
                }
                catch (DecoderException e) {
                    throw new IllegalArgumentException("Malformed hex encoded identifier: " + value.mIdHexEncoded, e);
                }
            }
            if (value.mVersion != null) {
                protoBuilder.setVersion(value.mVersion.intValue());
            }
            alluxio.grpc.WorkerIdentity proto = protoBuilder.build();
            try {
                return WorkerIdentity.fromProto(proto);
            }
            catch (ProtoParsingException e) {
                throw new IllegalArgumentException("Invalid worker identity: " + proto, e);
            }
        }
    }

    private static class JacksonDeserializeIntermediate {
        @JsonProperty(value="version")
        @Nullable
        private final String mIdHexEncoded;
        @JsonProperty(value="identifier")
        @Nullable
        private final Integer mVersion;

        @JsonCreator
        public JacksonDeserializeIntermediate(@Nullable @JsonProperty(value="version") Integer version, @Nullable @JsonProperty(value="identifier") String hexEncodedIdentifier) {
            this.mVersion = version;
            this.mIdHexEncoded = hexEncodedIdentifier;
        }
    }

    public static class JacksonSerializer
    extends com.fasterxml.jackson.databind.JsonSerializer<WorkerIdentity> {
        public static final JacksonSerializer INSTANCE = new JacksonSerializer();

        private JacksonSerializer() {
        }

        public void serialize(WorkerIdentity value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeNumberField("version", value.mVersion);
            gen.writeStringField("identifier", Hex.encodeHexString((byte[])value.mId));
            gen.writeEndObject();
        }
    }

    private static enum WorkerIdentityDeserializer implements JsonDeserializer<WorkerIdentity>
    {
        INSTANCE;


        public WorkerIdentity deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement identifierElement;
            if (typeOfT != WorkerIdentity.class) {
                throw new JsonParseException("Wrong type for deserialization, expecting " + WorkerIdentity.class.getSimpleName() + ", got " + typeOfT);
            }
            if (!json.isJsonObject()) {
                throw new JsonParseException(String.format("Expecting worker identity to be an object, got %s", json.getClass().getSimpleName()));
            }
            JsonObject object = json.getAsJsonObject();
            WorkerIdentity.Builder protoBuilder = alluxio.grpc.WorkerIdentity.newBuilder();
            JsonElement versionElement = object.get("version");
            if (versionElement != null) {
                int version = this.parseVersion(versionElement);
                protoBuilder.setVersion(version);
            }
            if ((identifierElement = object.get("identifier")) != null) {
                byte[] identifier = this.parseIdentifier(identifierElement);
                protoBuilder.setIdentifier(UnsafeByteOperations.unsafeWrap((byte[])identifier));
            }
            alluxio.grpc.WorkerIdentity proto = protoBuilder.build();
            try {
                return WorkerIdentity.fromProto(proto);
            }
            catch (ProtoParsingException e) {
                throw new JsonParseException("Invalid worker identity: " + proto, (Throwable)e);
            }
        }

        private int parseVersion(JsonElement versionElement) throws JsonParseException {
            JsonPrimitive versionPrimitive;
            if (versionElement.isJsonPrimitive() && (versionPrimitive = versionElement.getAsJsonPrimitive()).isNumber()) {
                return versionPrimitive.getAsInt();
            }
            throw new JsonParseException("Expected field version to be integer, got " + versionElement);
        }

        private byte[] parseIdentifier(JsonElement identifierElement) throws JsonParseException {
            JsonPrimitive identifierPrimitive;
            if (identifierElement.isJsonPrimitive() && (identifierPrimitive = identifierElement.getAsJsonPrimitive()).isString()) {
                try {
                    return Hex.decodeHex((String)identifierPrimitive.getAsString());
                }
                catch (DecoderException e) {
                    throw new JsonParseException(String.format("Invalid hex representation of identifier bytes: %s", identifierPrimitive.getAsString()), (Throwable)e);
                }
            }
            throw new JsonParseException("Expected field identifier to be string, got " + identifierElement);
        }
    }

    private static enum WorkerIdentitySerializer implements JsonSerializer<WorkerIdentity>
    {
        INSTANCE;


        public JsonElement serialize(WorkerIdentity src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("version", (Number)src.mVersion);
            json.addProperty("identifier", Hex.encodeHexString((byte[])src.mId));
            return json;
        }
    }

    public static enum GsonSerde implements JsonSerializer<WorkerIdentity>,
    JsonDeserializer<WorkerIdentity>
    {
        INSTANCE;

        static final String FIELD_VERSION = "version";
        static final String FIELD_IDENTIFIER = "identifier";

        public JsonSerializer<WorkerIdentity> getSerializer() {
            return WorkerIdentitySerializer.INSTANCE;
        }

        public JsonDeserializer<WorkerIdentity> getDeserializer() {
            return WorkerIdentityDeserializer.INSTANCE;
        }

        public WorkerIdentity deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return (WorkerIdentity)this.getDeserializer().deserialize(json, typeOfT, context);
        }

        public JsonElement serialize(WorkerIdentity src, Type typeOfSrc, JsonSerializationContext context) {
            return this.getSerializer().serialize((Object)src, typeOfSrc, context);
        }
    }

    public static class ParserV1
    extends Parser {
        public static final ParserV1 INSTANCE = new ParserV1();
        public static final int VERSION = 1;
        private static final int ID_LENGTH_BYTES = 16;

        private ParserV1() {
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        protected byte[] parseIdentifier(ByteString identifier) throws ProtoParsingException {
            if (identifier.size() != 16) {
                throw new ProtoParsingException(String.format("Invalid identifier length: %s, expecting %s. identifier: %s", identifier.size(), 16, Hex.encodeHexString((byte[])identifier.toByteArray())));
            }
            return identifier.toByteArray();
        }

        @Override
        protected UUID getVersionSpecificRepresentation0(WorkerIdentity identity) {
            ByteBuffer buffer = ByteBuffer.wrap(identity.mId);
            long msb = buffer.getLong();
            long lsb = buffer.getLong();
            return new UUID(msb, lsb);
        }

        public WorkerIdentity fromUUID(UUID uuid) {
            ByteBuffer buffer = ByteBuffer.allocate(16);
            buffer.putLong(uuid.getMostSignificantBits());
            buffer.putLong(uuid.getLeastSignificantBits());
            byte[] bytes = buffer.array();
            return new WorkerIdentity(bytes, 1);
        }

        public WorkerIdentity fromUUID(String uuid) throws IllegalArgumentException {
            UUID id = UUID.fromString(uuid);
            return this.fromUUID(id);
        }

        public UUID toUUID(WorkerIdentity identity) throws IllegalArgumentException {
            this.ensureVersionMatch(identity);
            return this.getVersionSpecificRepresentation0(identity);
        }
    }

    public static class ParserV0
    extends Parser {
        public static final ParserV0 INSTANCE = new ParserV0();
        public static final int VERSION = 0;
        private static final int ID_LENGTH_BYTES = 8;

        private ParserV0() {
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        protected byte[] parseIdentifier(ByteString identifier) throws ProtoParsingException {
            byte[] idBytes = identifier.toByteArray();
            if (idBytes.length != 8) {
                throw new ProtoParsingException(String.format("Invalid identifier length: %s, expecting %s. identifier: %s", identifier.size(), 8, Hex.encodeHexString((byte[])idBytes)));
            }
            return idBytes;
        }

        @Override
        protected Long getVersionSpecificRepresentation0(WorkerIdentity workerIdentity) {
            return Longs.fromByteArray((byte[])workerIdentity.mId);
        }

        public WorkerIdentity fromLong(long workerId) {
            byte[] id = Longs.toByteArray((long)workerId);
            return new WorkerIdentity(id, 0);
        }

        public long toLong(WorkerIdentity identity) throws IllegalArgumentException {
            this.ensureVersionMatch(identity);
            return this.getVersionSpecificRepresentation0(identity);
        }
    }

    static abstract class Parser {
        Parser() {
        }

        protected abstract int getVersion();

        protected abstract byte[] parseIdentifier(ByteString var1) throws ProtoParsingException;

        public Object getVersionSpecificRepresentation(WorkerIdentity identity) {
            this.ensureVersionMatch(identity);
            return this.getVersionSpecificRepresentation0(identity);
        }

        protected abstract Object getVersionSpecificRepresentation0(WorkerIdentity var1);

        protected void ensureVersionMatch(WorkerIdentity identity) throws IllegalArgumentException {
            if (identity.mVersion != this.getVersion()) {
                throw new IllegalArgumentException(String.format("Identity definition version mismatch, expected %s, got %s", this.getVersion(), identity.mVersion));
            }
        }

        public alluxio.grpc.WorkerIdentity toProto(WorkerIdentity workerIdentity) {
            WorkerIdentity.Builder builder = alluxio.grpc.WorkerIdentity.newBuilder();
            return builder.setVersion(workerIdentity.mVersion).setIdentifier(UnsafeByteOperations.unsafeWrap((byte[])workerIdentity.mId)).build();
        }

        public WorkerIdentity fromProto(alluxio.grpc.WorkerIdentity workerIdentityProto) throws ProtoParsingException {
            if (!workerIdentityProto.hasVersion()) {
                Descriptors.FieldDescriptor descriptor = workerIdentityProto.getDescriptorForType().findFieldByNumber(2);
                throw new MissingRequiredFieldsParsingException(descriptor, (Message)workerIdentityProto);
            }
            int version = workerIdentityProto.getVersion();
            if (version != this.getVersion()) {
                throw new InvalidVersionParsingException(version, this.getVersion());
            }
            if (!workerIdentityProto.hasIdentifier()) {
                Descriptors.FieldDescriptor descriptor = workerIdentityProto.getDescriptorForType().findFieldByNumber(1);
                throw new MissingRequiredFieldsParsingException(descriptor, (Message)workerIdentityProto);
            }
            return new WorkerIdentity(this.parseIdentifier(workerIdentityProto.getIdentifier()), version);
        }
    }

    public static class Parsers {
        public static WorkerIdentity fromProto(alluxio.grpc.WorkerIdentity proto) throws ProtoParsingException {
            Parser parser;
            if (!proto.hasVersion()) {
                Descriptors.FieldDescriptor descriptor = proto.getDescriptorForType().findFieldByNumber(2);
                throw new MissingRequiredFieldsParsingException(descriptor, (Message)proto);
            }
            int version = proto.getVersion();
            try {
                parser = Parsers.getParserOfVersion(version);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidVersionParsingException(version, 0, 1);
            }
            return parser.fromProto(proto);
        }

        public static alluxio.grpc.WorkerIdentity toProto(WorkerIdentity workerIdentity) {
            return Parsers.getParserOfVersion(workerIdentity.mVersion).toProto(workerIdentity);
        }

        static Parser getParserOfVersion(int version) throws IllegalArgumentException {
            Parser parser;
            switch (version) {
                case 0: {
                    parser = ParserV0.INSTANCE;
                    break;
                }
                case 1: {
                    parser = ParserV1.INSTANCE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized version: " + version);
                }
            }
            return parser;
        }
    }
}

