/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GrpcServerAddress;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.resource.DynamicResourcePool;
import alluxio.security.user.UserState;
import alluxio.util.ThreadFactoryUtils;
import com.codahale.metrics.Counter;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BlockWorkerClientPool
extends DynamicResourcePool<BlockWorkerClient> {
    private static final Logger LOG = LoggerFactory.getLogger(BlockWorkerClientPool.class);
    private final UserState mUserState;
    private final GrpcServerAddress mAddress;
    private static final int WORKER_CLIENT_POOL_GC_THREADPOOL_SIZE = 10;
    private static final ScheduledExecutorService GC_EXECUTOR = new ScheduledThreadPoolExecutor(10, ThreadFactoryUtils.build((String)"BlockWorkerClientPoolGcThreads-%d", (boolean)true));
    private static final Counter COUNTER = MetricsSystem.counter((String)MetricKey.CLIENT_BLOCK_WORKER_CLIENT_COUNT.getName());
    private final AlluxioConfiguration mConf;

    public BlockWorkerClientPool(UserState userState, GrpcServerAddress address, int minCapacity, int maxCapacity, AlluxioConfiguration alluxioConf) {
        super(DynamicResourcePool.Options.defaultOptions().setMinCapacity(minCapacity).setMaxCapacity(maxCapacity).setGcExecutor(GC_EXECUTOR));
        Objects.requireNonNull(userState);
        this.mUserState = userState;
        Objects.requireNonNull(address);
        this.mAddress = address;
        Objects.requireNonNull(alluxioConf);
        this.mConf = alluxioConf;
    }

    protected UserState getUserState() {
        return this.mUserState;
    }

    protected GrpcServerAddress getAddress() {
        return this.mAddress;
    }

    protected void closeResource(BlockWorkerClient client) throws IOException {
        LOG.debug("Block worker client for {} closed.", (Object)this.mAddress);
        client.close();
    }

    protected BlockWorkerClient createNewResource() throws IOException {
        return BlockWorkerClient.Factory.create(this.mUserState, this.mAddress, this.mConf);
    }

    protected boolean isHealthy(BlockWorkerClient client) {
        return client.isHealthy();
    }

    protected Counter getMetricCounter() {
        return COUNTER;
    }

    protected boolean shouldGc(DynamicResourcePool.ResourceInternal<BlockWorkerClient> clientResourceInternal) {
        return System.currentTimeMillis() - clientResourceInternal.getLastAccessTimeMs() > this.mConf.getMs(PropertyKey.USER_BLOCK_WORKER_CLIENT_POOL_GC_THRESHOLD_MS);
    }
}

