/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.client.block.stream.GrpcBlockingStream;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.ReadRequest;
import alluxio.grpc.ReadResponse;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.NioDataBuffer;
import alluxio.resource.CloseableResource;
import alluxio.resource.LockResource;
import alluxio.wire.WorkerNetAddress;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class BufferCachingGrpcDataReader {
    private static final Logger LOG = LoggerFactory.getLogger(BufferCachingGrpcDataReader.class);
    private final WorkerNetAddress mAddress;
    private final CloseableResource<BlockWorkerClient> mClient;
    private final long mDataTimeoutMs;
    private final ReadRequest mReadRequest;
    private final GrpcBlockingStream<ReadRequest, ReadResponse> mStream;
    private final AtomicInteger mRefCount = new AtomicInteger(0);
    private final AtomicInteger mBufferCount = new AtomicInteger(0);
    @GuardedBy(value="mBufferLocks")
    private final DataBuffer[] mDataBuffers;
    private final ReentrantReadWriteLock mBufferLocks = new ReentrantReadWriteLock();
    @VisibleForTesting
    protected long mPosToRead;

    @VisibleForTesting
    protected BufferCachingGrpcDataReader(WorkerNetAddress address, CloseableResource<BlockWorkerClient> client, long dataTimeoutMs, ReadRequest readRequest, GrpcBlockingStream<ReadRequest, ReadResponse> stream) {
        this.mAddress = address;
        Objects.requireNonNull(client);
        this.mClient = client;
        this.mDataTimeoutMs = dataTimeoutMs;
        this.mPosToRead = readRequest.getOffset();
        this.mReadRequest = readRequest;
        Objects.requireNonNull(stream);
        this.mStream = stream;
        long blockSize = this.mReadRequest.getLength() + this.mReadRequest.getOffset();
        long chunkSize = this.mReadRequest.getChunkSize();
        int buffCount = (int)(blockSize / chunkSize);
        if (blockSize % chunkSize != 0L) {
            ++buffCount;
        }
        this.mDataBuffers = new DataBuffer[buffCount];
    }

    @Nullable
    public DataBuffer readChunk(int index) throws IOException {
        if (index >= this.mDataBuffers.length) {
            return null;
        }
        if (index >= this.mBufferCount.get()) {
            try (LockResource ignored = new LockResource((Lock)this.mBufferLocks.writeLock());){
                while (index >= this.mBufferCount.get()) {
                    DataBuffer buffer;
                    this.mDataBuffers[this.mBufferCount.get()] = buffer = this.readChunk();
                    this.mBufferCount.incrementAndGet();
                }
            }
        }
        return this.mDataBuffers[index];
    }

    @Nullable
    @VisibleForTesting
    protected DataBuffer readChunk() throws IOException {
        Preconditions.checkState((!((BlockWorkerClient)this.mClient.get()).isShutdown() ? 1 : 0) != 0, (Object)"Data reader is closed while reading data chunks.");
        ReadResponse response = this.mStream.receive(this.mDataTimeoutMs);
        if (response == null) {
            return null;
        }
        Preconditions.checkState((response.hasChunk() && response.getChunk().hasData() ? 1 : 0) != 0, (Object)"response should always contain chunk");
        ByteBuffer byteBuffer = response.getChunk().getData().asReadOnlyByteBuffer();
        NioDataBuffer buffer = new NioDataBuffer(byteBuffer, (long)byteBuffer.remaining());
        this.mPosToRead += (long)buffer.readableBytes();
        try {
            this.mStream.send(this.mReadRequest.toBuilder().setOffsetReceived(this.mPosToRead).build());
        }
        catch (Exception e) {
            LOG.debug("Failed to send receipt of data to worker {} for request {}", new Object[]{this.mAddress, this.mReadRequest, e});
        }
        Preconditions.checkState((this.mPosToRead - this.mReadRequest.getOffset() <= this.mReadRequest.getLength() ? 1 : 0) != 0);
        return buffer;
    }

    public void close() throws IOException {
        try {
            if (((BlockWorkerClient)this.mClient.get()).isShutdown()) {
                return;
            }
            this.mStream.close();
            this.mStream.waitForComplete(this.mDataTimeoutMs);
        }
        finally {
            this.mClient.close();
        }
    }

    public int ref() {
        return this.mRefCount.incrementAndGet();
    }

    public int deRef() {
        return this.mRefCount.decrementAndGet();
    }

    public int getRefCount() {
        return this.mRefCount.get();
    }

    public static BufferCachingGrpcDataReader create(FileSystemContext context, WorkerNetAddress address, ReadRequest readRequest) throws IOException {
        AlluxioConfiguration alluxioConf = context.getClusterConf();
        int readerBufferSizeMessages = alluxioConf.getInt(PropertyKey.USER_STREAMING_READER_BUFFER_SIZE_MESSAGES);
        long dataTimeoutMs = alluxioConf.getMs(PropertyKey.USER_STREAMING_DATA_READ_TIMEOUT);
        CloseableResource<BlockWorkerClient> client = context.acquireBlockWorkerClient(address);
        String desc = "BufferCachingGrpcDataReader";
        if (LOG.isDebugEnabled()) {
            desc = String.format("BufferCachingGrpcDataReader(request=%s,address=%s)", readRequest, address);
        }
        GrpcBlockingStream<ReadRequest, ReadResponse> stream = null;
        try {
            stream = new GrpcBlockingStream<ReadRequest, ReadResponse>(((BlockWorkerClient)client.get())::readBlock, readerBufferSizeMessages, desc);
            stream.send(readRequest, dataTimeoutMs);
        }
        catch (Exception e) {
            if (stream != null) {
                stream.close();
            }
            client.close();
            throw e;
        }
        return new BufferCachingGrpcDataReader(address, client, dataTimeoutMs, readRequest, stream);
    }
}

