/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.client.file.PrefetchCachePolicy;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;

public class AdaptivePrefetchCachePolicy
implements PrefetchCachePolicy {
    private int mPrefetchSize = 0;
    private long mLastCallEndPos = -1L;
    private final int mMaxPrefetchSize = (int)Configuration.getBytes((PropertyKey)PropertyKey.USER_POSITION_READER_STREAMING_PREFETCH_MAX_SIZE);

    @Override
    public void addTrace(long pos, int size) {
        if (pos == this.mLastCallEndPos) {
            this.mPrefetchSize = Math.min(this.mMaxPrefetchSize, this.mPrefetchSize + size);
        }
        this.mLastCallEndPos = pos + (long)size;
    }

    @Override
    public void onCacheHitRead() {
    }

    @Override
    public void onCacheMissRead() {
        this.mPrefetchSize /= 2;
        ++this.mPrefetchSize;
    }

    @Override
    public int getPrefetchSize() {
        return this.mPrefetchSize;
    }
}

