/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.AlluxioURI;
import alluxio.CloseableSupplier;
import alluxio.PositionReader;
import alluxio.client.file.CacheContext;
import alluxio.client.file.DelegatingFileSystem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.LocalCacheFileInStream;
import alluxio.client.file.cache.LocalCachePositionReader;
import alluxio.client.file.cache.filter.CacheFilter;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.grpc.OpenFilePOptions;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCacheFileSystem
extends DelegatingFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCacheFileSystem.class);
    private final CacheManager mCacheManager;
    private final CacheFilter mCacheFilter;
    private final AlluxioConfiguration mConf;

    public LocalCacheFileSystem(CacheManager cacheManage, FileSystem fs, AlluxioConfiguration conf) {
        super(fs);
        this.mCacheManager = (CacheManager)Preconditions.checkNotNull((Object)cacheManage, (Object)"cacheManager");
        this.mConf = (AlluxioConfiguration)Preconditions.checkNotNull((Object)conf, (Object)"conf");
        this.mCacheFilter = CacheFilter.create(conf);
    }

    @Override
    public AlluxioConfiguration getConf() {
        return this.mDelegatedFileSystem.getConf();
    }

    @Override
    public FileInStream openFile(AlluxioURI path, OpenFilePOptions options) throws IOException, AlluxioException {
        if (this.mCacheManager == null || this.mCacheManager.state() == CacheManager.State.NOT_IN_USE) {
            return this.mDelegatedFileSystem.openFile(path, options);
        }
        return this.openFile(this.mDelegatedFileSystem.getStatus(path), options);
    }

    @Override
    public FileInStream openFile(URIStatus status, OpenFilePOptions options) throws IOException, AlluxioException {
        if (this.mCacheManager == null || this.mCacheManager.state() == CacheManager.State.NOT_IN_USE || !this.mCacheFilter.needsCache(status)) {
            return this.mDelegatedFileSystem.openFile(status, options);
        }
        return new LocalCacheFileInStream(status, uriStatus -> this.mDelegatedFileSystem.openFile(status, options), this.mCacheManager, this.mConf, Optional.empty());
    }

    @Override
    public PositionReader openPositionRead(AlluxioURI path, OpenFilePOptions options) throws FileDoesNotExistException {
        if (this.mCacheManager == null || this.mCacheManager.state() == CacheManager.State.NOT_IN_USE) {
            return this.mDelegatedFileSystem.openPositionRead(path, options);
        }
        try {
            return this.openPositionRead(this.mDelegatedFileSystem.getStatus(path), options);
        }
        catch (AlluxioException | IOException e) {
            throw AlluxioRuntimeException.from((Throwable)e);
        }
    }

    @Override
    public PositionReader openPositionRead(URIStatus status, OpenFilePOptions options) {
        if (this.mCacheManager == null || this.mCacheManager.state() == CacheManager.State.NOT_IN_USE) {
            return this.mDelegatedFileSystem.openPositionRead(status, options);
        }
        return LocalCachePositionReader.create(this.mConf, this.mCacheManager, (CloseableSupplier<PositionReader>)new CloseableSupplier(() -> this.mDelegatedFileSystem.openPositionRead(status, options)), status, this.mConf.getBytes(PropertyKey.USER_CLIENT_CACHE_PAGE_SIZE), status.getCacheContext() == null ? CacheContext.defaults() : status.getCacheContext());
    }
}

