/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.CacheContext;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.CacheManagerOptions;
import alluxio.client.file.cache.CacheUsage;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.PageMetaStore;
import alluxio.client.file.cache.QuotaPageMetaStore;
import alluxio.client.file.cache.store.PageStoreDir;
import alluxio.client.quota.CacheQuota;
import alluxio.client.quota.CacheScope;
import alluxio.collections.ConcurrentHashSet;
import alluxio.collections.Pair;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.PageCorruptedException;
import alluxio.exception.PageNotFoundException;
import alluxio.file.ByteArrayTargetBuffer;
import alluxio.file.ReadTargetBuffer;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.metrics.MultiDimensionalMetricsSystem;
import alluxio.network.protocol.databuffer.DataFileChannel;
import alluxio.resource.LockResource;
import com.codahale.metrics.Counter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LocalCacheManager
implements CacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCacheManager.class);
    private static final int LOCK_SIZE = 1024;
    private final long mCacheSize;
    private final ReadWriteLock[] mPageLocks = new ReentrantReadWriteLock[1024];
    private final List<PageStoreDir> mPageStoreDirs;
    @GuardedBy(value="PageMetaStore.getLock()")
    private final PageMetaStore mPageMetaStore;
    private final Optional<ExecutorService> mInitService;
    private final Optional<ExecutorService> mAsyncCacheExecutor;
    private final Optional<ScheduledExecutorService> mTtlEnforcerExecutor;
    private final ConcurrentHashSet<PageId> mPendingRequests;
    private final AtomicReference<CacheManager.State> mState = new AtomicReference();
    private final CacheManagerOptions mOptions;

    public static LocalCacheManager create(CacheManagerOptions options, PageMetaStore pageMetaStore) throws IOException {
        LocalCacheManager manager = new LocalCacheManager(options, pageMetaStore);
        List<PageStoreDir> pageStoreDirs = pageMetaStore.getStoreDirs();
        if (manager.mInitService.isPresent()) {
            manager.mInitService.get().submit(() -> {
                try {
                    manager.restoreOrInit(pageStoreDirs);
                }
                catch (IOException e) {
                    LOG.error("Failed to restore LocalCacheManager", (Throwable)e);
                }
            });
        } else {
            manager.restoreOrInit(pageStoreDirs);
        }
        return manager;
    }

    @VisibleForTesting
    LocalCacheManager(CacheManagerOptions options, PageMetaStore pageMetaStore) {
        this.mPageMetaStore = pageMetaStore;
        this.mPageStoreDirs = pageMetaStore.getStoreDirs();
        this.mOptions = options;
        this.mCacheSize = this.mPageStoreDirs.stream().map(PageStoreDir::getCapacityBytes).reduce(0L, Long::sum);
        for (int i = 0; i < 1024; ++i) {
            this.mPageLocks[i] = new ReentrantReadWriteLock(true);
        }
        this.mPendingRequests = new ConcurrentHashSet();
        this.mAsyncCacheExecutor = options.isAsyncWriteEnabled() ? Optional.of(new ThreadPoolExecutor(this.mOptions.getAsyncWriteThreads(), this.mOptions.getAsyncWriteThreads(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy())) : Optional.empty();
        Optional<Object> optional = this.mInitService = options.isAsyncRestoreEnabled() ? Optional.of(Executors.newSingleThreadExecutor()) : Optional.empty();
        if (options.isTtlEnabled()) {
            this.mTtlEnforcerExecutor = Optional.of(Executors.newScheduledThreadPool(1));
            this.mTtlEnforcerExecutor.get().scheduleAtFixedRate(() -> this.invalidate(pageInfo -> {
                try {
                    return System.currentTimeMillis() - pageInfo.getCreatedTimestamp() >= options.getTtlThresholdSeconds() * 1000L;
                }
                catch (Exception ex) {
                    return false;
                }
            }), 0L, options.getTtlCheckIntervalSeconds(), TimeUnit.SECONDS);
        } else {
            this.mTtlEnforcerExecutor = Optional.empty();
        }
        Metrics.registerGauges(this.mCacheSize, this.mPageMetaStore);
        this.mState.set(CacheManager.State.READ_ONLY);
        Metrics.STATE.inc();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Optional<DataFileChannel> getDataFileChannel(PageId pageId, int pageOffset, int bytesToRead, CacheContext cacheContext) throws PageNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    public int getPageLockId(PageId pageId) {
        return Math.floorMod((int)((long)pageId.getFileId().hashCode() + pageId.getPageIndex()), 1024);
    }

    private ReadWriteLock getPageLock(PageId pageId) {
        return this.mPageLocks[this.getPageLockId(pageId)];
    }

    private Pair<ReadWriteLock, ReadWriteLock> getPageLockPair(PageId pageId1, PageId pageId2) {
        int lockId2;
        int lockId1 = this.getPageLockId(pageId1);
        if (lockId1 < (lockId2 = this.getPageLockId(pageId2))) {
            return new Pair((Object)this.mPageLocks[lockId1], (Object)this.mPageLocks[lockId2]);
        }
        return new Pair((Object)this.mPageLocks[lockId2], (Object)this.mPageLocks[lockId1]);
    }

    @Nullable
    private CacheScope checkScopeToEvict(int pageSize, PageStoreDir pageStoreDir, CacheScope scope, CacheQuota quota, boolean forcedToEvict) {
        if (this.mOptions.isQuotaEnabled()) {
            for (CacheScope currentScope = scope; currentScope != null; currentScope = currentScope.parent()) {
                if (((QuotaPageMetaStore)this.mPageMetaStore).bytes(currentScope) + (long)pageSize <= quota.getQuota(currentScope)) continue;
                return currentScope;
            }
        }
        if (forcedToEvict || pageStoreDir.getCachedBytes() + (long)pageSize > pageStoreDir.getCapacityBytes()) {
            return CacheScope.GLOBAL;
        }
        return null;
    }

    @Override
    public boolean put(PageId pageId, ByteBuffer page, CacheContext cacheContext) {
        LOG.debug("put({},{} bytes) enters", (Object)pageId, (Object)page.remaining());
        if (this.mState.get() != CacheManager.State.READ_WRITE) {
            Metrics.PUT_NOT_READY_ERRORS.inc();
            Metrics.PUT_ERRORS.inc();
            return false;
        }
        int originPosition = page.position();
        if (!this.mOptions.isAsyncWriteEnabled()) {
            boolean ok = this.putInternal(pageId, page, cacheContext);
            LOG.debug("put({},{} bytes) exits: {}", new Object[]{pageId, page.position() - originPosition, ok});
            if (!ok) {
                Metrics.PUT_ERRORS.inc();
            }
            return ok;
        }
        if (!this.mPendingRequests.add((Object)pageId)) {
            return false;
        }
        try {
            this.mAsyncCacheExecutor.get().submit(() -> {
                try {
                    boolean ok = this.putInternal(pageId, page, cacheContext);
                    if (!ok) {
                        Metrics.PUT_ERRORS.inc();
                    }
                }
                finally {
                    this.mPendingRequests.remove((Object)pageId);
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.mPendingRequests.remove((Object)pageId);
            Metrics.PUT_ASYNC_REJECTION_ERRORS.inc();
            Metrics.PUT_ERRORS.inc();
            LOG.debug("put({},{} bytes) fails due to full queue", (Object)pageId, (Object)(page.position() - originPosition));
            return false;
        }
        LOG.debug("put({},{} bytes) exits with async write", (Object)pageId, (Object)(page.position() - originPosition));
        return true;
    }

    private boolean putInternal(PageId pageId, ByteBuffer page, CacheContext cacheContext) {
        PutResult result = PutResult.OK;
        boolean forcedToEvict = false;
        block5: for (int i = 0; i <= this.mOptions.getMaxEvictionRetries(); ++i) {
            result = this.putAttempt(pageId, page, cacheContext, forcedToEvict);
            switch (result) {
                case OK: {
                    return true;
                }
                case BENIGN_RACING: 
                case INSUFFICIENT_SPACE_EVICTED: {
                    continue block5;
                }
                case NO_SPACE_LEFT: {
                    forcedToEvict = true;
                    continue block5;
                }
                default: {
                    return false;
                }
            }
        }
        if (result == PutResult.BENIGN_RACING) {
            Metrics.PUT_BENIGN_RACING_ERRORS.inc();
        } else if (result == PutResult.INSUFFICIENT_SPACE_EVICTED) {
            Metrics.PUT_INSUFFICIENT_SPACE_ERRORS.inc();
        }
        return false;
    }

    @Override
    public void commitFile(String fileId) {
        try {
            PageStoreDir dir = this.mPageMetaStore.getStoreDirOfFile(fileId);
            dir.commit(fileId, fileId);
        }
        catch (FileDoesNotExistException notExistException) {
            LOG.error(notExistException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            LOG.error(illegalStateException.getMessage());
        }
        catch (IOException ioException) {
            LOG.error(ioException.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private PutResult putAttempt(PageId pageId, ByteBuffer page, CacheContext cacheContext, boolean forcedToEvict) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addPageToMetaStore(PageId pageId, ByteBuffer page, CacheContext cacheContext, PageStoreDir pageStoreDir) {
        PageInfo pageInfo = new PageInfo(pageId, page.remaining(), cacheContext.getCacheScope(), pageStoreDir);
        if (cacheContext.isTemporary()) {
            this.mPageMetaStore.addTempPage(pageId, pageInfo);
        } else {
            this.mPageMetaStore.addPage(pageId, pageInfo);
        }
    }

    private void undoAddPage(PageId pageId) {
        try (LockResource r3 = new LockResource(this.mPageMetaStore.getLock().writeLock());){
            this.mPageMetaStore.removePage(pageId);
        }
        catch (Exception e) {
            Metrics.CLEANUP_PUT_ERRORS.inc();
            LOG.error("Failed to undo page add {}", (Object)pageId, (Object)e);
        }
    }

    @Override
    public int get(PageId pageId, int pageOffset, ReadTargetBuffer buffer, CacheContext cacheContext) {
        ReadWriteLock pageLock = this.getPageLock(pageId);
        long pageSize = -1L;
        try (LockResource r = new LockResource(pageLock.readLock());){
            PageInfo pageInfo;
            try (LockResource r2 = new LockResource(this.mPageMetaStore.getLock().readLock());){
                pageInfo = this.mPageMetaStore.getPageInfo(pageId);
            }
            catch (PageNotFoundException e) {
                LOG.debug("get({},pageOffset={}) fails due to page not found", (Object)pageId, (Object)pageOffset);
                int n = 0;
                if (r != null) {
                    if (var9_8 != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable) {
                            var9_8.addSuppressed(throwable);
                        }
                    } else {
                        r.close();
                    }
                }
                return n;
            }
            pageSize = pageInfo.getPageSize();
        }
        return this.get(pageId, pageOffset, (int)pageSize, buffer, cacheContext);
    }

    /*
     * Loose catch block
     */
    @Override
    public int get(PageId pageId, int pageOffset, int bytesToRead, ReadTargetBuffer buffer, CacheContext cacheContext) {
        Preconditions.checkArgument(((long)pageOffset <= this.mOptions.getPageSize() ? 1 : 0) != 0, (String)"Read exceeds page boundary: offset=%s size=%s", (int)pageOffset, (long)this.mOptions.getPageSize());
        Preconditions.checkArgument(((long)bytesToRead <= buffer.remaining() ? 1 : 0) != 0, (String)"buffer does not have enough space: bufferRemaining=%s bytesToRead=%s", (long)buffer.remaining(), (int)bytesToRead);
        LOG.debug("get({},pageOffset={}) enters", (Object)pageId, (Object)pageOffset);
        if (this.mState.get() == CacheManager.State.NOT_IN_USE) {
            Metrics.GET_NOT_READY_ERRORS.inc();
            Metrics.GET_ERRORS.inc();
            return -1;
        }
        ReadWriteLock pageLock = this.getPageLock(pageId);
        long startTime = System.nanoTime();
        try {
            int n;
            try (LockResource r = new LockResource(pageLock.readLock());){
                PageInfo pageInfo;
                try (LockResource r2 = new LockResource(this.mPageMetaStore.getLock().readLock());){
                    pageInfo = this.mPageMetaStore.getPageInfo(pageId);
                }
                catch (PageNotFoundException e) {
                    LOG.debug("get({},pageOffset={}) fails due to page not found", (Object)pageId, (Object)pageOffset);
                    int n2 = 0;
                    if (r != null) {
                        if (var10_9 != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable) {
                                var10_9.addSuppressed(throwable);
                            }
                        } else {
                            r.close();
                        }
                    }
                    cacheContext.incrementCounter(MetricKey.CLIENT_CACHE_PAGE_READ_CACHE_TIME_NS.getMetricName(), CacheContext.StatsUnit.NANO, System.nanoTime() - startTime);
                    return n2;
                }
                int bytesRead = this.getPage(pageInfo, pageOffset, bytesToRead, buffer, cacheContext);
                if (bytesRead <= 0) {
                    Metrics.GET_ERRORS.inc();
                    Metrics.GET_STORE_READ_ERRORS.inc();
                    try (LockResource r2 = new LockResource(this.mPageMetaStore.getLock().writeLock());){
                        this.mPageMetaStore.removePage(pageId);
                    }
                    catch (PageNotFoundException e) {
                        Metrics.CLEANUP_GET_ERRORS.inc();
                    }
                    int n3 = -1;
                    return n3;
                }
                MultiDimensionalMetricsSystem.CACHED_DATA_READ.inc((long)bytesRead);
                MetricsSystem.meter((String)MetricKey.CLIENT_CACHE_BYTES_READ_CACHE.getName()).mark((long)bytesRead);
                cacheContext.incrementCounter(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE.getMetricName(), CacheContext.StatsUnit.BYTE, (long)bytesRead);
                LOG.debug("get({},pageOffset={}) exits", (Object)pageId, (Object)pageOffset);
                n = bytesRead;
            }
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            cacheContext.incrementCounter(MetricKey.CLIENT_CACHE_PAGE_READ_CACHE_TIME_NS.getMetricName(), CacheContext.StatsUnit.NANO, System.nanoTime() - startTime);
        }
    }

    @Override
    public int getAndLoad(PageId pageId, int pageOffset, int bytesToRead, ReadTargetBuffer buffer, CacheContext cacheContext, Supplier<byte[]> externalDataSupplier) {
        int bytesRead = this.get(pageId, pageOffset, bytesToRead, buffer, cacheContext);
        if (bytesRead > 0) {
            MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_HIT_REQUESTS.getName()).inc();
            return bytesRead;
        }
        long startTime = System.nanoTime();
        byte[] page = externalDataSupplier.get();
        long timeElapse = System.nanoTime() - startTime;
        buffer.writeBytes(page, pageOffset, bytesToRead);
        MetricsSystem.meter((String)MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL.getName()).mark((long)bytesToRead);
        MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_EXTERNAL_REQUESTS.getName()).inc();
        cacheContext.incrementCounter(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL.getMetricName(), CacheContext.StatsUnit.BYTE, (long)bytesToRead);
        cacheContext.incrementCounter(MetricKey.CLIENT_CACHE_PAGE_READ_EXTERNAL_TIME_NS.getMetricName(), CacheContext.StatsUnit.NANO, timeElapse);
        this.put(pageId, page, cacheContext);
        return bytesToRead;
    }

    public boolean delete(PageId pageId, boolean isTemporary) {
        if (this.mState.get() != CacheManager.State.READ_WRITE) {
            Metrics.DELETE_NOT_READY_ERRORS.inc();
            Metrics.DELETE_ERRORS.inc();
            return false;
        }
        ReadWriteLock pageLock = this.getPageLock(pageId);
        try (LockResource r = new LockResource(pageLock.writeLock());){
            PageInfo pageInfo;
            try (LockResource r1 = new LockResource(this.mPageMetaStore.getLock().writeLock());){
                try {
                    pageInfo = this.mPageMetaStore.removePage(pageId, isTemporary);
                }
                catch (PageNotFoundException e) {
                    LOG.debug("Failed to delete page {} from metaStore ", (Object)pageId, (Object)e);
                    Metrics.DELETE_NON_EXISTING_PAGE_ERRORS.inc();
                    Metrics.DELETE_ERRORS.inc();
                    boolean bl = false;
                    if (r1 != null) {
                        if (var8_8 != null) {
                            try {
                                r1.close();
                            }
                            catch (Throwable throwable) {
                                var8_8.addSuppressed(throwable);
                            }
                        } else {
                            r1.close();
                        }
                    }
                    if (r != null) {
                        if (var5_5 != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            r.close();
                        }
                    }
                    return bl;
                }
            }
            boolean ok = this.deletePage(pageInfo, isTemporary);
            LOG.debug("delete({}) exits, success: {}", (Object)pageId, (Object)ok);
            if (!ok) {
                Metrics.DELETE_STORE_DELETE_ERRORS.inc();
                Metrics.DELETE_ERRORS.inc();
            }
            boolean bl = ok;
            return bl;
        }
    }

    @Override
    public boolean delete(PageId pageId) {
        return this.delete(pageId, false);
    }

    @Override
    public CacheManager.State state() {
        return this.mState.get();
    }

    @Override
    public boolean append(PageId pageId, int appendAt, byte[] page, CacheContext cacheContext) {
        if (this.mState.get() != CacheManager.State.READ_WRITE) {
            Metrics.PUT_NOT_READY_ERRORS.inc();
            Metrics.PUT_ERRORS.inc();
            return false;
        }
        if (appendAt > 0) {
            byte[] newPage = new byte[appendAt + page.length];
            int readBytes = this.get(pageId, 0, appendAt, (ReadTargetBuffer)new ByteArrayTargetBuffer(newPage, 0), cacheContext);
            boolean success = this.delete(pageId, cacheContext.isTemporary());
            LOG.debug("delete pageId: {}, appendAt: {}, readBytes: {}, success: {}", new Object[]{pageId, appendAt, readBytes, success});
            System.arraycopy(page, 0, newPage, appendAt, page.length);
            return this.put(pageId, newPage, cacheContext);
        }
        return this.put(pageId, page, cacheContext);
    }

    private void restoreOrInit(List<PageStoreDir> pageStoreDirs) throws IOException {
        Preconditions.checkState((this.mState.get() == CacheManager.State.READ_ONLY ? 1 : 0) != 0);
        for (PageStoreDir pageStoreDir : pageStoreDirs) {
            if (this.restore(pageStoreDir)) continue;
            try (LockResource r = new LockResource(this.mPageMetaStore.getLock().writeLock());){
                this.mPageMetaStore.reset();
            }
            try {
                pageStoreDir.reset();
            }
            catch (IOException e) {
                LOG.error("Cache is in NOT_IN_USE.");
                this.mState.set(CacheManager.State.NOT_IN_USE);
                Metrics.STATE.dec();
                throw e;
            }
        }
        LOG.info("Cache is in READ_WRITE.");
        this.mState.set(CacheManager.State.READ_WRITE);
        Metrics.STATE.inc();
    }

    private boolean restore(PageStoreDir pageStoreDir) {
        long restoredPages = this.mPageMetaStore.numPages();
        long restoredBytes = this.mPageMetaStore.bytes();
        long discardPages = Metrics.PAGE_DISCARDED.getCount();
        long discardBytes = Metrics.BYTE_DISCARDED.getCount();
        LOG.info("Restoring PageStoreDir ({})", (Object)pageStoreDir.getRootPath());
        if (!Files.exists(pageStoreDir.getRootPath(), new LinkOption[0])) {
            LOG.error("Failed to restore PageStore: Directory {} does not exist", (Object)pageStoreDir.getRootPath());
            return false;
        }
        try {
            pageStoreDir.scanPages(pageInfo -> {
                if (pageInfo.isPresent()) {
                    this.addPageToDir(pageStoreDir, (PageInfo)pageInfo.get());
                }
            });
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Failed to restore PageStore", (Throwable)e);
            return false;
        }
        LOG.info("PageStore ({}) restored with {} pages ({} bytes), discarded {} pages ({} bytes)", new Object[]{pageStoreDir.getRootPath(), this.mPageMetaStore.numPages() - restoredPages, this.mPageMetaStore.bytes() - restoredBytes, Metrics.PAGE_DISCARDED.getCount() - discardPages, Metrics.BYTE_DISCARDED.getCount() - discardBytes});
        return true;
    }

    private void addPageToDir(PageStoreDir pageStoreDir, PageInfo pageInfo) {
        block28: {
            PageId pageId = pageInfo.getPageId();
            ReadWriteLock pageLock = this.getPageLock(pageId);
            try (LockResource r = new LockResource(pageLock.writeLock());){
                boolean enoughSpace;
                try (LockResource r2 = new LockResource(this.mPageMetaStore.getLock().writeLock());){
                    boolean bl = enoughSpace = pageStoreDir.getCachedBytes() + pageInfo.getPageSize() <= pageStoreDir.getCapacityBytes();
                    if (enoughSpace) {
                        this.mPageMetaStore.addPage(pageId, pageInfo);
                    }
                }
                if (enoughSpace) break block28;
                try {
                    pageStoreDir.getPageStore().delete(pageId);
                }
                catch (PageNotFoundException | IOException e) {
                    throw new RuntimeException("Failed to delete page", e);
                }
                Metrics.PAGE_DISCARDED.inc();
                Metrics.BYTE_DISCARDED.inc(pageInfo.getPageSize());
            }
        }
    }

    @Override
    public List<PageId> getCachedPageIdsByFileId(String fileId, long fileLength) {
        int numOfPages = (int)((fileLength - 1L) / this.mOptions.getPageSize()) + 1;
        ArrayList<PageId> pageIds = new ArrayList<PageId>(numOfPages);
        try (LockResource r = new LockResource(this.mPageMetaStore.getLock().readLock());){
            for (long pageIndex = 0L; pageIndex < (long)numOfPages; ++pageIndex) {
                PageId pageId = new PageId(fileId, pageIndex);
                if (!this.mPageMetaStore.hasPage(pageId)) continue;
                pageIds.add(pageId);
            }
        }
        return pageIds;
    }

    @Override
    public boolean hasPageUnsafe(PageId pageId) {
        return this.mPageMetaStore.hasPage(pageId);
    }

    @Override
    public void deleteFile(String fileId) {
        Set<PageInfo> pages;
        try (LockResource r = new LockResource(this.mPageMetaStore.getLock().readLock());){
            pages = this.mPageMetaStore.getAllPagesByFileId(fileId);
        }
        pages.forEach(page -> this.delete(page.getPageId()));
    }

    @Override
    public void deleteTempFile(String fileId) {
        Set<PageInfo> pages;
        try (LockResource r = new LockResource(this.mPageMetaStore.getLock().readLock());){
            pages = this.mPageMetaStore.getAllPagesByFileId(fileId);
        }
        pages.forEach(page -> this.delete(page.getPageId(), true));
    }

    @Override
    public void invalidate(Predicate<PageInfo> predicate) {
        this.mPageStoreDirs.forEach(dir -> {
            try {
                dir.scanPages(pageInfoOpt -> {
                    if (pageInfoOpt.isPresent()) {
                        PageInfo pageInfo = (PageInfo)pageInfoOpt.get();
                        boolean isPageDeleted = false;
                        if (predicate.test(pageInfo)) {
                            isPageDeleted = this.delete(pageInfo.getPageId());
                        }
                        if (!isPageDeleted) {
                            MetricsSystem.meter((String)MetricKey.CLIENT_CACHE_PAGES_INVALIDATED.getName()).mark();
                            MetricsSystem.histogram((String)MetricKey.CLIENT_CACHE_PAGES_AGES.getName()).update(System.currentTimeMillis() - pageInfo.getCreatedTimestamp());
                        }
                    }
                });
            }
            catch (IOException e) {
                LOG.error("IOException occurs in page scan", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void close() throws Exception {
        for (PageStoreDir pageStoreDir : this.mPageStoreDirs) {
            pageStoreDir.close();
        }
        this.mPageMetaStore.reset();
        this.mInitService.ifPresent(ExecutorService::shutdownNow);
        this.mAsyncCacheExecutor.ifPresent(ExecutorService::shutdownNow);
        this.mTtlEnforcerExecutor.ifPresent(ExecutorService::shutdownNow);
    }

    private boolean deletePage(PageInfo pageInfo, boolean isTemporary) {
        try {
            pageInfo.getLocalCacheDir().getPageStore().delete(pageInfo.getPageId(), isTemporary);
        }
        catch (PageNotFoundException | IOException e) {
            LOG.error("Failed to delete page {} (isTemporary: {}) from pageStore.", new Object[]{pageInfo.getPageId(), isTemporary, e});
            return false;
        }
        return true;
    }

    private int getPage(PageInfo pageInfo, int pageOffset, int bytesToRead, ReadTargetBuffer target, CacheContext cacheContext) {
        int originOffset = target.offset();
        try {
            int ret = pageInfo.getLocalCacheDir().getPageStore().get(pageInfo.getPageId(), pageOffset, bytesToRead, target, cacheContext.isTemporary());
            if (ret != bytesToRead) {
                LOG.error("Failed to read page {}: supposed to read {} bytes, {} bytes actually read", new Object[]{pageInfo.getPageId(), bytesToRead, ret});
                target.offset(originOffset);
                this.deletePage(pageInfo, false);
                return -1;
            }
        }
        catch (PageCorruptedException e) {
            LOG.error("Data corrupted page {} from pageStore", (Object)pageInfo.getPageId(), (Object)e);
            target.offset(originOffset);
            this.deletePage(pageInfo, false);
            return -1;
        }
        catch (PageNotFoundException | IOException e) {
            LOG.debug("Failed to get existing page {} from pageStore", (Object)pageInfo.getPageId(), (Object)e);
            target.offset(originOffset);
            return -1;
        }
        return bytesToRead;
    }

    @Override
    public Optional<CacheUsage> getUsage() {
        return Optional.of(new Usage());
    }

    private static final class Metrics {
        private static final Counter BYTE_DISCARDED = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_BYTES_DISCARDED.getName());
        private static final Counter CLEANUP_GET_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_CLEANUP_GET_ERRORS.getName());
        private static final Counter CLEANUP_PUT_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_CLEANUP_PUT_ERRORS.getName());
        private static final Counter DELETE_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_DELETE_ERRORS.getName());
        private static final Counter DELETE_NON_EXISTING_PAGE_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_DELETE_NON_EXISTING_PAGE_ERRORS.getName());
        private static final Counter DELETE_NOT_READY_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_DELETE_NOT_READY_ERRORS.getName());
        private static final Counter DELETE_STORE_DELETE_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_DELETE_FROM_STORE_ERRORS.getName());
        private static final Counter GET_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_GET_ERRORS.getName());
        private static final Counter GET_NOT_READY_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_GET_NOT_READY_ERRORS.getName());
        private static final Counter GET_STORE_READ_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_GET_STORE_READ_ERRORS.getName());
        private static final Counter PAGE_DISCARDED = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_PAGES_DISCARDED.getName());
        private static final Counter PUT_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_PUT_ERRORS.getName());
        private static final Counter PUT_ASYNC_REJECTION_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_PUT_ASYNC_REJECTION_ERRORS.getName());
        private static final Counter PUT_EVICTION_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_PUT_EVICTION_ERRORS.getName());
        private static final Counter PUT_BENIGN_RACING_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_PUT_BENIGN_RACING_ERRORS.getName());
        private static final Counter PUT_INSUFFICIENT_SPACE_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_PUT_INSUFFICIENT_SPACE_ERRORS.getName());
        private static final Counter PUT_NOT_READY_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_PUT_NOT_READY_ERRORS.getName());
        private static final Counter PUT_STORE_DELETE_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_PUT_STORE_DELETE_ERRORS.getName());
        private static final Counter PUT_STORE_WRITE_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_PUT_STORE_WRITE_ERRORS.getName());
        private static final Counter PUT_STORE_WRITE_NO_SPACE_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_PUT_STORE_WRITE_NO_SPACE_ERRORS.getName());
        private static final Counter STATE = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_STATE.getName());

        private Metrics() {
        }

        private static void registerGauges(long cacheSize, PageMetaStore pageMetaStore) {
            MetricsSystem.registerGaugeIfAbsent((String)MetricsSystem.getMetricName((String)MetricKey.CLIENT_CACHE_SPACE_AVAILABLE.getName()), () -> cacheSize - pageMetaStore.bytes());
            MetricsSystem.registerGaugeIfAbsent((String)MetricsSystem.getMetricName((String)MetricKey.CLIENT_CACHE_SPACE_USED.getName()), pageMetaStore::bytes);
        }

        static /* synthetic */ Counter access$1100() {
            return PUT_EVICTION_ERRORS;
        }

        static /* synthetic */ Counter access$1200() {
            return PUT_STORE_WRITE_NO_SPACE_ERRORS;
        }

        static /* synthetic */ Counter access$1300() {
            return PUT_STORE_WRITE_ERRORS;
        }

        static /* synthetic */ Counter access$1400() {
            return PUT_STORE_DELETE_ERRORS;
        }
    }

    private final class Usage
    implements CacheUsage {
        private Usage() {
        }

        @Override
        public long used() {
            return LocalCacheManager.this.mPageMetaStore.bytes();
        }

        @Override
        public long available() {
            return this.capacity() - this.used();
        }

        @Override
        public long capacity() {
            return LocalCacheManager.this.mPageStoreDirs.stream().mapToLong(PageStoreDir::getCapacityBytes).sum();
        }

        @Override
        public Optional<CacheUsage> partitionedBy(CacheUsage.PartitionDescriptor<?> partitionDescriptor) {
            if (partitionDescriptor instanceof CacheUsage.DirPartition) {
                int dirIndex = ((CacheUsage.DirPartition)partitionDescriptor).getIdentifier();
                if (dirIndex >= 0 && dirIndex < LocalCacheManager.this.mPageStoreDirs.size()) {
                    return ((PageStoreDir)LocalCacheManager.this.mPageStoreDirs.get(dirIndex)).getUsage();
                }
                return Optional.empty();
            }
            return LocalCacheManager.this.mPageMetaStore.getUsage().flatMap(usage -> usage.partitionedBy(partitionDescriptor));
        }
    }

    static enum PutResult {
        BENIGN_RACING,
        INSUFFICIENT_SPACE_EVICTED,
        NO_SPACE_LEFT,
        OK,
        OTHER;

    }
}

