/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.dora.ConsistentHashProvider;
import alluxio.client.file.dora.WorkerLocationPolicy;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.membership.WorkerClusterView;
import alluxio.wire.WorkerIdentity;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerState;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentHashPolicy
implements WorkerLocationPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ConsistentHashPolicy.class);
    private final ConsistentHashProvider mHashProvider;

    public ConsistentHashPolicy(AlluxioConfiguration conf) {
        LOG.debug("%s is chosen for user worker hash algorithm", (Object)conf.getString(PropertyKey.USER_WORKER_SELECTION_POLICY));
        this.mHashProvider = new ConsistentHashProvider(100, 1000L, conf.getInt(PropertyKey.USER_CONSISTENT_HASH_VIRTUAL_NODE_COUNT_PER_WORKER));
    }

    @Override
    public List<BlockWorkerInfo> getPreferredWorkers(WorkerClusterView workerClusterView, String fileId, int count) throws ResourceExhaustedException {
        if (workerClusterView.size() < count) {
            throw new ResourceExhaustedException(String.format("Not enough workers in the cluster %d workers in the cluster but %d required", workerClusterView.size(), count));
        }
        Set workerIdentities = workerClusterView.workerIds();
        this.mHashProvider.refresh(workerIdentities);
        List<WorkerIdentity> workers = this.mHashProvider.getMultiple(fileId, count);
        if (workers.size() != count) {
            throw new ResourceExhaustedException(String.format("Found %d workers from the hash ring but %d required", workers.size(), count));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (WorkerIdentity worker : workers) {
            Optional optionalWorkerInfo = workerClusterView.getWorkerById(worker);
            if (!optionalWorkerInfo.isPresent()) {
                LOG.debug("Inconsistency between caller's view of cluster and that of the consistent hash policy's: worker {} selected by policy does not exist in caller's view {}. Skipping this worker.", (Object)worker, (Object)workerClusterView);
                continue;
            }
            WorkerInfo workerInfo = (WorkerInfo)optionalWorkerInfo.get();
            BlockWorkerInfo blockWorkerInfo = new BlockWorkerInfo(worker, workerInfo.getAddress(), workerInfo.getCapacityBytes(), workerInfo.getUsedBytes(), workerInfo.getState() == WorkerState.LIVE);
            builder.add((Object)blockWorkerInfo);
        }
        ImmutableList infos = builder.build();
        return infos;
    }
}

