/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.dora.WorkerLocationPolicy;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.membership.WorkerClusterView;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import alluxio.wire.WorkerState;
import java.util.ArrayList;
import java.util.List;

public class LocalWorkerPolicy
implements WorkerLocationPolicy {
    private final AlluxioConfiguration mConf;

    public LocalWorkerPolicy(AlluxioConfiguration conf) {
        this.mConf = conf;
    }

    @Override
    public List<BlockWorkerInfo> getPreferredWorkers(WorkerClusterView workerClusterView, String fileId, int count) throws ResourceExhaustedException {
        String userHostname = NetworkAddressUtils.getClientHostName((AlluxioConfiguration)this.mConf);
        ArrayList<BlockWorkerInfo> results = new ArrayList<BlockWorkerInfo>();
        for (WorkerInfo worker : workerClusterView) {
            WorkerNetAddress workerAddr = worker.getAddress();
            if (workerAddr == null || !userHostname.equals(workerAddr.getHost())) continue;
            results.add(new BlockWorkerInfo(worker.getIdentity(), workerAddr, worker.getCapacityBytes(), worker.getUsedBytes(), worker.getState() == WorkerState.LIVE));
            if (results.size() < count) continue;
            break;
        }
        if (results.size() < count) {
            throw new ResourceExhaustedException(String.format("Failed to find a local worker for client hostname %s", userHostname));
        }
        return results;
    }
}

