/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora.netty;

import alluxio.client.block.stream.DataWriter;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.RequestType;
import alluxio.network.protocol.RPCProtoMessage;
import alluxio.proto.dataserver.Protocol;
import alluxio.proto.status.Status;
import alluxio.resource.LockResource;
import alluxio.util.CommonUtils;
import alluxio.util.proto.ProtoMessage;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class NettyDataWriter
implements DataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(NettyDataWriter.class);
    private static final int MAX_PACKETS_IN_FLIGHT = Configuration.getInt((PropertyKey)PropertyKey.USER_NETWORK_NETTY_WRITER_BUFFER_SIZE_PACKETS);
    private static final long WRITE_TIMEOUT_MS = Configuration.getMs((PropertyKey)PropertyKey.USER_NETWORK_NETTY_TIMEOUT_MS);
    private static final long CLOSE_TIMEOUT_MS = Configuration.getMs((PropertyKey)PropertyKey.USER_NETWORK_NETTY_WRITER_CLOSE_TIMEOUT_MS);
    private final FileSystemContext mContext;
    private final Channel mChannel;
    private final WorkerNetAddress mAddress;
    private final long mLength;
    protected Protocol.WriteRequest mPartialRequest;
    private final long mPacketSize;
    private boolean mClosed;
    private final ReentrantLock mLock = new ReentrantLock();
    @GuardedBy(value="mLock")
    private long mPosToWrite;
    @GuardedBy(value="mLock")
    private long mPosToQueue;
    @GuardedBy(value="mLock")
    private Throwable mPacketWriteException;
    @GuardedBy(value="mLock")
    private boolean mDone;
    @GuardedBy(value="mLock")
    private boolean mEOFSent;
    @GuardedBy(value="mLock")
    private boolean mCancelSent;
    private final Condition mDoneOrFailed = this.mLock.newCondition();
    private final Condition mBufferNotFullOrFailed = this.mLock.newCondition();
    private final Condition mBufferEmptyOrFailed = this.mLock.newCondition();

    public static NettyDataWriter create(FileSystemContext context, WorkerNetAddress address, long length, RequestType type, OutStreamOptions options) throws IOException {
        long packetSize = Configuration.getBytes((PropertyKey)PropertyKey.USER_NETWORK_NETTY_WRITER_PACKET_SIZE_BYTES);
        Channel nettyChannel = context.acquireNettyChannel(address);
        return new NettyDataWriter(context, address, length, packetSize, type, options, nettyChannel);
    }

    protected Protocol.RequestType getRequestType(RequestType requestType) {
        switch (requestType) {
            case ALLUXIO_BLOCK: {
                return Protocol.RequestType.ALLUXIO_BLOCK;
            }
            case UFS_FILE: {
                return Protocol.RequestType.UFS_FILE;
            }
        }
        throw new UnsupportedOperationException("Request type needs to be specified. ");
    }

    protected NettyDataWriter(FileSystemContext context, WorkerNetAddress address, long length, long packetSize, RequestType type, OutStreamOptions options, Channel channel) {
        this.mContext = context;
        this.mAddress = address;
        this.mLength = length;
        Protocol.WriteRequest.Builder builder = Protocol.WriteRequest.newBuilder().setTier(options.getWriteTier()).setType(this.getRequestType(type));
        Protocol.CreateUfsFileOptions ufsFileOptions = Protocol.CreateUfsFileOptions.newBuilder().setUfsPath(options.getUfsPath()).setOwner(options.getOwner()).setGroup(options.getGroup()).setMode((int)options.getMode().toShort()).setMountId(options.getMountId()).build();
        builder.setCreateUfsFileOptions(ufsFileOptions);
        this.mPartialRequest = builder.buildPartial();
        this.mPacketSize = packetSize;
        this.mChannel = channel;
        this.mChannel.pipeline().addLast(new ChannelHandler[]{new PacketWriteResponseHandler()});
    }

    @Override
    public long pos() {
        try (LockResource lr = new LockResource((Lock)this.mLock);){
            long l = this.mPosToQueue;
            return l;
        }
    }

    @Override
    public Optional<String> getUfsContentHash() {
        return Optional.empty();
    }

    public void writeChunk(byte[] bytes, int off, int len) throws IOException {
        long totalBytesLeft = len;
        int bytesToWrite = (int)Math.min((long)len, this.mPacketSize);
        int tmpOffset = off;
        while (totalBytesLeft > 0L) {
            ByteBuf byteBuf = this.mChannel.alloc().buffer(bytesToWrite);
            byteBuf.writeBytes(bytes, tmpOffset, bytesToWrite);
            this.writeChunk(byteBuf);
            tmpOffset += bytesToWrite;
            bytesToWrite = (int)Math.min(totalBytesLeft -= (long)bytesToWrite, this.mPacketSize);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void writeChunk(ByteBuf buf) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void cancel() {
        if (this.mClosed) {
            return;
        }
        this.sendCancel();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void flush() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public void close() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean tooManyPacketsInFlight() {
        return this.mPosToQueue - this.mPosToWrite >= (long)MAX_PACKETS_IN_FLIGHT * this.mPacketSize;
    }

    private void sendEof() {
        long pos;
        try (LockResource lr = new LockResource((Lock)this.mLock);){
            if (this.mEOFSent || this.mCancelSent) {
                return;
            }
            this.mEOFSent = true;
            pos = this.mPosToQueue;
        }
        Protocol.WriteRequest writeRequest = this.mPartialRequest.toBuilder().setOffset(pos).setEof(true).build();
        this.mChannel.writeAndFlush((Object)new RPCProtoMessage(new ProtoMessage(writeRequest), null)).addListener((GenericFutureListener)new EofOrCancelListener());
    }

    private void sendCancel() {
        long pos;
        try (LockResource lr = new LockResource((Lock)this.mLock);){
            if (this.mEOFSent || this.mCancelSent) {
                return;
            }
            this.mCancelSent = true;
            pos = this.mPosToQueue;
        }
        Protocol.WriteRequest writeRequest = this.mPartialRequest.toBuilder().setOffset(pos).setCancel(true).build();
        this.mChannel.writeAndFlush((Object)new RPCProtoMessage(new ProtoMessage(writeRequest), null)).addListener((GenericFutureListener)new EofOrCancelListener());
    }

    @Override
    public int chunkSize() {
        return (int)this.mPacketSize;
    }

    @GuardedBy(value="mLock")
    private void updateException(Throwable e) {
        if (this.mPacketWriteException == null || this.mPacketWriteException == e) {
            this.mPacketWriteException = e;
        } else {
            this.mPacketWriteException.addSuppressed(e);
        }
    }

    public Throwable getPacketWriteException() {
        return this.mPacketWriteException;
    }

    private final class EofOrCancelListener
    implements ChannelFutureListener {
        EofOrCancelListener() {
        }

        public void operationComplete(ChannelFuture future) {
            if (!future.isSuccess()) {
                future.channel().close();
                try (LockResource lr = new LockResource((Lock)NettyDataWriter.this.mLock);){
                    NettyDataWriter.this.updateException(future.cause());
                    NettyDataWriter.this.mDoneOrFailed.signal();
                    NettyDataWriter.this.mBufferNotFullOrFailed.signal();
                    NettyDataWriter.this.mBufferEmptyOrFailed.signal();
                }
            }
        }
    }

    private final class WriteListener
    implements ChannelFutureListener {
        private final long mPosToWriteUncommitted;

        WriteListener(long posToWriteUncommitted) {
            this.mPosToWriteUncommitted = posToWriteUncommitted;
        }

        public void operationComplete(ChannelFuture future) {
            if (!future.isSuccess()) {
                future.channel().close();
            }
            boolean shouldSendEOF = false;
            try (LockResource lr = new LockResource((Lock)NettyDataWriter.this.mLock);){
                Preconditions.checkState((this.mPosToWriteUncommitted - NettyDataWriter.this.mPosToWrite <= NettyDataWriter.this.mPacketSize ? 1 : 0) != 0, (Object)"Some packet is not acked.");
                Preconditions.checkState((this.mPosToWriteUncommitted <= NettyDataWriter.this.mLength ? 1 : 0) != 0);
                NettyDataWriter.this.mPosToWrite = this.mPosToWriteUncommitted;
                if (future.cause() != null) {
                    NettyDataWriter.this.updateException(future.cause());
                    NettyDataWriter.this.mDoneOrFailed.signal();
                    NettyDataWriter.this.mBufferNotFullOrFailed.signal();
                    NettyDataWriter.this.mBufferEmptyOrFailed.signal();
                    return;
                }
                if (NettyDataWriter.this.mPosToWrite == NettyDataWriter.this.mPosToQueue) {
                    NettyDataWriter.this.mBufferEmptyOrFailed.signal();
                }
                if (!NettyDataWriter.this.tooManyPacketsInFlight()) {
                    NettyDataWriter.this.mBufferNotFullOrFailed.signal();
                }
                if (NettyDataWriter.this.mPosToWrite == NettyDataWriter.this.mLength) {
                    shouldSendEOF = true;
                }
            }
            if (shouldSendEOF) {
                NettyDataWriter.this.sendEof();
            }
        }
    }

    private final class PacketWriteResponseHandler
    extends ChannelInboundHandlerAdapter {
        PacketWriteResponseHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws IOException {
            Preconditions.checkState((boolean)this.acceptMessage(msg), (String)"Incorrect response type %s.", (Object)msg);
            RPCProtoMessage response = (RPCProtoMessage)msg;
            if (response.getMessage().asResponse().getStatus() != Status.PStatus.CANCELLED) {
                CommonUtils.unwrapResponseFrom((Protocol.Response)response.getMessage().asResponse(), (Channel)ctx.channel());
            }
            try (LockResource lr = new LockResource((Lock)NettyDataWriter.this.mLock);){
                NettyDataWriter.this.mDone = true;
                NettyDataWriter.this.mDoneOrFailed.signal();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            LOG.error("Exception is caught when writing block {} to channel {}:", new Object[]{NettyDataWriter.this.mPartialRequest.getId(), ctx.channel(), cause});
            try (LockResource lr = new LockResource((Lock)NettyDataWriter.this.mLock);){
                NettyDataWriter.this.updateException(cause);
                NettyDataWriter.this.mBufferNotFullOrFailed.signal();
                NettyDataWriter.this.mDoneOrFailed.signal();
                NettyDataWriter.this.mBufferEmptyOrFailed.signal();
            }
            ctx.close();
        }

        public void channelUnregistered(ChannelHandlerContext ctx) {
            LOG.warn("Channel {} is closed.", (Object)ctx.channel());
            try (LockResource lr = new LockResource((Lock)NettyDataWriter.this.mLock);){
                if (!NettyDataWriter.this.mDone) {
                    NettyDataWriter.this.updateException(new IOException(String.format("Channel %s is closed when writing block %d.", ctx.channel(), NettyDataWriter.this.mPartialRequest.getId())));
                    NettyDataWriter.this.mBufferNotFullOrFailed.signal();
                    NettyDataWriter.this.mDoneOrFailed.signal();
                    NettyDataWriter.this.mBufferEmptyOrFailed.signal();
                }
            }
            ctx.fireChannelUnregistered();
        }

        private boolean acceptMessage(Object msg) {
            if (msg instanceof RPCProtoMessage) {
                return ((RPCProtoMessage)msg).getMessage().isResponse();
            }
            return false;
        }
    }
}

