/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.client.ReadType;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.ReadPType;
import alluxio.master.block.BlockId;
import alluxio.proto.dataserver.Protocol;
import alluxio.util.FileSystemOptionsUtils;
import alluxio.wire.BlockInfo;
import alluxio.wire.FileBlockInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class InStreamOptions {
    private final URIStatus mStatus;
    private final OpenFilePOptions mProtoOptions;
    private boolean mPositionShort;

    public InStreamOptions(URIStatus status, @Nonnull AlluxioConfiguration alluxioConf) {
        this(status, FileSystemOptionsUtils.openFileDefaults(alluxioConf), alluxioConf, FileSystemContext.create(alluxioConf));
    }

    public InStreamOptions(URIStatus status, @Nonnull AlluxioConfiguration alluxioConf, @Nonnull FileSystemContext context) {
        this(status, FileSystemOptionsUtils.openFileDefaults(alluxioConf), alluxioConf, context);
    }

    public InStreamOptions(URIStatus status, @Nonnull OpenFilePOptions options, @Nonnull AlluxioConfiguration alluxioConf, @Nonnull FileSystemContext context) {
        Preconditions.checkNotNull((Object)context);
        OpenFilePOptions.Builder openOptionsBuilder = OpenFilePOptions.newBuilder().setReadType(((ReadType)alluxioConf.getEnum(PropertyKey.USER_FILE_READ_TYPE_DEFAULT, ReadType.class)).toProto()).setMaxUfsReadConcurrency(alluxioConf.getInt(PropertyKey.USER_UFS_BLOCK_READ_CONCURRENCY_MAX));
        OpenFilePOptions openOptions = openOptionsBuilder.mergeFrom(options).build();
        this.mStatus = status;
        this.mProtoOptions = openOptions;
        this.mPositionShort = false;
    }

    public OpenFilePOptions getOptions() {
        return this.mProtoOptions;
    }

    public URIStatus getStatus() {
        return this.mStatus;
    }

    public boolean getPositionShort() {
        return this.mPositionShort;
    }

    public BlockInfo getBlockInfo(long blockId) {
        Preconditions.checkArgument((boolean)this.mStatus.getBlockIds().contains(blockId), (Object)"blockId");
        return this.mStatus.getFileBlockInfos().stream().map(FileBlockInfo::getBlockInfo).filter(blockInfo -> blockInfo.getBlockId() == blockId).findFirst().get();
    }

    public Protocol.OpenUfsBlockOptions getOpenUfsBlockOptions(long blockId) {
        Preconditions.checkArgument((boolean)this.mStatus.getBlockIds().contains(blockId), (String)"block id %s does not belong to the file %s", (long)blockId, (Object)this.mStatus.getPath());
        if (!this.mStatus.isPersisted()) {
            return Protocol.OpenUfsBlockOptions.getDefaultInstance();
        }
        long blockStart = BlockId.getSequenceNumber((long)blockId) * this.mStatus.getBlockSizeBytes();
        BlockInfo info = this.getBlockInfo(blockId);
        Protocol.OpenUfsBlockOptions.Builder openUfsBlockOptionsBuilder = Protocol.OpenUfsBlockOptions.newBuilder().setUfsPath(this.mStatus.getUfsPath()).setOffsetInFile(blockStart).setBlockSize(info.getLength()).setMaxUfsReadConcurrency(this.mProtoOptions.getMaxUfsReadConcurrency()).setNoCache(!ReadType.fromProto((ReadPType)this.mProtoOptions.getReadType()).isCache()).setMountId(this.mStatus.getMountId());
        return openUfsBlockOptionsBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InStreamOptions)) {
            return false;
        }
        InStreamOptions that = (InStreamOptions)o;
        return Objects.equal((Object)this.mStatus, (Object)that.mStatus) && Objects.equal((Object)this.mProtoOptions, (Object)that.mProtoOptions) && Objects.equal((Object)this.mPositionShort, (Object)that.mPositionShort);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mStatus, this.mProtoOptions, this.mPositionShort});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("URIStatus", (Object)this.mStatus).add("OpenFileOptions", (Object)this.mProtoOptions).add("PositionShort", this.mPositionShort).toString();
    }
}

