/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.journal;

import alluxio.AbstractJobMasterClient;
import alluxio.client.journal.JournalMasterClient;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.GetQuorumInfoPRequest;
import alluxio.grpc.GetQuorumInfoPResponse;
import alluxio.grpc.GetTransferLeaderMessagePRequest;
import alluxio.grpc.GetTransferLeaderMessagePResponse;
import alluxio.grpc.JournalMasterClientServiceGrpc;
import alluxio.grpc.NetAddress;
import alluxio.grpc.RemoveQuorumServerPRequest;
import alluxio.grpc.ResetPrioritiesPRequest;
import alluxio.grpc.ServiceType;
import alluxio.grpc.TransferLeadershipPRequest;
import alluxio.master.MasterClientContext;
import io.grpc.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHandlingJournalMasterClient
extends AbstractJobMasterClient
implements JournalMasterClient {
    private static final Logger RPC_LOG = LoggerFactory.getLogger(JournalMasterClient.class);
    private JournalMasterClientServiceGrpc.JournalMasterClientServiceBlockingStub mClient = null;

    public RetryHandlingJournalMasterClient(MasterClientContext conf) {
        super(conf);
    }

    protected ServiceType getRemoteServiceType() {
        return ServiceType.JOURNAL_MASTER_CLIENT_SERVICE;
    }

    protected String getServiceName() {
        return "JournalMasterClient";
    }

    protected long getServiceVersion() {
        return 1L;
    }

    protected void afterConnect() {
        this.mClient = JournalMasterClientServiceGrpc.newBlockingStub((Channel)this.mChannel);
    }

    @Override
    public GetQuorumInfoPResponse getQuorumInfo() throws AlluxioStatusException {
        return (GetQuorumInfoPResponse)this.retryRPC(() -> this.mClient.getQuorumInfo(GetQuorumInfoPRequest.getDefaultInstance()), RPC_LOG, "GetQuorumInfo", "", new Object[0]);
    }

    @Override
    public void removeQuorumServer(NetAddress serverAddress) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.removeQuorumServer(RemoveQuorumServerPRequest.newBuilder().setServerAddress(serverAddress).build()), RPC_LOG, "RemoveQuorumServer", "serverAddress=%s", new Object[]{serverAddress});
    }

    @Override
    public String transferLeadership(NetAddress newLeaderNetAddress) throws AlluxioStatusException {
        return (String)this.retryRPC(() -> this.mClient.transferLeadership(TransferLeadershipPRequest.newBuilder().setServerAddress(newLeaderNetAddress).build()).getTransferId(), RPC_LOG, "TransferLeadership", "serverAddress=%s", new Object[]{newLeaderNetAddress});
    }

    @Override
    public void resetPriorities() throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.resetPriorities(ResetPrioritiesPRequest.getDefaultInstance()), RPC_LOG, "ResetPriorities", "", new Object[0]);
    }

    @Override
    public GetTransferLeaderMessagePResponse getTransferLeaderMessage(String transferId) throws AlluxioStatusException {
        return (GetTransferLeaderMessagePResponse)this.retryRPC(() -> this.mClient.getTransferLeaderMessage(GetTransferLeaderMessagePRequest.newBuilder().setTransferId(transferId).build()), RPC_LOG, "GetTransferLeaderMessage", "", new Object[0]);
    }
}

