/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.predicate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.BloomFilterStore;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetMetadataConverter;
import io.trino.parquet.ParquetTimestampUtils;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.dictionary.Dictionary;
import io.trino.parquet.predicate.DictionaryDescriptor;
import io.trino.parquet.predicate.PredicateUtils;
import io.trino.plugin.base.type.TrinoTimestampEncoder;
import io.trino.plugin.base.type.TrinoTimestampEncoderFactory;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.joda.time.DateTimeZone;

public class TupleDomainParquetPredicate {
    private final TupleDomain<ColumnDescriptor> effectivePredicate;
    private final List<ColumnDescriptor> columns;
    private final DateTimeZone timeZone;

    public TupleDomainParquetPredicate(TupleDomain<ColumnDescriptor> effectivePredicate, List<ColumnDescriptor> columns, DateTimeZone timeZone) {
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    public Optional<List<ColumnDescriptor>> getIndexLookupCandidates(Map<ColumnDescriptor, Long> valueCounts, Map<ColumnDescriptor, Statistics<?>> statistics, ParquetDataSourceId id) throws ParquetCorruptionException {
        if (this.effectivePredicate.isNone()) {
            return Optional.empty();
        }
        Map effectivePredicateDomains = (Map)this.effectivePredicate.getDomains().orElseThrow(() -> new IllegalStateException("Effective predicate other than none should have domains"));
        ImmutableList.Builder candidateColumns = ImmutableList.builder();
        for (ColumnDescriptor column : this.columns) {
            Domain effectivePredicateDomain = (Domain)effectivePredicateDomains.get(column);
            if (effectivePredicateDomain == null) continue;
            Statistics<?> columnStatistics = statistics.get(column);
            if (columnStatistics == null || columnStatistics.isEmpty()) {
                candidateColumns.add((Object)column);
                continue;
            }
            Long columnValueCount = valueCounts.get(column);
            if (columnValueCount == null) {
                throw new IllegalArgumentException(String.format("Missing columnValueCount for column %s in %s", column, id));
            }
            Domain domain = TupleDomainParquetPredicate.getDomain(column, effectivePredicateDomain.getType(), columnValueCount, columnStatistics, id, this.timeZone);
            if (!effectivePredicateDomain.overlaps(domain)) {
                return Optional.empty();
            }
            if (effectivePredicateDomain.contains(domain)) continue;
            candidateColumns.add((Object)column);
        }
        return Optional.of(candidateColumns.build());
    }

    public boolean matches(DictionaryDescriptor dictionary) {
        Objects.requireNonNull(dictionary, "dictionary is null");
        if (this.effectivePredicate.isNone()) {
            return false;
        }
        Map effectivePredicateDomains = (Map)this.effectivePredicate.getDomains().orElseThrow(() -> new IllegalStateException("Effective predicate other than none should have domains"));
        Domain effectivePredicateDomain = (Domain)effectivePredicateDomains.get(dictionary.getColumnDescriptor());
        return effectivePredicateDomain == null || this.effectivePredicateMatches(effectivePredicateDomain, dictionary);
    }

    public boolean matches(Map<ColumnDescriptor, Long> valueCounts, ColumnIndexStore columnIndexStore, ParquetDataSourceId id) throws ParquetCorruptionException {
        Objects.requireNonNull(columnIndexStore, "columnIndexStore is null");
        if (this.effectivePredicate.isNone()) {
            return false;
        }
        Map effectivePredicateDomains = (Map)this.effectivePredicate.getDomains().orElseThrow(() -> new IllegalStateException("Effective predicate other than none should have domains"));
        for (ColumnDescriptor column : this.columns) {
            ColumnIndex columnIndex;
            Domain effectivePredicateDomain = (Domain)effectivePredicateDomains.get(column);
            if (effectivePredicateDomain == null || !ParquetMetadataConverter.isMinMaxStatsSupported(column.getPrimitiveType()) || (columnIndex = columnIndexStore.getColumnIndex(ColumnPath.get((String[])column.getPath()))) == null) continue;
            Long columnValueCount = valueCounts.get(column);
            if (columnValueCount == null) {
                throw new IllegalArgumentException(String.format("Missing columnValueCount for column %s in %s", column, id));
            }
            Domain domain = TupleDomainParquetPredicate.getDomain(effectivePredicateDomain.getType(), columnValueCount, columnIndex, id, column, this.timeZone);
            if (effectivePredicateDomain.overlaps(domain)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(BloomFilterStore bloomFilterStore, int domainCompactionThreshold) {
        Objects.requireNonNull(bloomFilterStore, "bloomFilterStore is null");
        if (this.effectivePredicate.isNone()) {
            return false;
        }
        Map effectivePredicateDomains = (Map)this.effectivePredicate.getDomains().orElseThrow(() -> new IllegalStateException("Effective predicate other than none should have domains"));
        for (ColumnDescriptor column : this.columns) {
            Optional<BloomFilter> bloomFilterOptional;
            Optional<Collection<Object>> discreteValues;
            Domain effectivePredicateDomain = (Domain)effectivePredicateDomains.get(column);
            if (effectivePredicateDomain == null || effectivePredicateDomain.isNullAllowed() || (discreteValues = TupleDomainParquetPredicate.extractDiscreteValues(domainCompactionThreshold, effectivePredicateDomain.getValues())).isEmpty() || (bloomFilterOptional = bloomFilterStore.getBloomFilter(ColumnPath.get((String[])column.getPath()))).isEmpty()) continue;
            BloomFilter bloomFilter = bloomFilterOptional.get();
            if (!discreteValues.get().stream().noneMatch(value -> TupleDomainParquetPredicate.checkInBloomFilter(bloomFilter, value, effectivePredicateDomain.getType()))) continue;
            return false;
        }
        return true;
    }

    public Optional<FilterPredicate> toParquetFilter(DateTimeZone timeZone) {
        return Optional.ofNullable(this.convertToParquetFilter(timeZone));
    }

    private boolean effectivePredicateMatches(Domain effectivePredicateDomain, DictionaryDescriptor dictionary) {
        return effectivePredicateDomain.overlaps(TupleDomainParquetPredicate.getDomain(effectivePredicateDomain.getType(), dictionary, this.timeZone));
    }

    @VisibleForTesting
    public static Domain getDomain(ColumnDescriptor column, Type type, long columnValuesCount, Statistics<?> statistics, ParquetDataSourceId id, DateTimeZone timeZone) throws ParquetCorruptionException {
        boolean hasNullValue;
        if (statistics == null || statistics.isEmpty()) {
            return Domain.all((Type)type);
        }
        if (statistics.isNumNullsSet() && statistics.getNumNulls() == columnValuesCount) {
            return Domain.onlyNull((Type)type);
        }
        boolean bl = hasNullValue = !statistics.isNumNullsSet() || statistics.getNumNulls() != 0L;
        if (!statistics.hasNonNullValue() || statistics.genericGetMin() == null || statistics.genericGetMax() == null) {
            return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
        }
        try {
            Comparable min = statistics.genericGetMin();
            Comparable max = statistics.genericGetMax();
            return TupleDomainParquetPredicate.getDomain(column, type, (List<Object>)ImmutableList.of((Object)(min instanceof Binary ? Slices.wrappedBuffer((byte[])((Binary)min).getBytes()) : min)), (List<Object>)ImmutableList.of((Object)(max instanceof Binary ? Slices.wrappedBuffer((byte[])((Binary)max).getBytes()) : max)), hasNullValue, timeZone);
        }
        catch (Exception e) {
            throw TupleDomainParquetPredicate.corruptionException(column.toString(), id, statistics, e);
        }
    }

    private static Domain getDomain(ColumnDescriptor column, Type type, List<Object> minimums, List<Object> maximums, boolean hasNullValue, DateTimeZone timeZone) {
        Preconditions.checkArgument((minimums.size() == maximums.size() ? 1 : 0) != 0, (Object)"Expected minimums and maximums to have the same size");
        if (type.equals((Object)BooleanType.BOOLEAN)) {
            boolean hasFalseValues;
            boolean hasTrueValues = minimums.stream().anyMatch(value -> (Boolean)value) || maximums.stream().anyMatch(value -> (Boolean)value);
            boolean bl = hasFalseValues = minimums.stream().anyMatch(value -> (Boolean)value == false) || maximums.stream().anyMatch(value -> (Boolean)value == false);
            if (hasTrueValues && hasFalseValues) {
                return Domain.all((Type)type);
            }
            if (hasTrueValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)true, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            if (hasFalseValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)false, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            throw new VerifyException("Impossible boolean statistics");
        }
        if (type.equals((Object)BigintType.BIGINT) || type.equals((Object)IntegerType.INTEGER) || type.equals((Object)DateType.DATE) || type.equals((Object)SmallintType.SMALLINT) || type.equals((Object)TinyintType.TINYINT)) {
            SortedRangeSet.Builder rangesBuilder = SortedRangeSet.builder((Type)type, (int)minimums.size());
            for (int i = 0; i < minimums.size(); ++i) {
                long max;
                long min = TupleDomainParquetPredicate.asLong(minimums.get(i));
                if (PredicateUtils.isStatisticsOverflow(type, min, max = TupleDomainParquetPredicate.asLong(maximums.get(i)))) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                rangesBuilder.addRangeInclusive((Object)min, (Object)max);
            }
            return Domain.create((ValueSet)rangesBuilder.build(), (boolean)hasNullValue);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            SortedRangeSet.Builder rangesBuilder = SortedRangeSet.builder((Type)type, (int)minimums.size());
            if (decimalType.isShort()) {
                for (int i = 0; i < minimums.size(); ++i) {
                    long maxValue;
                    Object min = minimums.get(i);
                    Object max = maximums.get(i);
                    long minValue = min instanceof Slice ? ParquetTypeUtils.getShortDecimalValue(((Slice)min).getBytes()) : TupleDomainParquetPredicate.asLong(min);
                    long l = maxValue = max instanceof Slice ? ParquetTypeUtils.getShortDecimalValue(((Slice)max).getBytes()) : TupleDomainParquetPredicate.asLong(max);
                    if (PredicateUtils.isStatisticsOverflow(type, minValue, maxValue)) {
                        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                    }
                    rangesBuilder.addRangeInclusive((Object)minValue, (Object)maxValue);
                }
            } else {
                for (int i = 0; i < minimums.size(); ++i) {
                    Object min = minimums.get(i);
                    Object max = maximums.get(i);
                    Int128 minValue = min instanceof Slice ? Int128.fromBigEndian((byte[])((Slice)min).getBytes()) : Int128.valueOf((long)TupleDomainParquetPredicate.asLong(min));
                    Int128 maxValue = max instanceof Slice ? Int128.fromBigEndian((byte[])((Slice)max).getBytes()) : Int128.valueOf((long)TupleDomainParquetPredicate.asLong(max));
                    rangesBuilder.addRangeInclusive((Object)minValue, (Object)maxValue);
                }
            }
            return Domain.create((ValueSet)rangesBuilder.build(), (boolean)hasNullValue);
        }
        if (type.equals((Object)RealType.REAL)) {
            SortedRangeSet.Builder rangesBuilder = SortedRangeSet.builder((Type)type, (int)minimums.size());
            for (int i = 0; i < minimums.size(); ++i) {
                Float min = (Float)minimums.get(i);
                Float max = (Float)maximums.get(i);
                if (min.isNaN() || max.isNaN()) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                rangesBuilder.addRangeInclusive((Object)Float.floatToRawIntBits(min.floatValue()), (Object)Float.floatToRawIntBits(max.floatValue()));
            }
            return Domain.create((ValueSet)rangesBuilder.build(), (boolean)hasNullValue);
        }
        if (type.equals((Object)DoubleType.DOUBLE)) {
            SortedRangeSet.Builder rangesBuilder = SortedRangeSet.builder((Type)type, (int)minimums.size());
            for (int i = 0; i < minimums.size(); ++i) {
                Double min = (Double)minimums.get(i);
                Double max = (Double)maximums.get(i);
                if (min.isNaN() || max.isNaN()) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                rangesBuilder.addRangeInclusive((Object)min, (Object)max);
            }
            return Domain.create((ValueSet)rangesBuilder.build(), (boolean)hasNullValue);
        }
        if (type instanceof VarcharType) {
            SortedRangeSet.Builder rangesBuilder = SortedRangeSet.builder((Type)type, (int)minimums.size());
            for (int i = 0; i < minimums.size(); ++i) {
                Slice min = (Slice)minimums.get(i);
                Slice max = (Slice)maximums.get(i);
                rangesBuilder.addRangeInclusive((Object)min, (Object)max);
            }
            return Domain.create((ValueSet)rangesBuilder.build(), (boolean)hasNullValue);
        }
        if (type instanceof TimestampType) {
            if (column.getPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT96)) {
                TrinoTimestampEncoder timestampEncoder = TrinoTimestampEncoderFactory.createTimestampEncoder((TimestampType)((TimestampType)type), (DateTimeZone)timeZone);
                SortedRangeSet.Builder rangesBuilder = SortedRangeSet.builder((Type)type, (int)minimums.size());
                for (int i = 0; i < minimums.size(); ++i) {
                    Object min = minimums.get(i);
                    Object max = maximums.get(i);
                    if (!(min instanceof Slice && max instanceof Slice && min.equals(max))) {
                        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                    }
                    rangesBuilder.addValue(timestampEncoder.getTimestamp(ParquetTimestampUtils.decodeInt96Timestamp(Binary.fromConstantByteArray((byte[])((Slice)min).getBytes()))));
                }
                return Domain.create((ValueSet)rangesBuilder.build(), (boolean)hasNullValue);
            }
            if (column.getPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT64)) {
                LogicalTypeAnnotation logicalTypeAnnotation = column.getPrimitiveType().getLogicalTypeAnnotation();
                if (!(logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampTypeAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
                if (timestampTypeAnnotation.getUnit() == null) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                TrinoTimestampEncoder timestampEncoder = TrinoTimestampEncoderFactory.createTimestampEncoder((TimestampType)((TimestampType)type), (DateTimeZone)DateTimeZone.UTC);
                SortedRangeSet.Builder rangesBuilder = SortedRangeSet.builder((Type)type, (int)minimums.size());
                for (int i = 0; i < minimums.size(); ++i) {
                    long min = (Long)minimums.get(i);
                    long max = (Long)maximums.get(i);
                    rangesBuilder.addRangeInclusive(timestampEncoder.getTimestamp(ParquetTimestampUtils.decodeInt64Timestamp(min, timestampTypeAnnotation.getUnit())), timestampEncoder.getTimestamp(ParquetTimestampUtils.decodeInt64Timestamp(max, timestampTypeAnnotation.getUnit())));
                }
                return Domain.create((ValueSet)rangesBuilder.build(), (boolean)hasNullValue);
            }
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, long columnValuesCount, ColumnIndex columnIndex, ParquetDataSourceId id, ColumnDescriptor descriptor, DateTimeZone timeZone) throws ParquetCorruptionException {
        if (columnIndex == null) {
            return Domain.all((Type)type);
        }
        List maxValues = columnIndex.getMaxValues();
        List minValues = columnIndex.getMinValues();
        Optional<List<Long>> nullCounts = Optional.ofNullable(columnIndex.getNullCounts());
        List nullPages = columnIndex.getNullPages();
        String columnName = descriptor.getPrimitiveType().getName();
        if (TupleDomainParquetPredicate.isCorruptedColumnIndex(minValues, maxValues, nullCounts, nullPages)) {
            throw TupleDomainParquetPredicate.corruptionException(columnName, id, columnIndex, null);
        }
        if (maxValues.isEmpty()) {
            return Domain.all((Type)type);
        }
        boolean hasNullValue = true;
        if (nullCounts.isPresent()) {
            long totalNullCount = nullCounts.orElseThrow().stream().mapToLong(value -> value).sum();
            if (totalNullCount == columnValuesCount) {
                return Domain.onlyNull((Type)type);
            }
            hasNullValue = totalNullCount > 0L;
        }
        try {
            int pageCount = minValues.size();
            ColumnIndexValueConverter converter = new ColumnIndexValueConverter();
            Function<ByteBuffer, Object> converterFunction = converter.getConverter(descriptor.getPrimitiveType());
            ArrayList<Object> min = new ArrayList<Object>(pageCount);
            ArrayList<Object> max = new ArrayList<Object>(pageCount);
            for (int i = 0; i < pageCount; ++i) {
                if (((Boolean)nullPages.get(i)).booleanValue()) continue;
                min.add(converterFunction.apply((ByteBuffer)minValues.get(i)));
                max.add(converterFunction.apply((ByteBuffer)maxValues.get(i)));
            }
            return TupleDomainParquetPredicate.getDomain(descriptor, type, min, max, hasNullValue, timeZone);
        }
        catch (Exception e) {
            throw TupleDomainParquetPredicate.corruptionException(columnName, id, columnIndex, e);
        }
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, DictionaryDescriptor dictionaryDescriptor) {
        return TupleDomainParquetPredicate.getDomain(type, dictionaryDescriptor, DateTimeZone.getDefault());
    }

    private static Domain getDomain(Type type, DictionaryDescriptor dictionaryDescriptor, DateTimeZone timeZone) {
        Dictionary dictionary;
        if (dictionaryDescriptor == null) {
            return Domain.all((Type)type);
        }
        ColumnDescriptor columnDescriptor = dictionaryDescriptor.getColumnDescriptor();
        Optional<DictionaryPage> dictionaryPage = dictionaryDescriptor.getDictionaryPage();
        if (dictionaryPage.isEmpty()) {
            return Domain.all((Type)type);
        }
        try {
            dictionary = dictionaryPage.get().getEncoding().initDictionary(columnDescriptor, dictionaryPage.get());
        }
        catch (Exception e) {
            return Domain.all((Type)type);
        }
        int dictionarySize = dictionaryPage.get().getDictionarySize();
        if (dictionarySize == 0) {
            if (dictionaryDescriptor.isNullAllowed()) {
                return Domain.onlyNull((Type)type);
            }
            return Domain.none((Type)type);
        }
        DictionaryValueConverter converter = new DictionaryValueConverter(dictionary);
        Function<Integer, Object> convertFunction = converter.getConverter(columnDescriptor.getPrimitiveType());
        ArrayList<Object> values = new ArrayList<Object>(dictionarySize);
        for (int i = 0; i < dictionarySize; ++i) {
            values.add(convertFunction.apply(i));
        }
        return TupleDomainParquetPredicate.getDomain(columnDescriptor, type, values, values, dictionaryDescriptor.isNullAllowed(), timeZone);
    }

    private static ParquetCorruptionException corruptionException(String column, ParquetDataSourceId id, Statistics<?> statistics, Exception cause) {
        return new ParquetCorruptionException(cause, id, "Corrupted statistics for column \"%s\": [%s]", column, statistics);
    }

    private static ParquetCorruptionException corruptionException(String column, ParquetDataSourceId id, ColumnIndex columnIndex, Exception cause) {
        return new ParquetCorruptionException(cause, id, "Corrupted statistics for column \"%s\". Corrupted column index: [%s]", column, columnIndex);
    }

    private static boolean isCorruptedColumnIndex(List<ByteBuffer> minValues, List<ByteBuffer> maxValues, Optional<List<Long>> nullCounts, List<Boolean> nullPages) {
        if (maxValues == null || minValues == null || nullPages == null) {
            return true;
        }
        int pageCount = nullPages.size();
        return nullCounts.isPresent() && nullCounts.get().size() != pageCount || minValues.size() != pageCount || maxValues.size() != pageCount;
    }

    public static long asLong(Object value) {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return ((Number)value).longValue();
        }
        throw new IllegalArgumentException("Can't convert value to long: " + value.getClass().getName());
    }

    @VisibleForTesting
    public static boolean checkInBloomFilter(BloomFilter bloomFilter, Object predicateValue, Type sqlType) {
        if (sqlType == TinyintType.TINYINT || sqlType == SmallintType.SMALLINT || sqlType == IntegerType.INTEGER || sqlType == DateType.DATE) {
            return bloomFilter.findHash(bloomFilter.hash(Math.toIntExact(((Number)predicateValue).longValue())));
        }
        if (sqlType == BigintType.BIGINT) {
            return bloomFilter.findHash(bloomFilter.hash(((Number)predicateValue).longValue()));
        }
        if (sqlType == DoubleType.DOUBLE) {
            return bloomFilter.findHash(bloomFilter.hash(((Double)predicateValue).doubleValue()));
        }
        if (sqlType == RealType.REAL) {
            return bloomFilter.findHash(bloomFilter.hash(Float.intBitsToFloat(Math.toIntExact(((Number)predicateValue).longValue()))));
        }
        if (sqlType instanceof VarcharType || sqlType instanceof VarbinaryType) {
            return bloomFilter.findHash(bloomFilter.hash(Binary.fromConstantByteBuffer((ByteBuffer)((Slice)predicateValue).toByteBuffer())));
        }
        if (sqlType instanceof UuidType) {
            return bloomFilter.findHash(bloomFilter.hash(Binary.fromConstantByteArray((byte[])((Slice)predicateValue).getBytes())));
        }
        return true;
    }

    private static Optional<Collection<Object>> extractDiscreteValues(int domainCompactionThreshold, ValueSet valueSet) {
        if (!valueSet.isDiscreteSet()) {
            return valueSet.tryExpandRanges(domainCompactionThreshold);
        }
        return Optional.of(valueSet.getDiscreteSet());
    }

    private FilterPredicate convertToParquetFilter(DateTimeZone timeZone) {
        Operators.UserDefined filter = null;
        for (ColumnDescriptor column : this.columns) {
            Domain domain = (Domain)((Map)this.effectivePredicate.getDomains().get()).get(column);
            if (domain == null || domain.isNone() || domain.isAll() || !ParquetMetadataConverter.isMinMaxStatsSupported(column.getPrimitiveType())) continue;
            Operators.UserDefined columnFilter = FilterApi.userDefined((Operators.Column)new TrinoIntColumn(ColumnPath.get((String[])column.getPath())), new DomainUserDefinedPredicate(column, domain, timeZone));
            if (filter == null) {
                filter = columnFilter;
                continue;
            }
            filter = FilterApi.and((FilterPredicate)filter, (FilterPredicate)columnFilter);
        }
        return filter;
    }

    private static class ColumnIndexValueConverter {
        private ColumnIndexValueConverter() {
        }

        private Function<ByteBuffer, Object> getConverter(PrimitiveType primitiveType) {
            return switch (primitiveType.getPrimitiveTypeName()) {
                default -> throw new MatchException(null, null);
                case PrimitiveType.PrimitiveTypeName.BOOLEAN -> buffer -> buffer.get(0) != 0;
                case PrimitiveType.PrimitiveTypeName.INT32 -> buffer -> buffer.order(ByteOrder.LITTLE_ENDIAN).getInt(0);
                case PrimitiveType.PrimitiveTypeName.INT64 -> buffer -> buffer.order(ByteOrder.LITTLE_ENDIAN).getLong(0);
                case PrimitiveType.PrimitiveTypeName.FLOAT -> buffer -> Float.valueOf(buffer.order(ByteOrder.LITTLE_ENDIAN).getFloat(0));
                case PrimitiveType.PrimitiveTypeName.DOUBLE -> buffer -> buffer.order(ByteOrder.LITTLE_ENDIAN).getDouble(0);
                case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, PrimitiveType.PrimitiveTypeName.BINARY, PrimitiveType.PrimitiveTypeName.INT96 -> Slices::wrappedHeapBuffer;
            };
        }
    }

    private static class DictionaryValueConverter {
        private final Dictionary dictionary;

        private DictionaryValueConverter(Dictionary dictionary) {
            this.dictionary = dictionary;
        }

        private Function<Integer, Object> getConverter(PrimitiveType primitiveType) {
            return switch (primitiveType.getPrimitiveTypeName()) {
                default -> throw new MatchException(null, null);
                case PrimitiveType.PrimitiveTypeName.BOOLEAN -> throw new ParquetDecodingException("Dictionary encoding does not support: " + String.valueOf(primitiveType.getPrimitiveTypeName()));
                case PrimitiveType.PrimitiveTypeName.INT32 -> i -> this.dictionary.decodeToInt((int)i);
                case PrimitiveType.PrimitiveTypeName.INT64 -> i -> this.dictionary.decodeToLong((int)i);
                case PrimitiveType.PrimitiveTypeName.FLOAT -> i -> Float.valueOf(this.dictionary.decodeToFloat((int)i));
                case PrimitiveType.PrimitiveTypeName.DOUBLE -> i -> this.dictionary.decodeToDouble((int)i);
                case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, PrimitiveType.PrimitiveTypeName.BINARY, PrimitiveType.PrimitiveTypeName.INT96 -> i -> this.dictionary.decodeToSlice((int)i);
            };
        }
    }

    private static final class TrinoIntColumn
    extends Operators.Column<Integer>
    implements Operators.SupportsLtGt {
        TrinoIntColumn(ColumnPath columnPath) {
            super(columnPath, Integer.class);
        }
    }

    static class DomainUserDefinedPredicate<T extends Comparable<T>>
    extends UserDefinedPredicate<T>
    implements Serializable {
        private final ColumnDescriptor columnDescriptor;
        private final Domain columnDomain;
        private final DateTimeZone timeZone;

        public DomainUserDefinedPredicate(ColumnDescriptor columnDescriptor, Domain domain, DateTimeZone timeZone) {
            this.columnDescriptor = Objects.requireNonNull(columnDescriptor, "columnDescriptor is null");
            this.columnDomain = domain;
            this.timeZone = timeZone;
        }

        public boolean keep(T value) {
            return value != null || this.columnDomain.isNullAllowed();
        }

        public boolean canDrop(org.apache.parquet.filter2.predicate.Statistics<T> statistic) {
            if (statistic == null) {
                return false;
            }
            Comparable min = (Comparable)statistic.getMin();
            Comparable max = (Comparable)statistic.getMax();
            Domain domain = TupleDomainParquetPredicate.getDomain(this.columnDescriptor, this.columnDomain.getType(), (List<Object>)ImmutableList.of((Object)(min instanceof Binary ? Slices.wrappedBuffer((byte[])((Binary)min).getBytes()) : min)), (List<Object>)ImmutableList.of((Object)(max instanceof Binary ? Slices.wrappedBuffer((byte[])((Binary)max).getBytes()) : max)), true, this.timeZone);
            return !this.columnDomain.overlaps(domain);
        }

        public boolean inverseCanDrop(org.apache.parquet.filter2.predicate.Statistics<T> statistics) {
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("columnDescriptor", (Object)this.columnDescriptor).add("columnDomain", (Object)this.columnDomain).toString();
        }
    }
}

