/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.flat.NullsDecoder;

public final class RleBitPackingHybridBooleanDecoder
implements ValueDecoder<byte[]> {
    private final NullsDecoder decoder = new NullsDecoder();

    @Override
    public void init(SimpleSliceInputStream input) {
        input.skip(4);
        this.decoder.init(input.asSlice());
    }

    @Override
    public void read(byte[] values, int offset, int length) {
        boolean[] buffer = new boolean[length];
        this.decoder.readNext(buffer, 0, length);
        for (int i = 0; i < length; ++i) {
            values[offset + i] = buffer[i] ? (byte)0 : 1;
        }
    }

    @Override
    public void skip(int n) {
        this.decoder.skip(n);
    }
}

