/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import io.trino.filesystem.s3.S3Context;
import io.trino.filesystem.s3.S3FileSystemConfig;
import io.trino.filesystem.s3.S3Location;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

final class S3OutputStream
extends OutputStream {
    private final List<CompletedPart> parts = new ArrayList<CompletedPart>();
    private final LocalMemoryContext memoryContext;
    private final S3Client client;
    private final S3Location location;
    private final S3Context context;
    private final int partSize;
    private final RequestPayer requestPayer;
    private final S3FileSystemConfig.S3SseType sseType;
    private final String sseKmsKeyId;
    private int currentPartNumber;
    private byte[] buffer = new byte[0];
    private int bufferSize;
    private int initialBufferSize = 64;
    private boolean closed;
    private boolean failed;
    private boolean multipartUploadStarted;
    private Future<CompletedPart> inProgressUploadFuture;
    private Optional<String> uploadId = Optional.empty();

    public S3OutputStream(AggregatedMemoryContext memoryContext, S3Client client, S3Context context, S3Location location) {
        this.memoryContext = memoryContext.newLocalMemoryContext(S3OutputStream.class.getSimpleName());
        this.client = Objects.requireNonNull(client, "client is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.context = Objects.requireNonNull(context, "context is null");
        this.partSize = context.partSize();
        this.requestPayer = context.requestPayer();
        this.sseType = context.sseType();
        this.sseKmsKeyId = context.sseKmsKeyId();
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOpen();
        this.ensureCapacity(1);
        this.buffer[this.bufferSize] = (byte)b;
        ++this.bufferSize;
        this.flushBuffer(false);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.ensureOpen();
        while (length > 0) {
            this.ensureCapacity(length);
            int copied = Math.min(this.buffer.length - this.bufferSize, length);
            System.arraycopy(bytes, offset, this.buffer, this.bufferSize, copied);
            this.bufferSize += copied;
            this.flushBuffer(false);
            offset += copied;
            length -= copied;
        }
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.flushBuffer(false);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.failed) {
            try {
                this.abortUpload();
                return;
            }
            catch (SdkException e) {
                throw new IOException(e);
            }
        }
        try {
            this.flushBuffer(true);
            this.memoryContext.close();
            this.waitForPreviousUploadFinish();
        }
        catch (IOException | RuntimeException e) {
            this.abortUploadSuppressed(e);
            throw e;
        }
        try {
            this.uploadId.ifPresent(this::finishUpload);
        }
        catch (SdkException e) {
            this.abortUploadSuppressed(e);
            throw new IOException(e);
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream closed: " + String.valueOf(this.location));
        }
    }

    private void ensureCapacity(int extra) {
        int capacity = Math.min(this.partSize, this.bufferSize + extra);
        if (this.buffer.length < capacity) {
            int target = Math.max(this.buffer.length, this.initialBufferSize);
            if (target < capacity) {
                target += target / 2;
                target = Math.clamp((long)target, capacity, this.partSize);
            }
            this.buffer = Arrays.copyOf(this.buffer, target);
            this.memoryContext.setBytes((long)this.buffer.length);
        }
    }

    private void flushBuffer(boolean finished) throws IOException {
        if (finished && !this.multipartUploadStarted) {
            PutObjectRequest request = (PutObjectRequest)((PutObjectRequest.Builder)PutObjectRequest.builder().overrideConfiguration(this.context::applyCredentialProviderOverride).requestPayer(this.requestPayer).bucket(this.location.bucket()).key(this.location.key()).contentLength(Long.valueOf(this.bufferSize)).applyMutation(builder -> {
                switch (this.sseType) {
                    case NONE: {
                        break;
                    }
                    case S3: {
                        builder.serverSideEncryption(ServerSideEncryption.AES256);
                        break;
                    }
                    case KMS: {
                        builder.serverSideEncryption(ServerSideEncryption.AWS_KMS).ssekmsKeyId(this.sseKmsKeyId);
                    }
                }
            })).build();
            ByteBuffer bytes = ByteBuffer.wrap(this.buffer, 0, this.bufferSize);
            try {
                this.client.putObject(request, RequestBody.fromByteBuffer((ByteBuffer)bytes));
                return;
            }
            catch (SdkException e) {
                this.failed = true;
                throw new IOException(e);
            }
        }
        if (this.bufferSize == this.partSize || finished && this.bufferSize > 0) {
            byte[] data = this.buffer;
            int length = this.bufferSize;
            if (finished) {
                this.buffer = null;
            } else {
                this.buffer = new byte[0];
                this.initialBufferSize = this.partSize;
                this.bufferSize = 0;
            }
            this.memoryContext.setBytes(0L);
            try {
                this.waitForPreviousUploadFinish();
            }
            catch (IOException e) {
                this.failed = true;
                this.abortUploadSuppressed(e);
                throw e;
            }
            this.multipartUploadStarted = true;
            this.inProgressUploadFuture = CompletableFuture.supplyAsync(() -> this.uploadPage(data, length));
        }
    }

    private void waitForPreviousUploadFinish() throws IOException {
        if (this.inProgressUploadFuture == null) {
            return;
        }
        try {
            this.inProgressUploadFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        catch (ExecutionException e) {
            throw new IOException("Streaming upload failed", e);
        }
    }

    private CompletedPart uploadPage(byte[] data, int length) {
        CreateMultipartUploadRequest request;
        if (this.uploadId.isEmpty()) {
            request = (CreateMultipartUploadRequest)((CreateMultipartUploadRequest.Builder)CreateMultipartUploadRequest.builder().overrideConfiguration(this.context::applyCredentialProviderOverride).requestPayer(this.requestPayer).bucket(this.location.bucket()).key(this.location.key()).applyMutation(builder -> {
                switch (this.sseType) {
                    case NONE: {
                        break;
                    }
                    case S3: {
                        builder.serverSideEncryption(ServerSideEncryption.AES256);
                        break;
                    }
                    case KMS: {
                        builder.serverSideEncryption(ServerSideEncryption.AWS_KMS).ssekmsKeyId(this.sseKmsKeyId);
                    }
                }
            })).build();
            this.uploadId = Optional.of(this.client.createMultipartUpload(request).uploadId());
        }
        ++this.currentPartNumber;
        request = (UploadPartRequest)UploadPartRequest.builder().overrideConfiguration(this.context::applyCredentialProviderOverride).requestPayer(this.requestPayer).bucket(this.location.bucket()).key(this.location.key()).contentLength(Long.valueOf(length)).uploadId(this.uploadId.get()).partNumber(Integer.valueOf(this.currentPartNumber)).build();
        ByteBuffer bytes = ByteBuffer.wrap(data, 0, length);
        UploadPartResponse response = this.client.uploadPart((UploadPartRequest)request, RequestBody.fromByteBuffer((ByteBuffer)bytes));
        CompletedPart part = (CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(this.currentPartNumber)).eTag(response.eTag()).build();
        this.parts.add(part);
        return part;
    }

    private void finishUpload(String uploadId) {
        CompleteMultipartUploadRequest request = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().overrideConfiguration(this.context::applyCredentialProviderOverride).requestPayer(this.requestPayer).bucket(this.location.bucket()).key(this.location.key()).uploadId(uploadId).multipartUpload(x -> x.parts(this.parts)).build();
        this.client.completeMultipartUpload(request);
    }

    private void abortUpload() {
        this.uploadId.map(id -> (AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().overrideConfiguration(this.context::applyCredentialProviderOverride).requestPayer(this.requestPayer).bucket(this.location.bucket()).key(this.location.key()).uploadId(id).build()).ifPresent(arg_0 -> ((S3Client)this.client).abortMultipartUpload(arg_0));
    }

    private void abortUploadSuppressed(Throwable throwable) {
        block2: {
            try {
                this.abortUpload();
            }
            catch (Throwable t) {
                if (throwable == t) break block2;
                throwable.addSuppressed(t);
            }
        }
    }
}

