/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Literal;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public class DecimalLiteral
extends Literal {
    private final String value;

    public DecimalLiteral(String value) {
        this(Optional.empty(), value);
    }

    public DecimalLiteral(NodeLocation location, String value) {
        this(Optional.of(location), value);
    }

    public DecimalLiteral(Optional<NodeLocation> location, String value) {
        super(location);
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDecimalLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalLiteral that = (DecimalLiteral)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!DecimalLiteral.sameClass(this, other)) {
            return false;
        }
        DecimalLiteral otherLiteral = (DecimalLiteral)other;
        return this.value.equals(otherLiteral.value);
    }
}

