/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.ShortWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyShortObjectInspector;

public class LazyShort
extends LazyPrimitive<LazyShortObjectInspector, ShortWritable> {
    public LazyShort(LazyShortObjectInspector oi) {
        super(oi);
        this.data = new ShortWritable();
    }

    public LazyShort(LazyShort copy) {
        super(copy);
        this.data = new ShortWritable(((ShortWritable)copy.data).get());
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        if (!LazyUtils.isNumberMaybe(bytes.getData(), start, length)) {
            this.isNull = true;
            return;
        }
        try {
            ((ShortWritable)this.data).set(LazyShort.parseShort(bytes.getData(), start, length));
            this.isNull = false;
        }
        catch (NumberFormatException e) {
            this.isNull = true;
            this.logExceptionMessage(bytes, start, length, "SMALLINT");
        }
    }

    public static short parseShort(byte[] bytes, int start, int length) {
        return LazyShort.parseShort(bytes, start, length, 10);
    }

    public static short parseShort(byte[] bytes, int start, int length, int radix) {
        return LazyShort.parseShort(bytes, start, length, radix, false);
    }

    public static short parseShort(byte[] bytes, int start, int length, int radix, boolean trim) {
        int intValue = LazyInteger.parseInt(bytes, start, length, radix, trim);
        short result = (short)intValue;
        if (result == intValue) {
            return result;
        }
        throw new NumberFormatException();
    }
}

