/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.Date;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.HiveChar;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.HiveDecimal;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.HiveVarchar;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.Timestamp;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.TimestampTZ;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.ByteStream;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyLong;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveIntervalDayTimeObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveIntervalYearMonthObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBooleanObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableByteObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableDateObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableDoubleObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableFloatObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveCharObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveDecimalObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveIntervalDayTimeObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveIntervalYearMonthObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveVarcharObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableIntObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableLongObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableShortObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampLocalTZObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampLocalTZObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import com.linkedin.coral.$internal.org.apache.hadoop.io.BytesWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Text;
import java.io.OutputStream;
import java.time.ZoneId;

public class PrimitiveObjectInspectorConverter {

    public static class HiveCharConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableHiveCharObjectInspector outputOI;
        Object hc;

        public HiveCharConverter(PrimitiveObjectInspector inputOI, SettableHiveCharObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.hc = outputOI.create(new HiveChar("", -1));
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            switch (this.inputOI.getPrimitiveCategory()) {
                case BOOLEAN: {
                    return this.outputOI.set(this.hc, ((BooleanObjectInspector)this.inputOI).get(input) ? new HiveChar("TRUE", -1) : new HiveChar("FALSE", -1));
                }
            }
            return this.outputOI.set(this.hc, PrimitiveObjectInspectorUtils.getHiveChar(input, this.inputOI));
        }
    }

    public static class HiveVarcharConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableHiveVarcharObjectInspector outputOI;
        Object hc;

        public HiveVarcharConverter(PrimitiveObjectInspector inputOI, SettableHiveVarcharObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.hc = outputOI.create(new HiveVarchar("", -1));
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            switch (this.inputOI.getPrimitiveCategory()) {
                case BOOLEAN: {
                    return this.outputOI.set(this.hc, ((BooleanObjectInspector)this.inputOI).get(input) ? new HiveVarchar("TRUE", -1) : new HiveVarchar("FALSE", -1));
                }
            }
            return this.outputOI.set(this.hc, PrimitiveObjectInspectorUtils.getHiveVarchar(input, this.inputOI));
        }
    }

    public static class StringConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;

        public StringConverter(PrimitiveObjectInspector inputOI) {
            this.inputOI = inputOI;
        }

        @Override
        public Object convert(Object input) {
            return PrimitiveObjectInspectorUtils.getString(input, this.inputOI);
        }
    }

    public static class TextConverter
    implements ObjectInspectorConverters.Converter {
        private final PrimitiveObjectInspector inputOI;
        private final Text t = new Text();
        private final ByteStream.Output out = new ByteStream.Output();
        private static byte[] trueBytes = new byte[]{84, 82, 85, 69};
        private static byte[] falseBytes = new byte[]{70, 65, 76, 83, 69};

        public TextConverter(PrimitiveObjectInspector inputOI) {
            this.inputOI = inputOI;
        }

        @Override
        public Text convert(Object input) {
            if (input == null) {
                return null;
            }
            switch (this.inputOI.getPrimitiveCategory()) {
                case VOID: {
                    return null;
                }
                case BOOLEAN: {
                    this.t.set(((BooleanObjectInspector)this.inputOI).get(input) ? trueBytes : falseBytes);
                    return this.t;
                }
                case BYTE: {
                    this.out.reset();
                    LazyInteger.writeUTF8NoException((OutputStream)((Object)this.out), ((ByteObjectInspector)this.inputOI).get(input));
                    this.t.set(this.out.getData(), 0, this.out.getLength());
                    return this.t;
                }
                case SHORT: {
                    this.out.reset();
                    LazyInteger.writeUTF8NoException((OutputStream)((Object)this.out), ((ShortObjectInspector)this.inputOI).get(input));
                    this.t.set(this.out.getData(), 0, this.out.getLength());
                    return this.t;
                }
                case INT: {
                    this.out.reset();
                    LazyInteger.writeUTF8NoException((OutputStream)((Object)this.out), ((IntObjectInspector)this.inputOI).get(input));
                    this.t.set(this.out.getData(), 0, this.out.getLength());
                    return this.t;
                }
                case LONG: {
                    this.out.reset();
                    LazyLong.writeUTF8NoException((OutputStream)((Object)this.out), ((LongObjectInspector)this.inputOI).get(input));
                    this.t.set(this.out.getData(), 0, this.out.getLength());
                    return this.t;
                }
                case FLOAT: {
                    this.t.set(String.valueOf(((FloatObjectInspector)this.inputOI).get(input)));
                    return this.t;
                }
                case DOUBLE: {
                    this.t.set(String.valueOf(((DoubleObjectInspector)this.inputOI).get(input)));
                    return this.t;
                }
                case STRING: {
                    if (this.inputOI.preferWritable()) {
                        this.t.set(((StringObjectInspector)this.inputOI).getPrimitiveWritableObject(input));
                    } else {
                        this.t.set(((StringObjectInspector)this.inputOI).getPrimitiveJavaObject(input));
                    }
                    return this.t;
                }
                case CHAR: {
                    if (this.inputOI.preferWritable()) {
                        this.t.set(((HiveCharObjectInspector)this.inputOI).getPrimitiveWritableObject(input).getStrippedValue());
                    } else {
                        this.t.set(((HiveCharObjectInspector)this.inputOI).getPrimitiveJavaObject(input).getStrippedValue());
                    }
                    return this.t;
                }
                case VARCHAR: {
                    if (this.inputOI.preferWritable()) {
                        this.t.set(((HiveVarcharObjectInspector)this.inputOI).getPrimitiveWritableObject(input).toString());
                    } else {
                        this.t.set(((HiveVarcharObjectInspector)this.inputOI).getPrimitiveJavaObject(input).toString());
                    }
                    return this.t;
                }
                case DATE: {
                    this.t.set(((DateObjectInspector)this.inputOI).getPrimitiveWritableObject(input).toString());
                    return this.t;
                }
                case TIMESTAMP: {
                    this.t.set(((TimestampObjectInspector)this.inputOI).getPrimitiveWritableObject(input).toString());
                    return this.t;
                }
                case TIMESTAMPLOCALTZ: {
                    this.t.set(((TimestampLocalTZObjectInspector)this.inputOI).getPrimitiveWritableObject(input).toString());
                    return this.t;
                }
                case INTERVAL_YEAR_MONTH: {
                    this.t.set(((HiveIntervalYearMonthObjectInspector)this.inputOI).getPrimitiveWritableObject(input).toString());
                    return this.t;
                }
                case INTERVAL_DAY_TIME: {
                    this.t.set(((HiveIntervalDayTimeObjectInspector)this.inputOI).getPrimitiveWritableObject(input).toString());
                    return this.t;
                }
                case BINARY: {
                    BinaryObjectInspector binaryOI = (BinaryObjectInspector)this.inputOI;
                    if (binaryOI.preferWritable()) {
                        BytesWritable bytes = binaryOI.getPrimitiveWritableObject(input);
                        this.t.set(bytes.getBytes(), 0, bytes.getLength());
                    } else {
                        this.t.set(binaryOI.getPrimitiveJavaObject(input));
                    }
                    return this.t;
                }
                case DECIMAL: {
                    this.t.set(((HiveDecimalObjectInspector)this.inputOI).getPrimitiveWritableObject(input).toString());
                    return this.t;
                }
            }
            throw new RuntimeException("Hive 2 Internal error: type = " + this.inputOI.getTypeName());
        }
    }

    public static class BinaryConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableBinaryObjectInspector outputOI;
        Object r;

        public BinaryConverter(PrimitiveObjectInspector inputOI, SettableBinaryObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(new byte[0]);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getBinary(input, this.inputOI));
        }
    }

    public static class HiveDecimalConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableHiveDecimalObjectInspector outputOI;
        Object r;

        public HiveDecimalConverter(PrimitiveObjectInspector inputOI, SettableHiveDecimalObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(HiveDecimal.ZERO);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getHiveDecimal(input, this.inputOI));
        }
    }

    public static class HiveIntervalDayTimeConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableHiveIntervalDayTimeObjectInspector outputOI;
        Object r;

        public HiveIntervalDayTimeConverter(PrimitiveObjectInspector inputOI, SettableHiveIntervalDayTimeObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(new HiveIntervalDayTime());
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getHiveIntervalDayTime(input, this.inputOI));
        }
    }

    public static class HiveIntervalYearMonthConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableHiveIntervalYearMonthObjectInspector outputOI;
        Object r;

        public HiveIntervalYearMonthConverter(PrimitiveObjectInspector inputOI, SettableHiveIntervalYearMonthObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(new HiveIntervalYearMonth());
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getHiveIntervalYearMonth(input, this.inputOI));
        }
    }

    public static class TimestampLocalTZConverter
    implements ObjectInspectorConverters.Converter {
        final PrimitiveObjectInspector inputOI;
        final SettableTimestampLocalTZObjectInspector outputOI;
        final Object r;
        final ZoneId timeZone;

        public TimestampLocalTZConverter(PrimitiveObjectInspector inputOI, SettableTimestampLocalTZObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(new TimestampTZ());
            this.timeZone = ((TimestampLocalTZTypeInfo)outputOI.getTypeInfo()).timeZone();
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getTimestampLocalTZ(input, this.inputOI, this.timeZone));
        }
    }

    public static class TimestampConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableTimestampObjectInspector outputOI;
        boolean intToTimestampInSeconds = false;
        Object r;

        public TimestampConverter(PrimitiveObjectInspector inputOI, SettableTimestampObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(new Timestamp());
        }

        public void setIntToTimestampInSeconds(boolean intToTimestampInSeconds) {
            this.intToTimestampInSeconds = intToTimestampInSeconds;
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getTimestamp(input, this.inputOI, this.intToTimestampInSeconds));
        }
    }

    public static class DateConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableDateObjectInspector outputOI;
        Object r;

        public DateConverter(PrimitiveObjectInspector inputOI, SettableDateObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(new Date());
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getDate(input, this.inputOI));
        }
    }

    public static class DoubleConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableDoubleObjectInspector outputOI;
        Object r;

        public DoubleConverter(PrimitiveObjectInspector inputOI, SettableDoubleObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(0.0);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getDouble(input, this.inputOI));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class FloatConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableFloatObjectInspector outputOI;
        Object r;

        public FloatConverter(PrimitiveObjectInspector inputOI, SettableFloatObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(0.0f);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getFloat(input, this.inputOI));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class LongConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableLongObjectInspector outputOI;
        Object r;

        public LongConverter(PrimitiveObjectInspector inputOI, SettableLongObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(0L);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getLong(input, this.inputOI));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class IntConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableIntObjectInspector outputOI;
        Object r;

        public IntConverter(PrimitiveObjectInspector inputOI, SettableIntObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(0);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getInt(input, this.inputOI));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class ShortConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableShortObjectInspector outputOI;
        Object r;

        public ShortConverter(PrimitiveObjectInspector inputOI, SettableShortObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create((short)0);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getShort(input, this.inputOI));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class ByteConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableByteObjectInspector outputOI;
        Object r;

        public ByteConverter(PrimitiveObjectInspector inputOI, SettableByteObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create((byte)0);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getByte(input, this.inputOI));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class BooleanConverter
    implements ObjectInspectorConverters.Converter {
        PrimitiveObjectInspector inputOI;
        SettableBooleanObjectInspector outputOI;
        Object r;

        public BooleanConverter(PrimitiveObjectInspector inputOI, SettableBooleanObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.r = outputOI.create(false);
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return this.outputOI.set(this.r, PrimitiveObjectInspectorUtils.getBoolean(input, this.inputOI));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }
}

