/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.io;

import com.linkedin.coral.;
import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configuration;
import com.linkedin.coral.$internal.org.apache.hadoop.io.LongWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.io.NullWritable;
import java.io.IOException;
import java.util.HashMap;

@.InterfaceAudience.Private
@.InterfaceStability.Evolving
public class WritableName {
    private static HashMap<String, Class<?>> NAME_TO_CLASS = new HashMap();
    private static HashMap<Class<?>, String> CLASS_TO_NAME = new HashMap();

    private WritableName() {
    }

    public static synchronized void setName(Class<?> writableClass, String name) {
        CLASS_TO_NAME.put(writableClass, name);
        NAME_TO_CLASS.put(name, writableClass);
    }

    public static synchronized void addName(Class<?> writableClass, String name) {
        NAME_TO_CLASS.put(name, writableClass);
    }

    public static synchronized String getName(Class<?> writableClass) {
        String name = CLASS_TO_NAME.get(writableClass);
        if (name != null) {
            return name;
        }
        return writableClass.getName();
    }

    public static synchronized Class<?> getClass(String name, Configuration conf) throws IOException {
        Class<?> writableClass = NAME_TO_CLASS.get(name);
        if (writableClass != null) {
            return writableClass;
        }
        try {
            return conf.getClassByName(name);
        }
        catch (ClassNotFoundException e) {
            IOException newE = new IOException("WritableName can't load class: " + name);
            newE.initCause(e);
            throw newE;
        }
    }

    static {
        WritableName.setName(NullWritable.class, "null");
        WritableName.setName(LongWritable.class, "long");
        WritableName.setName(.UTF8.class, "UTF8");
        WritableName.setName(.MD5Hash.class, "MD5Hash");
    }
}

