/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.org.antlr.stringtemplate.language;

import com.linkedin.coral.calcite.$internal.org.antlr.stringtemplate.StringTemplate;
import java.util.LinkedHashMap;

public class FormalArgument {
    public static final int OPTIONAL = 1;
    public static final int REQUIRED = 2;
    public static final int ZERO_OR_MORE = 4;
    public static final int ONE_OR_MORE = 8;
    public static final String[] suffixes = new String[]{null, "?", "", null, "*", null, null, null, "+"};
    public static final LinkedHashMap UNKNOWN = new LinkedHashMap();
    public String name;
    public StringTemplate defaultValueST;

    public FormalArgument(String name) {
        this.name = name;
    }

    public FormalArgument(String name, StringTemplate defaultValueST) {
        this.name = name;
        this.defaultValueST = defaultValueST;
    }

    public static String getCardinalityName(int cardinality) {
        switch (cardinality) {
            case 1: {
                return "optional";
            }
            case 2: {
                return "exactly one";
            }
            case 4: {
                return "zero-or-more";
            }
            case 8: {
                return "one-or-more";
            }
        }
        return "unknown";
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FormalArgument)) {
            return false;
        }
        FormalArgument other = (FormalArgument)o;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return (this.defaultValueST == null || other.defaultValueST != null) && (this.defaultValueST != null || other.defaultValueST == null);
    }

    public String toString() {
        if (this.defaultValueST != null) {
            return this.name + "=" + this.defaultValueST;
        }
        return this.name;
    }
}

