/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.linkedin.coral.common.functions.Function;
import com.linkedin.coral.hive.hive2rel.functions.CoralINOperator;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Util;

public class HiveFunction {
    public static final Function CAST = new Function("cast", SqlStdOperatorTable.CAST){

        @Override
        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkNotNull(operands);
            Preconditions.checkArgument((operands.size() == 1 ? 1 : 0) != 0);
            return super.createCall(null, (List<SqlNode>)ImmutableList.of((Object)operands.get(0), (Object)function), null);
        }
    };
    public static final Function CASE = new Function("case", SqlStdOperatorTable.CASE){

        @Override
        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkNotNull(operands);
            ArrayList<SqlNode> whenNodes = new ArrayList<SqlNode>();
            ArrayList<SqlNode> thenNodes = new ArrayList<SqlNode>();
            for (int i = 1; i < operands.size() - 1; i += 2) {
                whenNodes.add(operands.get(i));
                thenNodes.add(operands.get(i + 1));
            }
            SqlNode elseNode = operands.size() % 2 == 1 ? SqlLiteral.createNull(SqlParserPos.ZERO) : Util.last(operands);
            return SqlCase.createSwitched(SqlParserPos.ZERO, operands.get(0), new SqlNodeList(whenNodes, SqlParserPos.ZERO), new SqlNodeList(thenNodes, SqlParserPos.ZERO), elseNode);
        }
    };
    public static final Function WHEN = new Function("when", SqlStdOperatorTable.CASE){

        @Override
        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkNotNull(operands);
            ArrayList<SqlNode> whenNodes = new ArrayList<SqlNode>();
            ArrayList<SqlNode> thenNodes = new ArrayList<SqlNode>();
            for (int i = 0; i < operands.size() - 1; i += 2) {
                whenNodes.add(operands.get(i));
                thenNodes.add(operands.get(i + 1));
            }
            SqlNode elseNode = operands.size() % 2 == 0 ? SqlLiteral.createNull(SqlParserPos.ZERO) : Util.last(operands);
            return new SqlCase(SqlParserPos.ZERO, null, new SqlNodeList(whenNodes, SqlParserPos.ZERO), new SqlNodeList(thenNodes, SqlParserPos.ZERO), elseNode);
        }
    };
    public static final Function BETWEEN = new Function("between", SqlStdOperatorTable.BETWEEN){

        @Override
        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkNotNull(operands);
            Preconditions.checkArgument((operands.size() >= 3 && operands.get(0) instanceof SqlLiteral ? 1 : 0) != 0);
            SqlLiteral opType = (SqlLiteral)operands.get(0);
            List<SqlNode> callParams = operands.subList(1, operands.size());
            if (opType.booleanValue()) {
                return SqlStdOperatorTable.NOT_BETWEEN.createCall(SqlParserPos.ZERO, callParams);
            }
            return SqlStdOperatorTable.BETWEEN.createCall(SqlParserPos.ZERO, callParams);
        }
    };
    public static final Function IN = new Function("in", CoralINOperator.IN){

        @Override
        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkState((operands.size() >= 2 ? 1 : 0) != 0);
            if (operands.get(1) instanceof SqlSelect) {
                return SqlStdOperatorTable.IN.createCall(SqlParserPos.ZERO, operands);
            }
            return this.getSqlOperator().createCall(SqlParserPos.ZERO, operands);
        }
    };
}

