/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.parsetree;

import com.google.common.base.Preconditions;
import com.linkedin.coral.hive.hive2rel.parsetree.UnexpectedASTChildCountException;
import com.linkedin.coral.hive.hive2rel.parsetree.UnhandledASTTokenException;
import com.linkedin.coral.hive.hive2rel.parsetree.parser.ASTNode;
import com.linkedin.coral.hive.hive2rel.parsetree.parser.Node;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractASTVisitor<R, C> {
    protected R visit(ASTNode node, C ctx) {
        if (node == null) {
            return null;
        }
        switch (node.getType()) {
            case 0: {
                return this.visitNil(node, ctx);
            }
            case 865: {
                return this.visitSubquery(node, ctx);
            }
            case 866: {
                return this.visitSubqueryExpr(node, ctx);
            }
            case 867: {
                return this.visitSubqueryOp(node, ctx);
            }
            case 705: {
                return this.visitFrom(node, ctx);
            }
            case 913: 
            case 915: {
                return this.visitUnion(node, ctx);
            }
            case 811: {
                return this.visitQueryNode(node, ctx);
            }
            case 900: {
                return this.visitTabRefNode(node, ctx);
            }
            case 899: {
                return this.visitTabnameNode(node, ctx);
            }
            case 27: 
            case 71: 
            case 72: {
                return this.visitIdentifier(node, ctx);
            }
            case 314: {
                return this.visitStringLiteral(node, ctx);
            }
            case 7: {
                return this.visitBigintLiteral(node, ctx);
            }
            case 731: {
                return this.visitInsert(node, ctx);
            }
            case 828: {
                return this.visitSelectDistinct(node, ctx);
            }
            case 754: {
                return this.visitLimit(node, ctx);
            }
            case 827: {
                return this.visitSelect(node, ctx);
            }
            case 829: {
                return this.visitSelectExpr(node, ctx);
            }
            case 608: {
                return this.visitAllColRef(node, ctx);
            }
            case 719: {
                return this.visitHaving(node, ctx);
            }
            case 930: {
                return this.visitWhere(node, ctx);
            }
            case 716: {
                return this.visitGroupBy(node, ctx);
            }
            case 787: {
                return this.visitOrderBy(node, ctx);
            }
            case 901: {
                return this.visitSortColNameAsc(node, ctx);
            }
            case 902: {
                return this.visitSortColNameDesc(node, ctx);
            }
            case 707: {
                return this.visitFunction(node, ctx);
            }
            case 708: {
                return this.visitFunctionDistinct(node, ctx);
            }
            case 709: {
                return this.visitFunctionStar(node, ctx);
            }
            case 18: {
                return this.visitDotOperator(node, ctx);
            }
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 34: 
            case 154: 
            case 176: 
            case 183: 
            case 213: 
            case 223: 
            case 295: 
            case 296: 
            case 300: 
            case 301: 
            case 302: 
            case 304: 
            case 312: 
            case 315: {
                return this.visitOperator(node, ctx);
            }
            case 298: {
                return this.visitLParen(node, ctx);
            }
            case 266: {
                return this.visitTrue(node, ctx);
            }
            case 108: {
                return this.visitFalse(node, ctx);
            }
            case 766: {
                return this.visitNullToken(node, ctx);
            }
            case 303: {
                return this.visitNumber(node, ctx);
            }
            case 896: {
                return this.visitTableTokOrCol(node, ctx);
            }
            case -1: 
            case 684: {
                return null;
            }
            case 36: 
            case 50: 
            case 51: 
            case 103: 
            case 130: 
            case 133: 
            case 165: 
            case 251: 
            case 269: 
            case 288: 
            case 744: 
            case 745: {
                return this.visitKeywordLiteral(node, ctx);
            }
            case 652: {
                return this.visitBoolean(node, ctx);
            }
            case 733: {
                return this.visitInt(node, ctx);
            }
            case 862: {
                return this.visitString(node, ctx);
            }
            case 651: {
                return this.visitBinary(node, ctx);
            }
            case 688: {
                return this.visitDouble(node, ctx);
            }
            case 704: {
                return this.visitFloat(node, ctx);
            }
            case 650: {
                return this.visitBigInt(node, ctx);
            }
            case 908: {
                return this.visitTinyInt(node, ctx);
            }
            case 857: {
                return this.visitSmallInt(node, ctx);
            }
            case 654: {
                return this.visitChar(node, ctx);
            }
            case 678: {
                return this.visitDecimal(node, ctx);
            }
            case 926: {
                return this.visitVarchar(node, ctx);
            }
            case 673: {
                return this.visitDate(node, ctx);
            }
            case 674: {
                return this.visitDateLiteral(node, ctx);
            }
            case 906: {
                return this.visitTimestamp(node, ctx);
            }
            case 747: {
                return this.visitJoin(node, ctx);
            }
            case 750: {
                return this.visitLeftOuterJoin(node, ctx);
            }
            case 823: {
                return this.visitRightOuterJoin(node, ctx);
            }
            case 706: {
                return this.visitFullOuterJoin(node, ctx);
            }
            case 667: {
                return this.visitCrossJoin(node, ctx);
            }
            case 751: {
                return this.visitLeftSemiJoin(node, ctx);
            }
            case 748: {
                return this.visitLateralView(node, ctx);
            }
            case 749: {
                return this.visitLateralViewOuter(node, ctx);
            }
            case 872: {
                return this.visitTabAlias(node, ctx);
            }
            case 668: {
                return this.visitCTE(node, ctx);
            }
            case 933: {
                return this.visitWindowSpec(node, ctx);
            }
            case 789: {
                return this.visitPartitioningSpec(node, ctx);
            }
            case 687: {
                return this.visitDistributeBy(node, ctx);
            }
            case 932: {
                return this.visitWindowRange(node, ctx);
            }
            case 934: {
                return this.visitWindowValues(node, ctx);
            }
            case 734: 
            case 736: 
            case 737: 
            case 738: 
            case 739: 
            case 740: 
            case 741: 
            case 743: {
                return this.visitIntervalLiteral(node, ctx);
            }
            case 198: {
                return this.visitPreceding(node, ctx);
            }
            case 115: {
                return this.visitFollowing(node, ctx);
            }
            case 70: {
                return this.visitCurrentRow(node, ctx);
            }
        }
        throw new UnhandledASTTokenException(node);
    }

    protected R visitKeywordLiteral(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected List<R> visitChildren(ASTNode node, C ctx) {
        Preconditions.checkNotNull((Object)node, ctx);
        Preconditions.checkNotNull(ctx);
        if (node.getChildren() == null) {
            return null;
        }
        return this.visitChildren(node.getChildren(), ctx);
    }

    protected List<R> visitChildren(List<Node> nodes, C ctx) {
        return nodes.stream().map(n -> this.visit((ASTNode)n, ctx)).collect(Collectors.toList());
    }

    protected R visitOptionalChildByType(ASTNode node, C ctx, int nodeType) {
        List<R> results = this.visitChildrenByType(node, ctx, nodeType);
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new UnexpectedASTChildCountException(node, nodeType, 1, results.size());
        }
        return results.get(0);
    }

    protected List<R> visitChildrenByType(ASTNode node, C ctx, int nodeType) {
        Preconditions.checkNotNull((Object)node, ctx);
        Preconditions.checkNotNull(ctx);
        if (node.getChildren() == null) {
            return null;
        }
        return this.visitChildrenByType(node.getChildren(), ctx, nodeType);
    }

    protected List<R> visitChildrenByType(List<Node> nodes, C ctx, int nodeType) {
        return nodes.stream().filter(node -> ((ASTNode)node).getType() == nodeType).map(n -> this.visit((ASTNode)n, ctx)).collect(Collectors.toList());
    }

    protected R visitTabAlias(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLateralView(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLateralViewOuter(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLeftSemiJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitCrossJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFullOuterJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitRightOuterJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLeftOuterJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFalse(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTrue(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitNullToken(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLimit(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitUnion(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitNumber(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitAllColRef(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitHaving(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitWhere(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSortColNameDesc(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSortColNameAsc(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitOrderBy(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitGroupBy(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitOperator(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDotOperator(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLParen(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFunctionStar(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFunctionDistinct(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFunction(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSelectExpr(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSelectDistinct(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSelect(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTabRefNode(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTabnameNode(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSubqueryOp(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSubqueryExpr(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSubquery(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFrom(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitIdentifier(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitStringLiteral(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitBigintLiteral(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitQueryNode(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitNil(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitBoolean(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitInt(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSmallInt(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitBigInt(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTinyInt(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFloat(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDouble(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitVarchar(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitChar(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitString(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitBinary(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDecimal(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDate(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDateLiteral(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTimestamp(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTableTokOrCol(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitInsert(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitIsNull(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitIsNotNull(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitCTE(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitWindowSpec(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitPartitioningSpec(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDistributeBy(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitWindowRange(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitWindowValues(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitPreceding(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFollowing(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitCurrentRow(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitIntervalLiteral(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }
}

