/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.text;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.hive.formats.compression.Codec;
import io.trino.hive.formats.compression.CompressionKind;
import io.trino.hive.formats.line.FooterAwareLineReader;
import io.trino.hive.formats.line.LineBuffer;
import io.trino.hive.formats.line.LineReader;
import io.trino.hive.formats.line.LineReaderFactory;
import io.trino.hive.formats.line.text.TextLineReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Set;

public class TextLineReaderFactory
implements LineReaderFactory {
    private final int fileBufferSize;
    private final int initialLineBufferSize;
    private final int maxLineLength;

    public TextLineReaderFactory(int fileBufferSize, int initialLineBufferSize, int maxLineLength) {
        this.fileBufferSize = fileBufferSize;
        this.initialLineBufferSize = initialLineBufferSize;
        this.maxLineLength = maxLineLength;
    }

    @Override
    public Set<String> getHiveInputFormatClassNames() {
        return ImmutableSet.of((Object)"org.apache.hadoop.mapred.TextInputFormat", (Object)"org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat");
    }

    @Override
    public LineBuffer createLineBuffer() {
        return new LineBuffer(this.initialLineBufferSize, this.maxLineLength);
    }

    @Override
    public LineReader createLineReader(TrinoInputFile inputFile, long start, long length, int headerCount, int footerCount) throws IOException {
        TrinoInputStream inputStream = inputFile.newStream();
        try {
            LineReader lineReader;
            Optional<Codec> codec = CompressionKind.forFile(inputFile.location().fileName()).map(CompressionKind::createCodec);
            if (codec.isPresent()) {
                Preconditions.checkArgument((start == 0L ? 1 : 0) != 0, (Object)"Compressed files are not splittable");
                lineReader = TextLineReader.createCompressedReader((InputStream)inputStream, this.fileBufferSize, codec.get());
            } else {
                lineReader = TextLineReader.createUncompressedReader((InputStream)inputStream, this.fileBufferSize, start, length);
            }
            if (headerCount > 0) {
                Preconditions.checkArgument((start == 0L || headerCount == 1 ? 1 : 0) != 0, (Object)"file cannot be split when there is more than one header row");
                if (start == 0L) {
                    this.skipHeader(lineReader, headerCount);
                }
            }
            if (footerCount > 0) {
                Preconditions.checkArgument((start == 0L ? 1 : 0) != 0, (Object)"file cannot be split when there are footer rows");
                lineReader = new FooterAwareLineReader(lineReader, footerCount, this::createLineBuffer);
            }
            return lineReader;
        }
        catch (Throwable throwable) {
            TrinoInputStream ignored = inputStream;
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                }
                throw throwable2;
            }
        }
    }

    private void skipHeader(LineReader lineReader, int headerCount) throws IOException {
        LineBuffer lineBuffer = this.createLineBuffer();
        for (int i = 0; i < headerCount; ++i) {
            if (lineReader.readLine(lineBuffer)) continue;
            return;
        }
    }
}

