/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.inject.Module;
import io.trino.execution.FailureInjector;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.exchange.filesystem.FileSystemExchangePlugin;
import io.trino.plugin.exchange.filesystem.containers.MinioStorage;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.spi.ErrorType;
import io.trino.spi.Plugin;
import io.trino.testing.BaseFailureRecoveryTest;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseDeltaFailureRecoveryTest
extends BaseFailureRecoveryTest {
    private final String bucketName;

    protected BaseDeltaFailureRecoveryTest(RetryPolicy retryPolicy) {
        super(retryPolicy);
        this.bucketName = "test-delta-lake-" + retryPolicy.name().toLowerCase(Locale.ENGLISH) + "-failure-recovery-" + TestingNames.randomNameSuffix();
    }

    protected QueryRunner createQueryRunner(List<TpchTable<?>> requiredTpchTables, Map<String, String> configProperties, Map<String, String> coordinatorProperties, Module failureInjectionModule) throws Exception {
        Hive3MinioDataLake hiveMinioDataLake = (Hive3MinioDataLake)this.closeAfterClass((AutoCloseable)new Hive3MinioDataLake(this.bucketName));
        hiveMinioDataLake.start();
        MinioStorage minioStorage = (MinioStorage)this.closeAfterClass((AutoCloseable)new MinioStorage("test-exchange-spooling-" + TestingNames.randomNameSuffix()));
        minioStorage.start();
        return ((DeltaLakeQueryRunner.Builder)((DeltaLakeQueryRunner.Builder)((DeltaLakeQueryRunner.Builder)((DeltaLakeQueryRunner.Builder)DeltaLakeQueryRunner.builder().setCoordinatorProperties(coordinatorProperties)).addExtraProperties(configProperties)).setAdditionalSetup(runner -> {
            runner.installPlugin((Plugin)new FileSystemExchangePlugin());
            runner.loadExchangeManager("filesystem", MinioStorage.getExchangeManagerProperties((MinioStorage)minioStorage));
        })).addMetastoreProperties(hiveMinioDataLake.getHiveHadoop()).addS3Properties(hiveMinioDataLake.getMinio(), this.bucketName).addDeltaProperty("delta.enable-non-concurrent-writes", "true").setAdditionalModule(failureInjectionModule)).setInitialTables(requiredTpchTables).build();
    }

    protected boolean areWriteRetriesSupported() {
        return true;
    }

    @Test
    protected void testDelete() {
        Optional<String> setupQuery = Optional.of("CREATE TABLE <table> AS SELECT * FROM orders");
        Optional<String> cleanupQuery = Optional.of("DROP TABLE <table>");
        String deleteQuery = "DELETE FROM <table> WHERE orderkey = 1";
        if (this.getRetryPolicy() == RetryPolicy.TASK) {
            this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseDeltaFailureRecoveryTest.boundaryCoordinatorStage()).finishesSuccessfully();
        } else {
            this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseDeltaFailureRecoveryTest.boundaryCoordinatorStage()).failsAlways(failure -> failure.hasMessageContaining("This error is injected by the failure injection service"));
        }
        if (this.getRetryPolicy() == RetryPolicy.TASK) {
            this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseDeltaFailureRecoveryTest.rootStage()).finishesSuccessfully();
        } else {
            this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseDeltaFailureRecoveryTest.rootStage()).failsAlways(failure -> failure.hasMessageContaining("This error is injected by the failure injection service"));
        }
        this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseDeltaFailureRecoveryTest.leafStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).finishesSuccessfully();
        this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseDeltaFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).finishesSuccessfully();
        this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseDeltaFailureRecoveryTest.intermediateDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service"));
        this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_FAILURE).at(BaseDeltaFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Error 500 Internal Server Error|Error closing remote buffer, expected 204 got 500")).finishesSuccessfully();
        this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_TIMEOUT).at(BaseDeltaFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("Encountered too many errors talking to a worker node")).finishesSuccessfully();
        if (this.getRetryPolicy() == RetryPolicy.QUERY) {
            this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_FAILURE).at(BaseDeltaFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Error 500 Internal Server Error|Error closing remote buffer, expected 204 got 500")).finishesSuccessfully();
            this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_TIMEOUT).at(BaseDeltaFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Encountered too many errors talking to a worker node|Error closing remote buffer")).finishesSuccessfully();
        }
    }

    @Test
    protected void testUpdate() {
        Optional<String> setupQuery = Optional.of("CREATE TABLE <table> AS SELECT * FROM orders");
        Optional<String> cleanupQuery = Optional.of("DROP TABLE <table>");
        String updateQuery = "UPDATE <table> SET shippriority = 101 WHERE custkey = 1";
        if (this.getRetryPolicy() == RetryPolicy.TASK) {
            this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseDeltaFailureRecoveryTest.boundaryCoordinatorStage()).finishesSuccessfully();
        } else {
            this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseDeltaFailureRecoveryTest.boundaryCoordinatorStage()).failsAlways(failure -> failure.hasMessageContaining("This error is injected by the failure injection service"));
        }
        if (this.getRetryPolicy() == RetryPolicy.TASK) {
            this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseDeltaFailureRecoveryTest.rootStage()).finishesSuccessfully().cleansUpTemporaryTables();
        } else {
            this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseDeltaFailureRecoveryTest.rootStage()).failsAlways(failure -> failure.hasMessageContaining("This error is injected by the failure injection service"));
        }
        this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseDeltaFailureRecoveryTest.leafStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).finishesSuccessfully();
        this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseDeltaFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).finishesSuccessfully();
        this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseDeltaFailureRecoveryTest.intermediateDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service"));
        this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_FAILURE).at(BaseDeltaFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Error 500 Internal Server Error|Error closing remote buffer, expected 204 got 500")).finishesSuccessfully();
        this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_TIMEOUT).at(BaseDeltaFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("Encountered too many errors talking to a worker node")).finishesSuccessfully();
        if (this.getRetryPolicy() == RetryPolicy.QUERY) {
            this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_FAILURE).at(BaseDeltaFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Error 500 Internal Server Error|Error closing remote buffer, expected 204 got 500")).finishesSuccessfully();
            this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_TIMEOUT).at(BaseDeltaFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Encountered too many errors talking to a worker node|Error closing remote buffer")).finishesSuccessfully();
        }
    }

    @Test
    protected void testRefreshMaterializedView() {
        Assertions.assertThatThrownBy(() -> super.testRefreshMaterializedView()).hasMessageContaining("This connector does not support creating materialized views");
    }

    @Test
    protected void testCreatePartitionedTable() {
        this.testTableModification(Optional.empty(), "CREATE TABLE <table> WITH (partitioned_by = ARRAY['p']) AS SELECT *, 'partition1' p FROM orders", Optional.of("DROP TABLE <table>"));
    }

    @Test
    protected void testInsertIntoNewPartition() {
        this.testTableModification(Optional.of("CREATE TABLE <table> WITH (partitioned_by = ARRAY['p']) AS SELECT *, 'partition1' p FROM orders"), "INSERT INTO <table> SELECT *, 'partition2' p FROM orders", Optional.of("DROP TABLE <table>"));
    }

    @Test
    protected void testInsertIntoExistingPartition() {
        this.testTableModification(Optional.of("CREATE TABLE <table> WITH (partitioned_by = ARRAY['p']) AS SELECT *, 'partition1' p FROM orders"), "INSERT INTO <table> SELECT *, 'partition1' p FROM orders", Optional.of("DROP TABLE <table>"));
    }
}

