/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.deltalake.BaseDeltaLakeConnectorSmokeTest;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.testing.QueryRunner;
import java.util.List;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class BaseDeltaLakeAwsConnectorSmokeTest
extends BaseDeltaLakeConnectorSmokeTest {
    protected Hive3MinioDataLake hiveMinioDataLake;

    @Override
    protected HiveHadoop createHiveHadoop() {
        this.hiveMinioDataLake = (Hive3MinioDataLake)this.closeAfterClass((AutoCloseable)new Hive3MinioDataLake(this.bucketName));
        this.hiveMinioDataLake.start();
        return this.hiveMinioDataLake.getHiveHadoop();
    }

    @Override
    @AfterAll
    public void cleanUp() {
        this.hiveMinioDataLake = null;
        super.cleanUp();
    }

    @Override
    protected void registerTableFromResources(String table, String resourcePath, QueryRunner queryRunner) {
        this.hiveMinioDataLake.copyResources(resourcePath, table);
        queryRunner.execute(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", table, this.getLocationForTable(this.bucketName, table)));
    }

    @Override
    protected String getLocationForTable(String bucketName, String tableName) {
        return String.format("s3://%s/%s", bucketName, tableName);
    }

    @Override
    protected List<String> getTableFiles(String tableName) {
        return (List)this.hiveMinioDataLake.listFiles(tableName).stream().map(path -> String.format("s3://%s/%s", this.bucketName, path)).collect(ImmutableList.toImmutableList());
    }

    @Override
    protected List<String> listFiles(String directory) {
        return (List)this.hiveMinioDataLake.listFiles(directory).stream().map(path -> String.format("s3://%s/%s", this.bucketName, path)).collect(ImmutableList.toImmutableList());
    }

    @Override
    protected void deleteFile(String filePath) {
        String key = filePath.substring(this.bucketUrl().length());
        this.hiveMinioDataLake.getMinioClient().removeObject(this.bucketName, key);
    }

    @Override
    protected String bucketUrl() {
        return String.format("s3://%s/", this.bucketName);
    }
}

