/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import io.airlift.testing.Closeables;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.tpch.TpchTable;
import java.util.Objects;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public abstract class BaseDeltaLakeCompatibility
extends AbstractTestQueryFramework {
    protected final String bucketName = "compatibility-test-queries-" + TestingNames.randomNameSuffix();
    protected final String resourcePath;
    protected Hive3MinioDataLake hiveMinioDataLake;

    public BaseDeltaLakeCompatibility(String resourcePath) {
        this.resourcePath = Objects.requireNonNull(resourcePath);
    }

    protected QueryRunner createQueryRunner() throws Exception {
        this.hiveMinioDataLake = (Hive3MinioDataLake)this.closeAfterClass((AutoCloseable)new Hive3MinioDataLake(this.bucketName));
        this.hiveMinioDataLake.start();
        DistributedQueryRunner queryRunner = DeltaLakeQueryRunner.builder().addMetastoreProperties(this.hiveMinioDataLake.getHiveHadoop()).addS3Properties(this.hiveMinioDataLake.getMinio(), this.bucketName).addDeltaProperty("delta.enable-non-concurrent-writes", "true").addDeltaProperty("delta.register-table-procedure.enabled", "true").build();
        try {
            String schemaName = (String)queryRunner.getDefaultSession().getSchema().orElseThrow();
            TpchTable.getTables().forEach(arg_0 -> this.lambda$createQueryRunner$0(schemaName, (QueryRunner)queryRunner, arg_0));
            return queryRunner;
        }
        catch (Exception e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
    }

    @Test
    public void testSelectAll() {
        for (TpchTable table : TpchTable.getTables()) {
            String tableName = table.getTableName();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).skippingTypesCheck().matches("SELECT * FROM tpch.tiny." + tableName);
        }
    }

    private /* synthetic */ void lambda$createQueryRunner$0(String schemaName, QueryRunner queryRunner, TpchTable table) {
        String tableName = table.getTableName();
        this.hiveMinioDataLake.copyResources(this.resourcePath + tableName, schemaName + "/" + tableName);
        queryRunner.execute(String.format("CALL system.register_table(CURRENT_SCHEMA, '%2$s', 's3://%3$s/%1$s/%2$s')", schemaName, tableName, this.bucketName));
    }
}

