/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.execution.QueryManager;
import io.trino.metastore.HiveMetastore;
import io.trino.operator.OperatorStats;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.deltalake.ResourceTable;
import io.trino.plugin.deltalake.TestingDeltaLakeUtils;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.BaseConnectorSmokeTest;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.Assert;
import io.trino.testing.sql.TestTable;
import io.trino.tpch.TpchTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class BaseDeltaLakeConnectorSmokeTest
extends BaseConnectorSmokeTest {
    protected static final String SCHEMA = "smoke_test";
    private static final List<TpchTable<?>> REQUIRED_TPCH_TABLES = ImmutableSet.builder().addAll((Iterable)BaseConnectorSmokeTest.REQUIRED_TPCH_TABLES).add((Object[])new TpchTable[]{TpchTable.CUSTOMER, TpchTable.LINE_ITEM, TpchTable.ORDERS}).build().asList();
    private static final List<ResourceTable> NON_TPCH_TABLES = ImmutableList.of((Object)new ResourceTable("invariants", "deltalake/invariants"), (Object)new ResourceTable("person", "databricks73/person"), (Object)new ResourceTable("foo", "databricks73/foo"), (Object)new ResourceTable("bar", "databricks73/bar"), (Object)new ResourceTable("old_dates", "databricks73/old_dates"), (Object)new ResourceTable("old_timestamps", "databricks73/old_timestamps"), (Object)new ResourceTable("nested_timestamps", "databricks73/nested_timestamps"), (Object)new ResourceTable("nested_timestamps_parquet_stats", "databricks73/nested_timestamps_parquet_stats"), (Object)new ResourceTable("json_stats_on_row_type", "databricks104/json_stats_on_row_type"), (Object)new ResourceTable("parquet_stats_missing", "databricks73/parquet_stats_missing"), (Object)new ResourceTable("uppercase_columns", "databricks73/uppercase_columns"), (Object)new ResourceTable("default_partitions", "databricks73/default_partitions"), (Object[])new ResourceTable[]{new ResourceTable("insert_nonlowercase_columns", "databricks73/insert_nonlowercase_columns"), new ResourceTable("insert_nested_nonlowercase_columns", "databricks73/insert_nested_nonlowercase_columns"), new ResourceTable("insert_nonlowercase_columns_partitioned", "databricks73/insert_nonlowercase_columns_partitioned")});
    private static final int TEST_METADATA_CACHE_TTL_SECONDS = 15;
    protected final String bucketName = "test-delta-lake-integration-smoke-test-" + TestingNames.randomNameSuffix();
    protected HiveHadoop hiveHadoop;
    private HiveMetastore metastore;
    private TransactionLogAccess transactionLogAccess;

    protected void environmentSetup() {
    }

    protected abstract HiveHadoop createHiveHadoop() throws Exception;

    protected abstract Map<String, String> hiveStorageConfiguration();

    protected abstract Map<String, String> deltaStorageConfiguration();

    protected abstract void registerTableFromResources(String var1, String var2, QueryRunner var3);

    protected abstract String getLocationForTable(String var1, String var2);

    protected abstract List<String> getTableFiles(String var1);

    protected abstract List<String> listFiles(String var1);

    protected abstract void deleteFile(String var1);

    protected QueryRunner createQueryRunner() throws Exception {
        this.environmentSetup();
        this.hiveHadoop = (HiveHadoop)this.closeAfterClass((AutoCloseable)this.createHiveHadoop());
        BaseDeltaLakeConnectorSmokeTest baseDeltaLakeConnectorSmokeTest = this;
        this.metastore = new BridgingHiveMetastore(TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(this.hiveHadoop.getHiveMetastoreEndpoint()).build(x$0 -> baseDeltaLakeConnectorSmokeTest.closeAfterClass((AutoCloseable)x$0)));
        QueryRunner queryRunner = this.createDeltaLakeQueryRunner();
        try {
            this.transactionLogAccess = TestingDeltaLakeUtils.getConnectorService(queryRunner, TransactionLogAccess.class);
            REQUIRED_TPCH_TABLES.forEach(table -> queryRunner.execute(String.format("CREATE TABLE %s WITH (location = '%s') AS SELECT * FROM tpch.tiny.%1$s", table.getTableName(), this.getLocationForTable(this.bucketName, table.getTableName()))));
            NON_TPCH_TABLES.forEach(table -> this.registerTableFromResources(table.tableName(), table.resourcePath(), queryRunner));
            queryRunner.installPlugin((Plugin)new TestingHivePlugin(queryRunner.getCoordinator().getBaseDataDir().resolve("hive_data")));
            queryRunner.createCatalog("hive", "hive", (Map)ImmutableMap.builder().put((Object)"hive.metastore", (Object)"thrift").put((Object)"hive.metastore.uri", (Object)this.hiveHadoop.getHiveMetastoreEndpoint().toString()).putAll(this.hiveStorageConfiguration()).buildOrThrow());
            return queryRunner;
        }
        catch (Throwable e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
    }

    private QueryRunner createDeltaLakeQueryRunner() throws Exception {
        return DeltaLakeQueryRunner.builder(SCHEMA).setDeltaProperties((Map<String, String>)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)this.hiveHadoop.getHiveMetastoreEndpoint().toString()).put((Object)"delta.metadata.cache-ttl", (Object)"15s").put((Object)"delta.metadata.live-files.cache-ttl", (Object)"15s").put((Object)"hive.metastore-cache-ttl", (Object)"15s").put((Object)"delta.register-table-procedure.enabled", (Object)"true").put((Object)"hive.metastore.thrift.client.read-timeout", (Object)"1m").putAll(this.deltaStorageConfiguration()).buildOrThrow()).setSchemaLocation(this.getLocationForTable(this.bucketName, SCHEMA)).build();
    }

    @AfterAll
    public void cleanUp() {
        this.hiveHadoop = null;
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    @Test
    public void testDropSchemaExternalFiles() {
        String schemaName = "externalFileSchema";
        String schemaDir = this.bucketUrl() + "drop-schema-with-external-files/";
        String subDir = schemaDir + "subdir/";
        String externalFile = subDir + "external-file";
        this.hiveHadoop.executeInContainerFailOnError(new String[]{"hdfs", "dfs", "-mkdir", "-p", subDir});
        this.hiveHadoop.executeInContainerFailOnError(new String[]{"hdfs", "dfs", "-touchz", externalFile});
        this.assertUpdate(String.format("CREATE SCHEMA %s WITH (location = '%s')", schemaName, schemaDir));
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.hiveHadoop.executeInContainer(new String[]{"hdfs", "dfs", "-test", "-e", externalFile}).getExitCode()).as("external file exists after creating schema", new Object[0])).isEqualTo(0);
        this.assertUpdate("DROP SCHEMA " + schemaName);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.hiveHadoop.executeInContainer(new String[]{"hdfs", "dfs", "-test", "-e", externalFile}).getExitCode()).as("external file exists after dropping schema", new Object[0])).isEqualTo(0);
        this.hiveHadoop.executeInContainerFailOnError(new String[]{"hdfs", "dfs", "-rm", "-r", subDir});
        this.assertUpdate(String.format("CREATE SCHEMA %s WITH (location = '%s')", schemaName, schemaDir));
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.hiveHadoop.executeInContainer(new String[]{"hdfs", "dfs", "-test", "-d", schemaDir}).getExitCode()).as("schema directory exists after creating schema", new Object[0])).isEqualTo(0);
        this.assertUpdate("DROP SCHEMA " + schemaName);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.hiveHadoop.executeInContainer(new String[]{"hdfs", "dfs", "-test", "-e", externalFile}).getExitCode()).as("schema directory deleted after dropping schema without external file", new Object[0])).isEqualTo(1);
    }

    protected abstract String bucketUrl();

    @Test
    public void testCreateTableInNonexistentSchemaFails() {
        String tableName = "test_create_table_in_nonexistent_schema_" + TestingNames.randomNameSuffix();
        String location = this.getLocationForTable(this.bucketName, tableName);
        this.assertQueryFails("CREATE TABLE doesnotexist." + tableName + " (a int, b int) WITH (location = '" + location + "')", "Schema doesnotexist not found");
        Assertions.assertThat(this.getTableFiles(tableName)).isEmpty();
        this.assertQueryFails("CREATE TABLE doesnotexist." + tableName + " (a, b) WITH (location = '" + location + "') AS VALUES (1, 2), (3, 4)", "Schema doesnotexist not found");
        Assertions.assertThat(this.getTableFiles(tableName)).isEmpty();
    }

    @Test
    public void testCreatePartitionedTable() {
        String tableName = "test_create_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a int, b VARCHAR, c TIMESTAMP WITH TIME ZONE) WITH (location = '" + this.getLocationForTable(this.bucketName, tableName) + "', partitioned_by = ARRAY['b'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 'a', TIMESTAMP '2020-01-01 01:22:34.000 UTC')", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, 'b', TIMESTAMP '2021-01-01 01:22:34.000 UTC')", 1L);
        this.assertQuery("SELECT a, b, CAST(c AS VARCHAR) FROM " + tableName, "VALUES (1, 'a', '2020-01-01 01:22:34.000 UTC'), (2, 'b', '2021-01-01 01:22:34.000 UTC')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPathUriDecoding() {
        String tableName = "test_uri_table_" + TestingNames.randomNameSuffix();
        this.registerTableFromResources(tableName, "deltalake/uri", this.getQueryRunner());
        this.assertQuery("SELECT * FROM " + tableName, "VALUES ('a=equal', 1), ('a:colon', 2), ('a+plus', 3), ('a space', 4), ('a%percent', 5), ('a/forwardslash', 6)");
        String firstFilePath = (String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE y = 1");
        this.assertQuery("SELECT * FROM " + tableName + " WHERE \"$path\" = '" + firstFilePath + "'", "VALUES ('a=equal', 1)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPathUriEncoding() {
        String tableName = "test_uri_table_encoding_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (part varchar, data integer) WITH (location = '" + this.getLocationForTable(this.bucketName, tableName) + "', partitioned_by = ARRAY['part'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('a=equal', 1), ('a:colon', 2), ('a+plus', 3), ('a space', 4), ('a%percent', 5), ('a/forwardslash', 6)", 6L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES ('a=equal', 1), ('a:colon', 2), ('a+plus', 3), ('a space', 4), ('a%percent', 5), ('a/forwardslash', 6)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTablePartitionValidation() {
        String tableName = "test_create_table_partition_validation_" + TestingNames.randomNameSuffix();
        this.assertQueryFails("CREATE TABLE " + tableName + " (a int, b VARCHAR, c TIMESTAMP WITH TIME ZONE) WITH (location = '" + this.getLocationForTable(this.bucketName, tableName) + "', partitioned_by = ARRAY['a', 'd', 'e'])", "Table property 'partitioned_by' contained column names which do not exist: \\[d, e]");
        this.assertQueryFails("CREATE TABLE " + tableName + " (a, b, c) WITH (location = '" + this.getLocationForTable(this.bucketName, tableName) + "', partitioned_by = ARRAY['a', 'd', 'e']) AS VALUES (1, 'one', TIMESTAMP '2020-02-03 01:02:03.123 UTC')", "Table property 'partitioned_by' contained column names which do not exist: \\[d, e]");
    }

    @Test
    public void testCreateTableThatAlreadyExists() {
        this.assertQueryFails("CREATE TABLE person (a int, b int) WITH (location = '" + this.getLocationForTable(this.bucketName, "different_person") + "')", String.format(".*Table 'delta.%s.person' already exists.*", SCHEMA));
    }

    @Test
    public void testCreateTablePartitionOrdering() {
        String tableName = "test_create_table_partition_ordering_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (location = '" + this.getLocationForTable(this.bucketName, tableName) + "', partitioned_by = ARRAY['nationkey', 'regionkey']) AS SELECT regionkey, nationkey, name, comment FROM nation", 25L);
        this.assertQuery("SELECT regionkey, nationkey, name, comment FROM " + tableName, "SELECT regionkey, nationkey, name, comment FROM nation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOptimizeRewritesTable() {
        String tableName = "test_optimize_rewrites_table_" + TestingNames.randomNameSuffix();
        String tableLocation = this.getLocationForTable(this.bucketName, tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " (key integer, value varchar) WITH (location = '" + tableLocation + "')");
        try {
            int workerCount = this.getQueryRunner().getNodeCount();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 'one')", 1L);
            for (int i = 0; i < 3; ++i) {
                Set<String> initialFiles = this.getActiveFiles(tableName);
                this.computeActual("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
                Set<String> filesAfterOptimize = this.getActiveFiles(tableName);
                ((AbstractCollectionAssert)Assertions.assertThat(filesAfterOptimize).hasSizeBetween(1, workerCount)).containsExactlyElementsOf(initialFiles);
            }
            this.assertQuery("SELECT * FROM " + tableName, "VALUES(1, 'one')");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOptimizeTableWithSmallFileAndLargeFiles() {
        String tableName = "test_optimize_rewrites_table_with_small_and_large_file" + TestingNames.randomNameSuffix();
        String tableLocation = this.getLocationForTable(this.bucketName, tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " (key integer, value varchar) WITH (location = '" + tableLocation + "')");
        try {
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 'one')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, '" + "two".repeat(1000) + "')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, '" + "three".repeat(1000) + "')", 1L);
            Set<String> initialFiles = this.getActiveFiles(tableName);
            Assertions.assertThat(initialFiles).hasSize(3);
            for (int i = 0; i < 3; ++i) {
                this.computeActual("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE (file_size_threshold => '1kB')");
                Set<String> filesAfterOptimize = this.getActiveFiles(tableName);
                Assertions.assertThat(filesAfterOptimize).containsExactlyInAnyOrderElementsOf(initialFiles);
            }
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'one'), (2, '%s'), (3, '%s')".formatted("two".repeat(1000), "three".repeat(1000)));
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOptimizeRewritesPartitionedTable() {
        String tableName = "test_optimize_rewrites_partitioned_table_" + TestingNames.randomNameSuffix();
        String tableLocation = this.getLocationForTable(this.bucketName, tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " (key integer, value varchar) WITH (location = '" + tableLocation + "', partitioned_by = ARRAY['key'])");
        try {
            int workerCount = this.getQueryRunner().getNodeCount();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 'one')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, 'two')", 1L);
            for (int i = 0; i < 3; ++i) {
                Set<String> initialFiles = this.getActiveFiles(tableName);
                this.computeActual("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
                Set<String> filesAfterOptimize = this.getActiveFiles(tableName);
                ((AbstractCollectionAssert)Assertions.assertThat(filesAfterOptimize).hasSizeBetween(1, workerCount)).containsExactlyInAnyOrderElementsOf(initialFiles);
            }
            this.assertQuery("SELECT * FROM " + tableName, "VALUES(1, 'one'), (2, 'two')");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((Object)this.computeScalar("SHOW CREATE TABLE person")).isEqualTo((Object)String.format("CREATE TABLE delta.%s.person (\n   name varchar,\n   age integer,\n   married boolean,\n   phones array(ROW(number varchar, label varchar)),\n   address ROW(street varchar, city varchar, state varchar, zip varchar),\n   income double,\n   gender varchar\n)\nWITH (\n   location = '%s',\n   partitioned_by = ARRAY['age']\n)", SCHEMA, this.getLocationForTable(this.bucketName, "person")));
    }

    @Test
    public void testInputDataSize() {
        QueryRunner queryRunner = this.getQueryRunner();
        String hiveTableName = "foo_hive";
        queryRunner.execute(String.format("CREATE TABLE hive.%s.%s (foo_id bigint, bar_id bigint, data varchar) WITH (format = 'PARQUET', external_location = '%s')", SCHEMA, hiveTableName, this.getLocationForTable(this.bucketName, "foo")));
        QueryRunner.MaterializedResultWithPlan deltaResult = queryRunner.executeWithPlan(this.broadcastJoinDistribution(true), "SELECT * FROM foo");
        Assertions.assertThat((int)deltaResult.result().getRowCount()).isEqualTo(2);
        QueryRunner.MaterializedResultWithPlan hiveResult = queryRunner.executeWithPlan(this.broadcastJoinDistribution(true), String.format("SELECT * FROM %s.%s.%s", "hive", SCHEMA, hiveTableName));
        Assertions.assertThat((int)hiveResult.result().getRowCount()).isEqualTo(2);
        QueryManager queryManager = queryRunner.getCoordinator().getQueryManager();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)queryManager.getFullQueryInfo(deltaResult.queryId()).getQueryStats().getProcessedInputDataSize()).as("delta processed input data size", new Object[0])).isGreaterThan((Comparable)DataSize.ofBytes((long)0L)).isEqualTo((Object)queryManager.getFullQueryInfo(hiveResult.queryId()).getQueryStats().getProcessedInputDataSize());
        queryRunner.execute(String.format("DROP TABLE hive.%s.%s", SCHEMA, hiveTableName));
    }

    @Test
    public void testHiddenColumns() {
        this.assertQuery("SELECT DISTINCT \"$path\" FROM foo", String.format("VALUES '%s/part-00000-6f261ad3-ab3a-45e1-9047-01f9491f5a8c-c000.snappy.parquet', '%1$s/part-00000-f61316e9-b279-4efa-94c8-5ababdacf768-c000.snappy.parquet'", this.getLocationForTable(this.bucketName, "foo")));
        this.assertQuery("SELECT DISTINCT \"$file_size\" FROM foo", "VALUES 935");
        this.assertQuery("SELECT DISTINCT CAST(\"$file_modified_time\" AS varchar) FROM foo", "VALUES '2020-03-26 02:41:24.000 UTC', '2020-03-26 02:41:43.000 UTC'");
    }

    @Test
    public void testHiveViewsCannotBeAccessed() {
        String schemaName = "test_schema" + TestingNames.randomNameSuffix();
        String viewName = "dummy_view";
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        this.hiveHadoop.runOnHive(String.format("CREATE VIEW %s.%s AS SELECT * FROM %s.customer", schemaName, viewName, SCHEMA));
        Assertions.assertThat((Object)this.computeScalar(String.format("SHOW TABLES FROM %s LIKE '%s'", schemaName, viewName))).isEqualTo((Object)viewName);
        Assertions.assertThatThrownBy(() -> this.computeActual("DESCRIBE " + schemaName + "." + viewName)).hasMessageContaining(String.format("%s.%s is not a Delta Lake table", schemaName, viewName));
        this.hiveHadoop.runOnHive("DROP DATABASE " + schemaName + " CASCADE");
    }

    @Test
    public void testDropDatabricksTable() {
        this.testDropTable("testdrop_databricks", "io/trino/plugin/deltalake/testing/resources/databricks73/nation");
    }

    @Test
    public void testDropOssDataLakeTable() {
        this.testDropTable("testdrop_datalake", "io/trino/plugin/deltalake/testing/resources/ossdeltalake/nation");
    }

    private void testDropTable(String tableName, String resourcePath) {
        this.registerTableFromResources(tableName, resourcePath, this.getQueryRunner());
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isTrue();
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        Assertions.assertThat(this.getTableFiles(tableName)).hasSizeGreaterThan(1);
    }

    @Test
    public void testDropAndRecreateTable() {
        String tableName = "testDropAndRecreate_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableName, this.getLocationForTable(this.bucketName, "nation")));
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableName, this.getLocationForTable(this.bucketName, "customer")));
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM customer");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDropColumnNotSupported() {
        this.registerTableFromResources("testdropcolumn", "io/trino/plugin/deltalake/testing/resources/databricks73/nation", this.getQueryRunner());
        this.assertQueryFails("ALTER TABLE testdropcolumn DROP COLUMN comment", "Cannot drop column from table using column mapping mode NONE");
    }

    @Test
    public void testCreatePartitionedTableAs() {
        String tableName = "test_create_partitioned_table_as_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE " + tableName + " WITH (location = '%s', partitioned_by = ARRAY['regionkey']) AS SELECT name, regionkey, comment from nation", this.getLocationForTable(this.bucketName, tableName)), 25L);
        Assertions.assertThat((Object)this.computeScalar("SHOW CREATE TABLE " + tableName)).isEqualTo((Object)String.format("CREATE TABLE %s.%s.%s (\n   name varchar,\n   regionkey bigint,\n   comment varchar\n)\nWITH (\n   location = '%s',\n   partitioned_by = ARRAY['regionkey']\n)", "delta", SCHEMA, tableName, this.getLocationForTable(this.bucketName, tableName)));
        this.assertQuery("SELECT * FROM " + tableName, "SELECT name, regionkey, comment FROM nation");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreatePartitionedDefaultPartitionKeys() {
        String tableName = "test_create_partitioned_table_default_as_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE " + tableName + "(number_partition, string_partition, a_value) WITH (location = '%s', partitioned_by = ARRAY['number_partition', 'string_partition']) AS VALUES (NULL, 'partition_a', 'jarmuz'), (1, NULL, 'brukselka'), (NULL, NULL, 'kalafior')", this.getLocationForTable(this.bucketName, tableName), tableName), 3L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (NULL, 'partition_a', 'jarmuz'), (1, NULL, 'brukselka'), (NULL, NULL, 'kalafior')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTablePartitionedByDate() {
        String tableName = "test_create_table_partitioned_by_date_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (i, d) WITH (location = '%s', partitioned_by = ARRAY['d']) AS VALUES (1, DATE '2020-01-01'), (2, DATE '1700-01-01')", tableName, this.getLocationForTable(this.bucketName, tableName)), 2L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, DATE '2020-01-01'), (2, DATE '1700-01-01')");
    }

    @Test
    public void testCreateTableAsStatistics() {
        String tableName = "test_ctats_stats_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (location = '" + this.getLocationForTable(this.bucketName, tableName) + "') AS SELECT * FROM tpch.sf1.nation", 25L);
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('nationkey', null, 25.0, 0.0, null, 0, 24),('regionkey', null, 5.0, 0.0, null, 0, 4),('comment', 1857.0, 25.0, 0.0, null, null, null),('name', 177.0, 25.0, 0.0, null, null, null),(null, null, null, null, 25.0, null, null)");
    }

    @Test
    public void testCleanupForFailedCreateTableAs() {
        String controlTableName = "test_cleanup_for_failed_create_table_as_control_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE " + controlTableName + " WITH (location = '%s') AS SELECT nationkey from tpch.sf1.nation", this.getLocationForTable(this.bucketName, controlTableName)), 25L);
        Assertions.assertThat(this.getTableFiles(controlTableName)).isNotEmpty();
        String tableName = "test_cleanup_for_failed_create_table_as_" + TestingNames.randomNameSuffix();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("CREATE TABLE " + tableName + " WITH (location = '%s') AS SELECT nationkey from tpch.sf1.nation UNION ALL SELECT 10/(max(orderkey)-max(orderkey)) from tpch.sf10.orders", this.getLocationForTable(this.bucketName, tableName))))).failure().hasMessageContaining("Division by zero");
        Assert.assertEventually((Duration)new Duration(5.0, TimeUnit.SECONDS), () -> Assertions.assertThat(this.getTableFiles(tableName)).isEmpty());
    }

    @Test
    public void testCleanupForFailedPartitionedCreateTableAs() {
        String tableName = "test_cleanup_for_failed_partitioned_create_table_as_" + TestingNames.randomNameSuffix();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("CREATE TABLE " + tableName + "(a, b) WITH (location = '%s', partitioned_by = ARRAY['b']) AS SELECT nationkey, regionkey from tpch.sf1.nation UNION ALL SELECT 10/(max(orderkey)-max(orderkey)), orderkey %% 5 from tpch.sf10.orders group by orderkey %% 5", this.getLocationForTable(this.bucketName, tableName))))).failure().hasMessageContaining("Division by zero");
        Assert.assertEventually((Duration)new Duration(5.0, TimeUnit.SECONDS), () -> Assertions.assertThat(this.getTableFiles(tableName)).isEmpty());
    }

    @Test
    public void testCreateTableAsExistingLocation() {
        String tableName = "test_create_table_as_existing_location_" + TestingNames.randomNameSuffix();
        String createTableStatement = String.format("CREATE TABLE " + tableName + " WITH (location = '%s') AS SELECT name from nation", this.getLocationForTable(this.bucketName, tableName));
        ((ListAssert)Assertions.assertThat(this.getTableFiles(tableName)).as("table files", new Object[0])).isEmpty();
        this.assertUpdate(createTableStatement, 25L);
        this.assertUpdate("DROP TABLE " + tableName);
        ((ListAssert)Assertions.assertThat(this.getTableFiles(tableName)).as("remaining table files", new Object[0])).isNotEmpty();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(createTableStatement))).failure().hasMessageContaining("Target location cannot contain any files");
    }

    @Test
    public void testCreateSchemaWithLocation() {
        String schemaName = "test_create_schema_with_location_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds(String.format("CREATE SCHEMA %s WITH ( location = '%s' )", schemaName, this.getLocationForTable(this.bucketName, schemaName)));
    }

    @Test
    public void testCreateTableAsWithSchemaLocation() {
        String tableName = "table1_with_curr_schema_loc_" + TestingNames.randomNameSuffix();
        String tableName2 = "table2_with_curr_schema_loc_" + TestingNames.randomNameSuffix();
        String schemaName = "test_schema" + TestingNames.randomNameSuffix();
        String schemaLocation = this.getLocationForTable(this.bucketName, schemaName);
        this.assertUpdate(String.format("CREATE SCHEMA %s WITH ( location = '%s' )", schemaName, schemaLocation));
        this.assertUpdate(String.format("CREATE TABLE %s.%s AS SELECT name FROM nation", schemaName, tableName), "SELECT count(*) FROM nation");
        this.assertUpdate(String.format("CREATE TABLE %s.%s AS SELECT name FROM nation", schemaName, tableName2), "SELECT count(*) FROM nation");
        this.assertQuery(String.format("SELECT * FROM %s.%s", schemaName, tableName), "SELECT name FROM nation");
        this.assertQuery(String.format("SELECT * FROM %s.%s", schemaName, tableName2), "SELECT name FROM nation");
        this.validatePath(schemaLocation, schemaName, tableName);
        this.validatePath(schemaLocation, schemaName, tableName2);
    }

    @Test
    public void testCreateTableWithSchemaLocation() {
        String tableName = "table1_with_curr_schema_loc_" + TestingNames.randomNameSuffix();
        String tableName2 = "table2_with_curr_schema_loc_" + TestingNames.randomNameSuffix();
        String schemaName = "test_schema" + TestingNames.randomNameSuffix();
        String schemaLocation = this.getLocationForTable(this.bucketName, schemaName);
        this.assertUpdate(String.format("CREATE SCHEMA %s WITH ( location = '%s' )", schemaName, schemaLocation));
        this.assertUpdate(String.format("CREATE TABLE %s.%s (name VARCHAR)", schemaName, tableName));
        this.assertUpdate(String.format("CREATE TABLE %s.%s (name VARCHAR)", schemaName, tableName2));
        this.assertUpdate(String.format("INSERT INTO %s.%s SELECT name FROM nation", schemaName, tableName), "SELECT count(*) FROM nation");
        this.assertUpdate(String.format("INSERT INTO %s.%s SELECT name FROM nation", schemaName, tableName2), "SELECT count(*) FROM nation");
        this.assertQuery(String.format("SELECT * FROM %s.%s", schemaName, tableName), "SELECT name FROM nation");
        this.assertQuery(String.format("SELECT * FROM %s.%s", schemaName, tableName2), "SELECT name FROM nation");
        this.validatePath(schemaLocation, schemaName, tableName);
        this.validatePath(schemaLocation, schemaName, tableName2);
    }

    private void validatePath(String schemaLocation, String schemaName, String tableName) {
        List materializedRows = this.getQueryRunner().execute("SELECT DISTINCT regexp_replace(\"$path\", '(.*[/][^/]*)[/][^/]*$', '$1') FROM " + schemaName + "." + tableName).getMaterializedRows();
        Assertions.assertThat((List)materializedRows).hasSize(1);
        Assertions.assertThat((String)((String)((MaterializedRow)materializedRows.get(0)).getField(0))).matches((CharSequence)String.format("%s/%s.*", schemaLocation, tableName));
    }

    @Test
    public void testRenameTable() {
        Assertions.assertThatThrownBy(() -> super.testRenameTable()).hasMessage("Renaming managed tables is not allowed with current metastore configuration").hasStackTraceContaining("SQL: ALTER TABLE test_rename_");
    }

    @Test
    public void testRenameExternalTable() {
        String oldTable = "test_external_table_rename_old_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a bigint, b double) WITH (location = '%s')", oldTable, this.getLocationForTable(this.bucketName, oldTable)));
        this.assertUpdate("INSERT INTO " + oldTable + " VALUES (42, 43)", 1L);
        String oldLocation = (String)this.computeScalar("SELECT \"$path\" FROM " + oldTable);
        String newTable = "test_rename_new_" + TestingNames.randomNameSuffix();
        this.assertUpdate("ALTER TABLE " + oldTable + " RENAME TO " + newTable);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW TABLES LIKE '" + oldTable + "'"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a, b FROM " + newTable))).matches("VALUES (BIGINT '42', DOUBLE '43')");
        Assertions.assertThat((String)((String)this.computeScalar("SELECT \"$path\" FROM " + newTable))).isEqualTo(oldLocation);
        this.assertUpdate("INSERT INTO " + newTable + " (a, b) VALUES (42, -38.5)", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a, b FROM " + newTable))).matches("VALUES (BIGINT '42', DOUBLE '43'), (42, -385e-1)");
        this.assertUpdate("DROP TABLE " + newTable);
    }

    @Test
    public void testRenameTableAcrossSchemas() {
        Assertions.assertThatThrownBy(() -> super.testRenameTableAcrossSchemas()).hasMessage("Renaming managed tables is not allowed with current metastore configuration").hasStackTraceContaining("SQL: ALTER TABLE test_rename_");
    }

    @Test
    public void testRenameExternalTableAcrossSchemas() {
        String oldTable = "test_rename_old_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a bigint, b double) WITH (location = '%s')", oldTable, this.getLocationForTable(this.bucketName, oldTable)));
        this.assertUpdate("INSERT INTO " + oldTable + " VALUES (42, 43)", 1L);
        String oldLocation = (String)this.computeScalar("SELECT \"$path\" FROM " + oldTable);
        String schemaName = "test_schema_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createSchemaSql(schemaName));
        String newTableName = "test_rename_new_" + TestingNames.randomNameSuffix();
        String newTable = schemaName + "." + newTableName;
        this.assertUpdate("ALTER TABLE " + oldTable + " RENAME TO " + newTable);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW TABLES LIKE '" + oldTable + "'"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a, b FROM " + newTable))).matches("VALUES (BIGINT '42', DOUBLE '43')");
        Assertions.assertThat((String)((String)this.computeScalar("SELECT \"$path\" FROM " + newTable))).isEqualTo(oldLocation);
        this.assertUpdate("INSERT INTO " + newTable + " (a, b) VALUES (42, -38.5)", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(a AS bigint), b FROM " + newTable))).matches("VALUES (BIGINT '42', DOUBLE '43'), (42, -385e-1)");
        this.assertUpdate("DROP TABLE " + newTable);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW TABLES LIKE '" + newTable + "'"))).returnsEmptyResult();
        this.assertUpdate("DROP SCHEMA " + schemaName);
    }

    @Test
    public void testOverrideSchemaLocation() {
        String tableName = "test_override_schema_location_" + TestingNames.randomNameSuffix();
        String schemaName = "test_override_schema_location_schema_" + TestingNames.randomNameSuffix();
        String schemaLocation = this.getLocationForTable(this.bucketName, schemaName);
        this.assertUpdate(String.format("CREATE SCHEMA %s WITH ( location = '%s' )", schemaName, schemaLocation));
        String tableLocation = this.getLocationForTable(this.bucketName, "a_different_directory") + "/" + tableName;
        this.assertUpdate(String.format("CREATE TABLE %s.%s WITH (location = '%s') AS SELECT * FROM nation", schemaName, tableName, tableLocation), "SELECT count(*) FROM nation");
        this.assertQuery("SELECT DISTINCT regexp_replace(\"$path\", '(.*[/][^/]*)[/][^/]*$', '$1') FROM " + schemaName + "." + tableName, String.format("VALUES '%s'", tableLocation));
    }

    @Test
    public void testManagedTableFilesCleanedOnDrop() {
        String tableName = "test_managed_table_cleanup_" + TestingNames.randomNameSuffix();
        String schemaName = "test_managed_table_cleanup_" + TestingNames.randomNameSuffix();
        String schemaLocation = this.getLocationForTable(this.bucketName, schemaName);
        this.assertUpdate(String.format("CREATE SCHEMA %s WITH (location = '%s')", schemaName, schemaLocation));
        this.assertUpdate(String.format("CREATE TABLE %s.%s AS SELECT * FROM nation", schemaName, tableName), "SELECT count(*) FROM nation");
        Assertions.assertThat((int)this.getTableFiles(schemaName + "/" + tableName).size()).isGreaterThan(0);
        this.assertUpdate(String.format("DROP TABLE %s.%s", schemaName, tableName));
        Assertions.assertThat(this.getTableFiles(schemaName + "/" + tableName)).isEmpty();
    }

    @Test
    public void testExternalTableFilesRetainedOnDrop() {
        String tableName = "test_external_table_files_retained_" + TestingNames.randomNameSuffix();
        String schemaName = "test_external_table_files_retained_" + TestingNames.randomNameSuffix();
        String tableLocation = this.getLocationForTable(this.bucketName, tableName);
        String schemaLocation = this.getLocationForTable(this.bucketName, schemaName);
        this.assertUpdate(String.format("CREATE SCHEMA %s WITH (location = '%s')", schemaName, schemaLocation));
        this.assertUpdate(String.format("CREATE TABLE %s.%s WITH (location = '%s') AS SELECT * FROM nation", schemaName, tableName, tableLocation), "SELECT count(*) FROM nation");
        int fileCount = this.getTableFiles(tableName).size();
        this.assertUpdate(String.format("DROP TABLE %s.%s", schemaName, tableName));
        Assertions.assertThat(this.getTableFiles(tableName)).hasSize(fileCount);
    }

    @Test
    public void testTimestampWithTimeZoneMillis() {
        String tableName = "test_timestamp_with_time_zone_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE " + tableName + " (ts_tz) WITH (location = '%s') AS VALUES timestamp '2012-10-31 01:00:00.123 America/New_York', timestamp '2012-10-31 01:00:00.123 America/Los_Angeles', timestamp '2012-10-31 01:00:00.123 UTC'", this.getLocationForTable(this.bucketName, tableName)), 3L);
        this.assertQuery("SELECT CAST(ts_tz AS VARCHAR) FROM " + tableName, "VALUES '2012-10-31 05:00:00.123 UTC', '2012-10-31 08:00:00.123 UTC', '2012-10-31 01:00:00.123 UTC'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testTimestampWithTimeZoneMicro() {
        String tableName = "test_timestamp_with_time_zone_micro_" + TestingNames.randomNameSuffix();
        this.assertQueryFails(String.format("CREATE TABLE " + tableName + " (ts_tz) WITH (location = '%s') AS VALUES timestamp '2012-10-31 01:00:00.123456 America/New_York', timestamp '2012-10-31 01:00:00.123456 America/Los_Angeles'", this.getLocationForTable(this.bucketName, tableName)), "Unsupported type:.*");
    }

    @Test
    public void testTimestampWithTimeZoneInArrayType() {
        String tableName = "test_timestamp_with_time_zone_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id int, data array(timestamp with time zone)) WITH (location = '" + this.getLocationForTable(this.bucketName, tableName) + "') ");
        String values = "(1, ARRAY[timestamp '2012-01-01 01:02:03.123 UTC']),\n(2, ARRAY[NULL]),\n(3, NULL)\n";
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + values, 3L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES " + values);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + tableName + " WHERE data = ARRAY[timestamp '2012-01-01 01:02:03.123 UTC']"))).matches("VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testTimestampWithTimeZoneInMapType() {
        String tableName = "test_timestamp_with_time_zone_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id int, data map(timestamp with time zone, timestamp with time zone)) WITH (location = '" + this.getLocationForTable(this.bucketName, tableName) + "') ");
        String values = "(1, MAP(ARRAY[timestamp '2012-01-01 01:02:03.123 UTC'], ARRAY[timestamp '2012-02-01 01:02:03.123 UTC'])),\n(2, MAP(ARRAY[timestamp '2023-12-31 03:02:01.321 UTC'], ARRAY[NULL])),\n(3, MAP(NULL, NULL)),\n(4, NULL)\n";
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + values, 4L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES " + values);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + tableName + " WHERE data = MAP(ARRAY[timestamp '2012-01-01 01:02:03.123 UTC'], ARRAY[timestamp '2012-02-01 01:02:03.123 UTC'])"))).matches("VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testTimestampWithTimeZoneInRowType() {
        String tableName = "test_timestamp_with_time_zone_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id int, data row(ts_tz timestamp with time zone)) WITH (location = '" + this.getLocationForTable(this.bucketName, tableName) + "') ");
        String values = "(1, CAST(ROW(timestamp '2012-01-01 01:02:03.123 UTC') AS ROW(ts_tz timestamp with time zone))),\n(2, CAST(ROW(NULL) AS ROW(ts_tz timestamp with time zone))),\n(3, CAST(NULL AS ROW(ts_tz timestamp with time zone)))\n";
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + values, 3L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES " + values);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + tableName + " WHERE data = ROW(timestamp '2012-01-01 01:02:03.123 UTC')"))).matches("VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testTimestampWithTimeZoneInNestedField() {
        String tableName = "test_timestamp_with_time_zone_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id int, parent row(child row(grandchild timestamp with time zone))) WITH (location = '" + this.getLocationForTable(this.bucketName, tableName) + "') ");
        String values = "(1, CAST(ROW(ROW(timestamp '2012-01-01 01:02:03.123 UTC')) AS ROW(child ROW(grandchild timestamp with time zone)))),\n(2, CAST(ROW(ROW(NULL)) AS ROW(child ROW(grandchild timestamp with time zone)))),\n(3, CAST(NULL AS ROW(child ROW(grandchild timestamp with time zone))))\n";
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + values, 3L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES " + values);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + tableName + " WHERE parent = ROW(ROW(timestamp '2012-01-01 01:02:03.123 UTC'))"))).matches("VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testTimestampWithTimeZoneInComplexTypesFails() {
        String location = this.getLocationForTable("delta", "foo");
        this.assertQueryFails("CREATE TABLE should_fail (a, b) WITH (location = '" + location + "') AS VALUES (ROW(timestamp '2012-10-31 01:00:00.1234 UTC', timestamp '2012-10-31 01:00:00.4321 UTC'), 1)", "Unsupported type:.*");
        this.assertQueryFails("CREATE TABLE should_fail (a) WITH (location = '" + location + "') AS VALUES ARRAY[timestamp '2012-10-31 01:00:00.1234 UTC', timestamp '2012-10-31 01:00:00.4321 UTC']", "Unsupported type:.*");
        this.assertQueryFails("CREATE TABLE should_fail (a) WITH (location = '" + location + "') AS VALUES MAP(ARRAY[ARRAY[timestamp '2012-10-31 01:00:00.1234 UTC', timestamp '2012-10-31 01:00:00.4321 UTC']], ARRAY[42])", "Unsupported type:.*");
        this.assertQueryFails("CREATE TABLE should_fail (a) WITH (location = '" + location + "') AS VALUES MAP(ARRAY[42], ARRAY[ARRAY[timestamp '2012-10-31 01:00:00.1234 UTC', timestamp '2012-10-31 01:00:00.4321 UTC']])", "Unsupported type:.*");
    }

    @Test
    public void testSelectOldDate() {
        this.assertQuery("SELECT * FROM old_dates", "VALUES (DATE '0099-12-30', 1), (DATE '1582-10-15', 2), (DATE '1960-01-01', 3), (DATE '2020-01-01', 4)");
        this.assertQuery("SELECT * FROM old_dates WHERE d = DATE '0099-12-30'", "VALUES (DATE '0099-12-30', 1)");
        this.assertQuery("SELECT * FROM old_dates WHERE d = DATE '1582-10-15'", "VALUES (DATE '1582-10-15', 2)");
        this.assertQuery("SELECT * FROM old_dates WHERE d = DATE '1960-01-01'", "VALUES (DATE '1960-01-01', 3)");
        this.assertQuery("SELECT * FROM old_dates WHERE d = DATE '2020-01-01'", "VALUES (DATE '2020-01-01', 4)");
    }

    @Test
    public void testSelectOldTimestamps() {
        this.assertQuery("SELECT CAST(ts AS VARCHAR), i FROM old_timestamps", "VALUES ('0099-12-30 01:02:03.000 UTC', 1), ('1582-10-15 01:02:03.000 UTC', 2), ('1960-01-01 01:02:03.000 UTC', 3), ('2020-01-01 01:02:03.000 UTC', 4);");
        this.assertQuery("SELECT CAST(ts AS VARCHAR), i FROM old_timestamps WHERE ts = TIMESTAMP '0099-12-30 01:02:03 UTC'", "VALUES ('0099-12-30 01:02:03.000 UTC', 1)");
        this.assertQuery("SELECT CAST(ts AS VARCHAR), i FROM old_timestamps WHERE ts = TIMESTAMP '1582-10-15 01:02:03 UTC'", "VALUES ('1582-10-15 01:02:03.000 UTC', 2)");
        this.assertQuery("SELECT CAST(ts AS VARCHAR), i FROM old_timestamps WHERE ts = TIMESTAMP '1960-01-01 01:02:03 UTC'", "VALUES ('1960-01-01 01:02:03.000 UTC', 3)");
        this.assertQuery("SELECT CAST(ts AS VARCHAR), i FROM old_timestamps WHERE ts = TIMESTAMP '2020-01-01 01:02:03 UTC'", "VALUES ('2020-01-01 01:02:03.000 UTC', 4)");
    }

    @Test
    public void testSelectNestedTimestamps() {
        this.assertQuery("SELECT CAST(col1[1].ts AS VARCHAR) FROM nested_timestamps", "VALUES '2010-02-03 12:11:10.000 UTC'");
        this.assertQuery("SELECT CAST(col1[1].ts AS VARCHAR) FROM nested_timestamps_parquet_stats LIMIT 1", "VALUES '2010-02-03 12:11:10.000 UTC'");
    }

    @Test
    public void testConvertJsonStatisticsToParquetOnRowType() throws Exception {
        this.assertQuery("SELECT count(*) FROM json_stats_on_row_type", "VALUES 2");
        String transactionLogDirectory = "json_stats_on_row_type/_delta_log";
        String tableLocation = this.getLocationForTable(this.bucketName, "json_stats_on_row_type");
        String newTransactionFile = tableLocation + "/_delta_log/00000000000000000004.json";
        String newCheckpointFile = tableLocation + "/_delta_log/00000000000000000004.checkpoint.parquet";
        Assertions.assertThat(this.getTableFiles(transactionLogDirectory)).doesNotContain((Object[])new String[]{newTransactionFile, newCheckpointFile});
        this.assertUpdate("INSERT INTO json_stats_on_row_type SELECT CAST(row(3) AS row(x bigint)), CAST(row(row('test insert')) AS row(y row(nested varchar)))", 1L);
        Assertions.assertThat(this.getTableFiles(transactionLogDirectory)).contains((Object[])new String[]{newTransactionFile, newCheckpointFile});
        List<AddFileEntry> addFileEntries = TestingDeltaLakeUtils.getTableActiveFiles(this.transactionLogAccess, tableLocation).stream().sorted(Comparator.comparing(AddFileEntry::getModificationTime)).toList();
        Assertions.assertThat(addFileEntries).hasSize(3);
        BaseDeltaLakeConnectorSmokeTest.assertJsonStatistics(addFileEntries.get(0), "{\"numRecords\":1,\"minValues\":{\"nested_struct_col\":{\"y\":{\"nested\":\"test\"}},\"struct_col\":{\"x\":1}},\"maxValues\":{\"nested_struct_col\":{\"y\":{\"nested\":\"test\"}},\"struct_col\":{\"x\":1}},\"nullCount\":{\"struct_col\":{\"x\":0},\"nested_struct_col\":{\"y\":{\"nested\":0}}}}");
        BaseDeltaLakeConnectorSmokeTest.assertJsonStatistics(addFileEntries.get(1), "{\"numRecords\":1,\"minValues\":{\"nested_struct_col\":{\"y\":{}},\"struct_col\":{}},\"maxValues\":{\"nested_struct_col\":{\"y\":{}},\"struct_col\":{}},\"nullCount\":{\"struct_col\":{\"x\":1},\"nested_struct_col\":{\"y\":{\"nested\":1}}}}");
        BaseDeltaLakeConnectorSmokeTest.assertJsonStatistics(addFileEntries.get(2), "{\"numRecords\":1,\"minValues\":{},\"maxValues\":{},\"nullCount\":{}}");
    }

    private static void assertJsonStatistics(AddFileEntry addFileEntry, @Language(value="JSON") String jsonStatistics) {
        Assertions.assertThat((String)((String)addFileEntry.getStatsString().orElseThrow(() -> new AssertionError((Object)("statsString is empty: " + String.valueOf(addFileEntry)))))).isEqualTo(jsonStatistics);
    }

    @Test
    public void testMissingParquetStats() {
        this.assertQuery("SELECT count(*) FROM parquet_stats_missing WHERE i IS NULL", "VALUES 1");
        this.assertQuery("SELECT max(i) FROM parquet_stats_missing", "VALUES 8");
        this.assertQuery("SELECT min(i) FROM parquet_stats_missing", "VALUES 1");
    }

    @Test
    public void testUppercaseColumnNames() {
        this.assertQuery("SELECT * FROM uppercase_columns", "VALUES (1,1), (1,2), (2,1)");
        this.assertQuery("SELECT * FROM uppercase_columns WHERE ALA=1", "VALUES (1,1), (1,2)");
        this.assertQuery("SELECT * FROM uppercase_columns WHERE ala=1", "VALUES (1,1), (1,2)");
        this.assertQuery("SELECT * FROM uppercase_columns WHERE KOTA=1", "VALUES (1,1), (2,1)");
        this.assertQuery("SELECT * FROM uppercase_columns WHERE kota=1", "VALUES (1,1), (2,1)");
    }

    @Test
    public void testInsertIntoNonLowercaseColumnTable() {
        this.assertQuery("SELECT * FROM insert_nonlowercase_columns", "VALUES ('databricks', 'DATABRICKS', 'DaTaBrIcKs'),('databricks', 'DATABRICKS', NULL),(NULL, NULL, 'DaTaBrIcKs'),(NULL, NULL, NULL)");
        this.assertUpdate("INSERT INTO insert_nonlowercase_columns VALUES ('trino', 'TRINO', 'TrInO'), ('trino', 'TRINO', NULL)", 2L);
        this.assertUpdate("INSERT INTO insert_nonlowercase_columns VALUES (NULL, NULL, 'TrInO'), (NULL, NULL, NULL)", 2L);
        this.assertQuery("SELECT * FROM insert_nonlowercase_columns", "VALUES ('databricks', 'DATABRICKS', 'DaTaBrIcKs'),('databricks', 'DATABRICKS', NULL),(NULL, NULL, 'DaTaBrIcKs'),(NULL, NULL, NULL), ('trino', 'TRINO', 'TrInO'),('trino', 'TRINO', NULL),(NULL, NULL, 'TrInO'),(NULL, NULL, NULL)");
        this.assertQuery("SHOW STATS FOR insert_nonlowercase_columns", "VALUES ('lower_case_string', 10.0, 1.0, 0.5, null, null, null),('upper_case_string', 10.0, 1.0, 0.5, null, null, null),('mixed_case_string', 10.0, 1.0, 0.5, null, null, null),(null, null, null, null, 8.0, null, null)");
    }

    @Test
    public void testInsertNestedNonLowercaseColumns() {
        this.assertQuery("SELECT an_int, nested.lower_case_string, nested.upper_case_string, nested.mixed_case_string FROM insert_nested_nonlowercase_columns", "VALUES (1, 'databricks', 'DATABRICKS', 'DaTaBrIcKs'),(2, 'databricks', 'DATABRICKS', NULL),(3, NULL, NULL, 'DaTaBrIcKs'),(4, NULL, NULL, NULL)");
        this.assertUpdate("INSERT INTO insert_nested_nonlowercase_columns VALUES (10, ROW('trino', 'TRINO', 'TrInO')),(20, ROW('trino', 'TRINO', NULL)),(30, ROW(NULL, NULL, 'TrInO')),(40, ROW(NULL, NULL, NULL))", 4L);
        this.assertQuery("SELECT an_int, nested.lower_case_string, nested.upper_case_string, nested.mixed_case_string FROM insert_nested_nonlowercase_columns", "VALUES (1, 'databricks', 'DATABRICKS', 'DaTaBrIcKs'),(2, 'databricks', 'DATABRICKS', NULL),(3, NULL, NULL, 'DaTaBrIcKs'),(4, NULL, NULL, NULL),(10, 'trino', 'TRINO', 'TrInO'),(20, 'trino', 'TRINO', NULL),(30, NULL, NULL, 'TrInO'),(40, NULL, NULL, NULL)");
        this.assertQuery("SHOW STATS FOR insert_nested_nonlowercase_columns", "VALUES ('an_int', null, 4.0, 0.0, null, 1, 40),('nested', null, null, null, null, null, null),(null, null, null, null, 8.0, null, null)");
    }

    @Test
    public void testInsertIntoPartitionedTable() {
        String tableName = "test_insert_partitioned_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a_number, a_string)  WITH (location = '%s',        partitioned_by = ARRAY['a_number'])  AS VALUES (1, 'ala')", tableName, this.getLocationForTable(this.bucketName, tableName)), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (2, 'kota'), (3, 'psa')", tableName), 2L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (2, 'bobra'), (5, 'kreta')", tableName), 2L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1,'ala'), (2,'kota'), (3,'psa'), (2, 'bobra'), (5, 'kreta')");
        this.assertQuery("SELECT DISTINCT regexp_replace(\"$path\", '.*[/]([^/]*)[/][^/]*$', '$1') FROM " + tableName, "VALUES 'a_number=1', 'a_number=2', 'a_number=3', 'a_number=5'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInsertIntoPartitionedNonLowercaseColumnTable() {
        this.assertQuery("SELECT * FROM insert_nonlowercase_columns_partitioned", "VALUES ('databricks', 'DATABRICKS', 'DaTaBrIcKs'),('databricks', 'DATABRICKS', NULL),(NULL, NULL, 'DaTaBrIcKs'),(NULL, NULL, NULL)");
        this.assertUpdate("INSERT INTO insert_nonlowercase_columns_partitioned VALUES ('trino', 'TRINO', 'TrInO'), ('trino', 'TRINO', NULL)", 2L);
        this.assertUpdate("INSERT INTO insert_nonlowercase_columns_partitioned VALUES (NULL, NULL, 'TrInO'), (NULL, NULL, NULL)", 2L);
        this.assertQuery("SELECT * FROM insert_nonlowercase_columns_partitioned", "VALUES ('databricks', 'DATABRICKS', 'DaTaBrIcKs'),('databricks', 'DATABRICKS', NULL),(NULL, NULL, 'DaTaBrIcKs'),(NULL, NULL, NULL), ('trino', 'TRINO', 'TrInO'),('trino', 'TRINO', NULL),(NULL, NULL, 'TrInO'),(NULL, NULL, NULL)");
        this.assertQuery("SELECT DISTINCT regexp_replace(\"$path\", '.*[/]([^/]*)[/][^/]*$', '$1') FROM insert_nonlowercase_columns_partitioned", "VALUES 'MiXeD_CaSe_StRiNg=DaTaBrIcKs', 'MiXeD_CaSe_StRiNg=__HIVE_DEFAULT_PARTITION__', 'MiXeD_CaSe_StRiNg=TrInO'");
        this.assertQuery("SHOW STATS FOR insert_nonlowercase_columns_partitioned", "VALUES ('lower_case_string', 10.0, 1.0, 0.5, null, null, null),('upper_case_string', 10.0, 1.0, 0.5, null, null, null),('mixed_case_string', null, 2.0, 0.5, null, null, null),(null, null, null, null, 8.0, null, null)");
    }

    @Test
    public void testPartialInsert() {
        String tableName = "test_partial_insert_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a_number, a_string) WITH (location = '%s') AS VALUES (1, 'ala')", tableName, this.getLocationForTable(this.bucketName, tableName)), 1L);
        this.assertUpdate(String.format("INSERT INTO %s(a_number) VALUES (2), (3)", tableName), 2L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'ala'), (2, NULL), (3, NULL)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPartialInsertIntoPartitionedTable() {
        String tableName = "test_partial_insert_partitioned_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a_number, a_string)  WITH (location = '%s',        partitioned_by = ARRAY['a_number'])  AS VALUES (1, 'ala')", tableName, this.getLocationForTable(this.bucketName, tableName)), 1L);
        this.assertUpdate(String.format("INSERT INTO %s(a_number) VALUES (2), (3)", tableName), 2L);
        this.assertUpdate(String.format("INSERT INTO %s(a_string) VALUES ('lwa')", tableName), 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'ala'), (2, NULL), (3, NULL), (NULL, 'lwa')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInsertColumnOrdering() {
        String tableName = "test_insert_column_ordering_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a INT, b INT, c INT) WITH (location = '%s', partitioned_by = ARRAY['a', 'b'])", tableName, this.getLocationForTable(this.bucketName, tableName)));
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 2, 3), (4, 5, 6)", 2L);
        this.assertUpdate("INSERT INTO " + tableName + " (c, b, a) VALUES (9, 8, 7)", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 2, 3), (4, 5, 6), (7, 8, 9)");
    }

    @Test
    public void testDefaultPartitions() {
        this.assertQuery("SELECT * FROM default_partitions", "VALUES (NULL, 'partition_a', 'jarmuz'), (1, NULL, 'brukselka'), (NULL, NULL, 'kalafior')");
        this.assertQuery("SELECT * FROM default_partitions WHERE number_partition IS NULL", "VALUES (NULL, 'partition_a', 'jarmuz'), (NULL, NULL, 'kalafior')");
        this.assertQuery("SELECT * FROM default_partitions WHERE number_partition IS NOT NULL", "VALUES (1, NULL, 'brukselka')");
        this.assertQuery("SELECT * FROM default_partitions WHERE string_partition IS NULL", "VALUES (1, NULL, 'brukselka'), (NULL, NULL, 'kalafior')");
        this.assertQuery("SELECT * FROM default_partitions WHERE string_partition IS NOT NULL", "VALUES (NULL, 'partition_a', 'jarmuz')");
        this.assertQuery("SELECT * FROM default_partitions WHERE number_partition > 0", "VALUES (1, NULL, 'brukselka')");
    }

    @Test
    public void testCheckpointing() {
        String tableName = "test_insert_checkpointing_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a_number, a_string)  WITH (location = '%s',        partitioned_by = ARRAY['a_number'],        checkpoint_interval = 5)  AS VALUES (1, 'ala')", tableName, this.getLocationForTable(this.bucketName, tableName)), 1L);
        String transactionLogDirectory = String.format("%s/_delta_log", tableName);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (2, 'kota'), (3, 'psa')", tableName), 2L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (2, 'bobra'), (5, 'kreta')", tableName), 2L);
        this.assertUpdate(String.format("DELETE FROM %s WHERE a_string = 'kota'", tableName), 1L);
        this.assertUpdate(String.format("DELETE FROM %s WHERE a_string = 'kreta'", tableName), 1L);
        Assertions.assertThat(this.listCheckpointFiles(transactionLogDirectory)).isEmpty();
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1,'ala'),  (3,'psa'), (2, 'bobra')");
        this.fillWithInserts(tableName, "(1, 'fill')", 1);
        Assertions.assertThat(this.listCheckpointFiles(transactionLogDirectory)).hasSize(1);
        this.assertQuery("SELECT * FROM " + tableName + " WHERE a_string <> 'fill'", "VALUES (1,'ala'),  (3,'psa'), (2, 'bobra')");
        this.fillWithInserts(tableName, "(1, 'fill')", 5);
        Assertions.assertThat(this.listCheckpointFiles(transactionLogDirectory)).hasSize(2);
        this.assertQuery("SELECT * FROM " + tableName + " WHERE a_string <> 'fill'", "VALUES (1,'ala'),  (3,'psa'), (2, 'bobra')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCheckpointWriteStatsAsStruct() {
        this.testCheckpointWriteStatsAsStruct("boolean", "true", "false", "0.0", "null", "null");
        this.testCheckpointWriteStatsAsStruct("integer", "1", "2147483647", "0.0", "1", "2147483647");
        this.testCheckpointWriteStatsAsStruct("tinyint", "2", "127", "0.0", "2", "127");
        this.testCheckpointWriteStatsAsStruct("smallint", "3", "32767", "0.0", "3", "32767");
        this.testCheckpointWriteStatsAsStruct("bigint", "1000", "9223372036854775807", "0.0", "1000", "9223372036854775807");
        this.testCheckpointWriteStatsAsStruct("real", "0.1", "999999.999", "0.0", "0.1", "1000000.0");
        this.testCheckpointWriteStatsAsStruct("double", "1.0", "9999999999999.999", "0.0", "1.0", "'1.0E13'");
        this.testCheckpointWriteStatsAsStruct("decimal(3,2)", "3.14", "9.99", "0.0", "3.14", "9.99");
        this.testCheckpointWriteStatsAsStruct("decimal(30,1)", "12345", "99999999999999999999999999999.9", "0.0", "12345.0", "'1.0E29'");
        this.testCheckpointWriteStatsAsStruct("varchar", "'test'", "'\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b'", "0.0", "null", "null");
        this.testCheckpointWriteStatsAsStruct("varbinary", "X'65683F'", "X'ffffffffffffffffffff'", "0.0", "null", "null");
        this.testCheckpointWriteStatsAsStruct("date", "date '2021-02-03'", "date '9999-12-31'", "0.0", "'2021-02-03'", "'9999-12-31'");
        this.testCheckpointWriteStatsAsStruct("timestamp(3) with time zone", "timestamp '2001-08-22 03:04:05.321 -08:00'", "timestamp '9999-12-31 23:59:59.999 +12:00'", "0.0", "'2001-08-22 11:04:05.321 UTC'", "'9999-12-31 11:59:59.999 UTC'");
        this.testCheckpointWriteStatsAsStruct("array(int)", "array[1]", "array[2147483647]", "null", "null", "null");
        this.testCheckpointWriteStatsAsStruct("map(varchar,int)", "map(array['foo', 'bar'], array[1, 2])", "map(array['foo', 'bar'], array[-2147483648, 2147483647])", "null", "null", "null");
        this.testCheckpointWriteStatsAsStruct("row(x bigint)", "cast(row(1) as row(x bigint))", "cast(row(9223372036854775807) as row(x bigint))", "null", "null", "null");
    }

    private void testCheckpointWriteStatsAsStruct(String type, String sampleValue, String highValue, String nullsFraction, String minValue, String maxValue) {
        String tableName = "test_checkpoint_write_stats_as_struct_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (col %s) WITH (location = '%s', checkpoint_interval = 1)", tableName, type, this.getLocationForTable(this.bucketName, tableName)));
        this.assertUpdate(BaseDeltaLakeConnectorSmokeTest.disableStatisticsCollectionOnWrite(this.getSession()), "INSERT INTO " + tableName + " SELECT " + sampleValue + " UNION ALL SELECT " + highValue, 2L);
        Assertions.assertThat(this.getTableFiles(tableName)).contains((Object[])new String[]{this.getTableLocation(tableName) + "/_delta_log/_last_checkpoint"});
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('col', null, null, " + nullsFraction + ", null, " + minValue + ", " + maxValue + "),(null, null, null, null, 2.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCheckpointWriteStatsAsStructWithPartiallyUnsupportedColumnStats() {
        String tableName = "test_checkpoint_write_stats_as_struct_partially_unsupported_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (col integer, unsupported boolean) WITH (location = '%s', checkpoint_interval = 1)", tableName, this.getLocationForTable(this.bucketName, tableName)));
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, true)", 1L);
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('col', null, 1.0, 0.0, null, 1, 1),('unsupported', null, 1.0, 0.0, null, null, null),(null, null, null, null, 1.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateOrReplaceCheckpointing() {
        String tableName = "test_create_or_replace_checkpointing_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE OR REPLACE TABLE %s (a_number, a_string)  WITH (location = '%s',        partitioned_by = ARRAY['a_number'])  AS VALUES (1, 'ala')", tableName, this.getLocationForTable(this.bucketName, tableName)), 1L);
        String transactionLogDirectory = String.format("%s/_delta_log", tableName);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (2, 'kota'), (3, 'psa')", tableName), 2L);
        Assertions.assertThat(this.listCheckpointFiles(transactionLogDirectory)).isEmpty();
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1,'ala'),  (2,'kota'), (3, 'psa')");
        this.assertUpdate(String.format("CREATE OR REPLACE TABLE %s (a_number integer)  WITH (checkpoint_interval = 2)", tableName));
        Assertions.assertThat(this.listCheckpointFiles(transactionLogDirectory)).hasSize(1);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).returnsEmptyResult();
        this.assertUpdate(String.format("INSERT INTO " + tableName + " VALUES 1", tableName), 1L);
        Assertions.assertThat(this.listCheckpointFiles(transactionLogDirectory)).hasSize(1);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 1");
        this.assertUpdate(String.format("CREATE OR REPLACE TABLE %s (a_string)  WITH (checkpoint_interval = 2)  AS VALUES 'bobra', 'kreta'", tableName), 2L);
        Assertions.assertThat(this.listCheckpointFiles(transactionLogDirectory)).hasSize(2);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 'bobra', 'kreta'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDeltaLakeTableLocationChanged() throws Exception {
        this.testDeltaLakeTableLocationChanged(true, false, false);
    }

    @Test
    public void testDeltaLakeTableLocationChangedSameVersionNumber() throws Exception {
        this.testDeltaLakeTableLocationChanged(false, false, false);
    }

    @Test
    public void testDeltaLakeTableLocationChangedPartitioned() throws Exception {
        this.testDeltaLakeTableLocationChanged(true, true, false);
        this.testDeltaLakeTableLocationChanged(true, false, true);
        this.testDeltaLakeTableLocationChanged(true, true, true);
    }

    private void testDeltaLakeTableLocationChanged(boolean fewerEntries, boolean firstPartitioned, boolean secondPartitioned) throws Exception {
        MaterializedResult currentVisibleData;
        MaterializedResult expectedDataAfterChange;
        String newLocation;
        String tableName = "test_table_location_changed_" + TestingNames.randomNameSuffix();
        String initialLocation = this.getLocationForTable(this.bucketName, tableName);
        this.assertUpdate(String.format("CREATE TABLE %s (a_number int, a_string varchar) WITH (location = '%s' %s)", tableName, initialLocation, firstPartitioned ? ", partitioned_by = ARRAY['a_number']" : ""));
        BiConsumer<QueryRunner, String> insertABunchOfRows = (queryRunner, prefix) -> {
            queryRunner.execute(String.format("INSERT INTO %s (a_number, a_string) VALUES (1, '%s one')", tableName, prefix));
            queryRunner.execute(String.format("INSERT INTO %s (a_number, a_string) VALUES (2, '%s two')", tableName, prefix));
            queryRunner.execute(String.format("INSERT INTO %s (a_number, a_string) VALUES (3, '%s tree')", tableName, prefix));
            queryRunner.execute(String.format("INSERT INTO %s (a_number, a_string) VALUES (4, '%s four')", tableName, prefix));
        };
        insertABunchOfRows.accept(this.getQueryRunner(), "first");
        MaterializedResult initialData = this.computeActual("SELECT * FROM " + tableName);
        Assertions.assertThat((List)initialData.getMaterializedRows()).hasSize(4);
        try (QueryRunner independentQueryRunner = this.createDeltaLakeQueryRunner();){
            newLocation = this.getLocationForTable(this.bucketName, "test_table_location_changed_new_" + TestingNames.randomNameSuffix());
            independentQueryRunner.execute("DROP TABLE " + tableName);
            independentQueryRunner.execute(String.format("CREATE TABLE %s (a_number int, a_string varchar, another_string varchar) WITH (location = '%s' %s) ", tableName, newLocation, secondPartitioned ? ", partitioned_by = ARRAY['a_number']" : ""));
            if (fewerEntries) {
                independentQueryRunner.execute(String.format("INSERT INTO %s VALUES (1, 'second one', 'third column')", tableName));
            } else {
                insertABunchOfRows.accept(independentQueryRunner, "second");
            }
            expectedDataAfterChange = independentQueryRunner.execute("SELECT * FROM " + tableName);
            Assertions.assertThat((List)expectedDataAfterChange.getMaterializedRows()).hasSize(fewerEntries ? 1 : 4);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (!Set.copyOf((currentVisibleData = this.computeActual("SELECT * FROM " + tableName)).getMaterializedRows()).equals(Set.copyOf(expectedDataAfterChange.getMaterializedRows()))) {
            if (!Set.copyOf(currentVisibleData.getMaterializedRows()).equals(Set.copyOf(initialData.getMaterializedRows()))) {
                throw new AssertionError((Object)String.format("Unexpected result when reading table: %s,\n expected either initialData: %s\n or expectedDataAfterChange: %s", currentVisibleData, initialData, expectedDataAfterChange));
            }
            if (stopwatch.elapsed(TimeUnit.SECONDS) > 25L) {
                throw new RuntimeException("Timed out waiting on table to reflect new data from new location");
            }
            TimeUnit.SECONDS.sleep(1L);
        }
        String qualifiedTableName = "%s.%s.%s".formatted(this.getSession().getCatalog().orElseThrow(), SCHEMA, tableName);
        Assertions.assertThat((Object)this.computeScalar("SHOW CREATE TABLE " + tableName)).isEqualTo((Object)("CREATE TABLE " + qualifiedTableName + " (\n   a_number integer,\n   a_string varchar,\n   another_string varchar\n)\nWITH (\n   location = '" + newLocation + "'" + (secondPartitioned ? "," : "") + "\n" + (secondPartitioned ? "   partitioned_by = ARRAY['a_number']\n" : "") + ")"));
    }

    @Test
    public void testAnalyze() {
        String tableName = "test_analyze_" + TestingNames.randomNameSuffix();
        this.assertUpdate(BaseDeltaLakeConnectorSmokeTest.disableStatisticsCollectionOnWrite(this.getSession()), "CREATE TABLE " + tableName + " WITH (location = '" + this.getLocationForTable(this.bucketName, tableName) + "') AS SELECT * FROM tpch.sf1.nation", 25L);
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('nationkey', null, null, 0.0, null, 0, 24),('regionkey', null, null, 0.0, null, 0, 4),('comment', null, null, 0.0, null, null, null),('name', null, null, 0.0, null, null, null),(null, null, null, null, 25.0, null, null)");
        this.getQueryRunner().execute("ANALYZE " + tableName);
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('nationkey', null, 25.0, 0.0, null, 0, 24),('regionkey', null, 5.0, 0.0, null, 0, 4),('comment', 1857.0, 25.0, 0.0, null, null, null),('name', 177.0, 25.0, 0.0, null, null, null),(null, null, null, null, 25.0, null, null)");
    }

    @Test
    public void testStatsSplitPruningBasedOnSepCreatedCheckpoint() {
        String tableName = "test_sep_checkpoint_stats_pruning_" + TestingNames.randomNameSuffix();
        String transactionLogDirectory = String.format("%s/_delta_log", tableName);
        this.assertUpdate(String.format("CREATE TABLE %s (a_number, a_string) WITH (location = '%s') AS VALUES (1, 'ala')", tableName, this.getLocationForTable(this.bucketName, tableName)), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (2, 'kota')", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (3, 'kota')", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (4, 'kota')", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (5, 'kota')", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (6, 'kota')", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (7, 'kota')", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (8, 'kota')", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (9, 'kota')", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (10, 'kota')", tableName), 1L);
        Assertions.assertThat(this.listCheckpointFiles(transactionLogDirectory)).isEmpty();
        this.testCountQuery(String.format("SELECT count(*) FROM %s WHERE a_number <= 3", tableName), 3L, 3L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (11, 'kota')", tableName), 1L);
        Assertions.assertThat(this.listCheckpointFiles(transactionLogDirectory)).hasSize(1);
        this.testCountQuery(String.format("SELECT count(*) FROM %s WHERE a_number <= 3", tableName), 3L, 3L);
        this.invalidateMetadataCache(tableName);
        this.testCountQuery(String.format("SELECT count(*) FROM %s WHERE a_number <= 3", tableName), 3L, 3L);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testStatsSplitPruningBasedOnSepCreatedCheckpointOnTopOfCheckpointWithJustStructStats() {
        String tableName = "test_sep_checkpoint_stats_pruning_struct_stats_" + TestingNames.randomNameSuffix();
        this.registerTableFromResources(tableName, "databricks73/pruning/parquet_struct_statistics", this.getQueryRunner());
        String transactionLogDirectory = String.format("%s/_delta_log", tableName);
        Assertions.assertThat(this.listCheckpointFiles(transactionLogDirectory)).hasSize(1);
        this.testCountQuery(String.format("SELECT count(*) FROM %s WHERE l = 0", tableName), 3L, 3L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)", tableName), 1L);
        Assertions.assertThat(this.listCheckpointFiles(transactionLogDirectory)).hasSize(2);
        this.testCountQuery(String.format("SELECT count(*) FROM %s WHERE l = 0", tableName), 3L, 3L);
        this.invalidateMetadataCache(tableName);
        this.testCountQuery(String.format("SELECT count(*) FROM %s WHERE l = 0", tableName), 3L, 3L);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVacuum() throws Exception {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String tableName = "test_vacuum" + TestingNames.randomNameSuffix();
        String tableLocation = this.getLocationForTable(this.bucketName, tableName);
        Session sessionWithShortRetentionUnlocked = Session.builder((Session)this.getSession()).setCatalogSessionProperty(catalog, "vacuum_min_retention", "0s").build();
        this.assertUpdate(String.format("CREATE TABLE %s WITH (location = '%s', partitioned_by = ARRAY['regionkey']) AS SELECT * FROM tpch.tiny.nation", tableName, tableLocation), 25L);
        try {
            Set<String> initialFiles = this.getActiveFiles(tableName);
            Assertions.assertThat(initialFiles).hasSize(5);
            this.computeActual("UPDATE " + tableName + " SET nationkey = nationkey + 100");
            Stopwatch timeSinceUpdate = Stopwatch.createStarted();
            Set<String> updatedFiles = this.getActiveFiles(tableName);
            ((AbstractCollectionAssert)Assertions.assertThat(updatedFiles).hasSize(5)).doesNotContainAnyElementsOf(initialFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
            this.assertUpdate(sessionWithShortRetentionUnlocked, "CALL system.vacuum(schema_name => CURRENT_SCHEMA, table_name => '" + tableName + "', retention => '10m')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("SELECT nationkey + 100, CAST(name AS varchar), regionkey, CAST(comment AS varchar) FROM tpch.tiny.nation");
            Assertions.assertThat(this.getActiveFiles(tableName)).isEqualTo(updatedFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
            TimeUnit.MILLISECONDS.sleep(2000L - timeSinceUpdate.elapsed(TimeUnit.MILLISECONDS) + 1L);
            this.assertUpdate(sessionWithShortRetentionUnlocked, "CALL system.vacuum(schema_name => CURRENT_SCHEMA, table_name => '" + tableName + "', retention => '1s')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("SELECT nationkey + 100, CAST(name AS varchar), regionkey, CAST(comment AS varchar) FROM tpch.tiny.nation");
            Assertions.assertThat(this.getActiveFiles(tableName)).isEqualTo(updatedFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo(updatedFiles);
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVacuumWithTrailingSlash() throws Exception {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String tableName = "test_vacuum" + TestingNames.randomNameSuffix();
        String tableLocation = this.getLocationForTable(this.bucketName, tableName) + "/";
        Session sessionWithShortRetentionUnlocked = Session.builder((Session)this.getSession()).setCatalogSessionProperty(catalog, "vacuum_min_retention", "0s").build();
        this.assertUpdate(String.format("CREATE TABLE %s WITH (location = '%s', partitioned_by = ARRAY['regionkey']) AS SELECT * FROM tpch.tiny.nation", tableName, tableLocation), 25L);
        try {
            Set<String> initialFiles = this.getActiveFiles(tableName);
            Assertions.assertThat(initialFiles).hasSize(5);
            this.computeActual("UPDATE " + tableName + " SET nationkey = nationkey + 100");
            Stopwatch timeSinceUpdate = Stopwatch.createStarted();
            Set<String> updatedFiles = this.getActiveFiles(tableName);
            ((AbstractCollectionAssert)Assertions.assertThat(updatedFiles).hasSize(5)).doesNotContainAnyElementsOf(initialFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
            this.assertUpdate(sessionWithShortRetentionUnlocked, "CALL system.vacuum(schema_name => CURRENT_SCHEMA, table_name => '" + tableName + "', retention => '10m')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("SELECT nationkey + 100, CAST(name AS varchar), regionkey, CAST(comment AS varchar) FROM tpch.tiny.nation");
            Assertions.assertThat(this.getActiveFiles(tableName)).isEqualTo(updatedFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
            TimeUnit.MILLISECONDS.sleep(2000L - timeSinceUpdate.elapsed(TimeUnit.MILLISECONDS) + 1L);
            this.assertUpdate(sessionWithShortRetentionUnlocked, "CALL system.vacuum(schema_name => CURRENT_SCHEMA, table_name => '" + tableName + "', retention => '1s')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("SELECT nationkey + 100, CAST(name AS varchar), regionkey, CAST(comment AS varchar) FROM tpch.tiny.nation");
            Assertions.assertThat(this.getActiveFiles(tableName)).isEqualTo(updatedFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo(updatedFiles);
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVacuumWithWhiteSpace() throws Exception {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String tableName = "test_vacuum_white_space_" + TestingNames.randomNameSuffix();
        String tableLocation = this.getLocationForTable(this.bucketName, tableName) + "/";
        Session sessionWithShortRetentionUnlocked = Session.builder((Session)this.getSession()).setCatalogSessionProperty(catalog, "vacuum_min_retention", "0s").build();
        this.assertUpdate(String.format("CREATE TABLE %s (val int, col_white_space timestamp(6)) WITH (location = '%s', partitioned_by = ARRAY['col_white_space'])", tableName, tableLocation));
        try {
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, TIMESTAMP '2024-12-13 11:00:00.000000'), (2, TIMESTAMP '2024-12-13 12:00:00.000000')", 2L);
            Set<String> initialFiles = this.getActiveFiles(tableName);
            Assertions.assertThat(initialFiles).hasSize(2);
            this.computeActual("UPDATE " + tableName + " SET val = val + 100");
            Stopwatch timeSinceUpdate = Stopwatch.createStarted();
            Set<String> updatedFiles = this.getActiveFiles(tableName);
            ((AbstractCollectionAssert)Assertions.assertThat(updatedFiles).hasSize(2)).doesNotContainAnyElementsOf(initialFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
            this.assertUpdate(sessionWithShortRetentionUnlocked, "CALL system.vacuum(CURRENT_SCHEMA, '" + tableName + "', '10m')");
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (101, TIMESTAMP '2024-12-13 11:00:00.000000'), (102, TIMESTAMP '2024-12-13 12:00:00.000000')");
            Assertions.assertThat(this.getActiveFiles(tableName)).isEqualTo(updatedFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
            TimeUnit.MILLISECONDS.sleep(2000L - timeSinceUpdate.elapsed(TimeUnit.MILLISECONDS) + 1L);
            this.assertUpdate(sessionWithShortRetentionUnlocked, "CALL system.vacuum(CURRENT_SCHEMA, '" + tableName + "', '1s')");
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (101, TIMESTAMP '2024-12-13 11:00:00.000000'), (102, TIMESTAMP '2024-12-13 12:00:00.000000')");
            Assertions.assertThat(this.getActiveFiles(tableName)).isEqualTo(updatedFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo(updatedFiles);
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testVacuumParameterValidation() {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String tableName = "test_vacuum_parameter_validation_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s WITH (location = '%s') AS SELECT * FROM tpch.tiny.nation", tableName, this.getLocationForTable(this.bucketName, tableName)), 25L);
        this.assertQueryFails("CALL system.vacuum(NULL, NULL, NULL)", "schema_name cannot be null");
        this.assertQueryFails("CALL system.vacuum(CURRENT_SCHEMA, NULL, NULL)", "table_name cannot be null");
        this.assertQueryFails("CALL system.vacuum(CURRENT_SCHEMA, '" + tableName + "')", "line 1:1: Required procedure argument 'RETENTION' is missing");
        this.assertQueryFails("CALL system.vacuum(CURRENT_SCHEMA, '" + tableName + "', NULL)", "retention cannot be null");
        this.assertQueryFails("CALL system.vacuum(CURRENT_SCHEMA, '" + tableName + "', '1s')", "\\QRetention specified (1.00s) is shorter than the minimum retention configured in the system (7.00d). Minimum retention can be changed with delta.vacuum.min-retention configuration property or " + catalog + ".vacuum_min_retention session property");
        this.assertQueryFails("CALL system.vacuum('', '', '77d')", "schema_name cannot be empty");
        this.assertQueryFails("CALL system.vacuum(CURRENT_SCHEMA, '', '77d')", "table_name cannot be empty");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testVacuumAccessControl() {
        String tableName = "test_deny_vacuum_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (location = '" + this.getLocationForTable(this.bucketName, tableName) + "') AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertAccessDenied("CALL system.vacuum(schema_name => CURRENT_SCHEMA, table_name => '" + tableName + "', retention => '30d')", "Cannot insert into table .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE)});
        this.assertAccessDenied("CALL system.vacuum(schema_name => CURRENT_SCHEMA, table_name => '" + tableName + "', retention => '30d')", "Cannot delete from table .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DELETE_TABLE)});
        this.assertUpdate("DROP TABLE " + tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOptimize() {
        String tableName = "test_optimize_" + TestingNames.randomNameSuffix();
        String tableLocation = this.getLocationForTable(this.bucketName, tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " (key integer, value varchar) WITH (location = '" + tableLocation + "')");
        try {
            int workerCount = this.getQueryRunner().getNodeCount();
            this.assertQuerySucceeds("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
            Assertions.assertThat(this.getActiveFiles(tableName)).isEmpty();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (11, 'eleven')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (12, 'zw\u00f6lf')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (13, 'trzyna\u015bcie')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (14, 'quatorze')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (15, '\u043f\u02bc\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c')", 1L);
            Set<String> initialFiles = this.getActiveFiles(tableName);
            ((AbstractCollectionAssert)Assertions.assertThat(initialFiles).hasSize(5)).hasSizeGreaterThan(workerCount);
            this.computeActual("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(key), listagg(value, ' ') WITHIN GROUP (ORDER BY key) FROM " + tableName))).matches("VALUES (BIGINT '65', VARCHAR 'eleven zw\u00f6lf trzyna\u015bcie quatorze \u043f\u02bc\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c')");
            Set<String> updatedFiles = this.getActiveFiles(tableName);
            ((AbstractCollectionAssert)Assertions.assertThat(updatedFiles).hasSizeBetween(1, workerCount)).doesNotContainAnyElementsOf(initialFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
            this.computeActual("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE (file_size_threshold => '33B')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(key), listagg(value, ' ') WITHIN GROUP (ORDER BY key) FROM " + tableName))).matches("VALUES (BIGINT '65', VARCHAR 'eleven zw\u00f6lf trzyna\u015bcie quatorze \u043f\u02bc\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c')");
            Assertions.assertThat(this.getActiveFiles(tableName)).isEqualTo(updatedFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testOptimizeParameterValidation() {
        this.assertQueryFails("ALTER TABLE no_such_table_exists EXECUTE OPTIMIZE", String.format("line 1:7: Table 'delta.%s.no_such_table_exists' does not exist", SCHEMA));
        this.assertQueryFails("ALTER TABLE nation EXECUTE OPTIMIZE (file_size_threshold => '33')", "\\Qline 1:38: Unable to set catalog 'delta' table procedure 'OPTIMIZE' property 'file_size_threshold' to ['33']: size is not a valid data size string: 33");
        this.assertQueryFails("ALTER TABLE nation EXECUTE OPTIMIZE (file_size_threshold => '33s')", "\\Qline 1:38: Unable to set catalog 'delta' table procedure 'OPTIMIZE' property 'file_size_threshold' to ['33s']: Unknown unit: s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOptimizeWithPartitionedTable() {
        String tableName = "test_optimize_partitioned_table_" + TestingNames.randomNameSuffix();
        String tableLocation = this.getLocationForTable(this.bucketName, tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " (key integer, value varchar) WITH (location = '" + tableLocation + "', partitioned_by = ARRAY['value'])");
        try {
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 'one')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, 'two')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, 'three')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (4, 'four')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (11, 'one')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (111, 'ONE')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (33, 'tHrEe')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (333, 'Three')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (10, 'one')", 1L);
            Set<String> initialFiles = this.getActiveFiles(tableName);
            Assertions.assertThat(initialFiles).hasSize(9);
            this.computeActual("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(key), listagg(value, ' ') WITHIN GROUP (ORDER BY value) FROM " + tableName))).matches("VALUES (BIGINT '508', VARCHAR 'ONE Three four one one one tHrEe three two')");
            Set<String> updatedFiles = this.getActiveFiles(tableName);
            Assertions.assertThat(updatedFiles).hasSizeBetween(7, initialFiles.size());
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOptimizeWithEnforcedRepartitioning() {
        Session currentSession = TestingSession.testSessionBuilder().setCatalog(this.getQueryRunner().getDefaultSession().getCatalog()).setSchema(this.getQueryRunner().getDefaultSession().getSchema()).setSystemProperty("use_preferred_write_partitioning", "true").build();
        String tableName = "test_optimize_partitioned_table_" + TestingNames.randomNameSuffix();
        String tableLocation = this.getLocationForTable(this.bucketName, tableName);
        this.assertUpdate(currentSession, "CREATE TABLE " + tableName + " (key integer, value varchar) WITH (location = '" + tableLocation + "', partitioned_by = ARRAY['value'])");
        try {
            this.assertUpdate(currentSession, "INSERT INTO " + tableName + " VALUES (1, 'one')", 1L);
            this.assertUpdate(currentSession, "INSERT INTO " + tableName + " VALUES (2, 'one')", 1L);
            this.assertUpdate(currentSession, "INSERT INTO " + tableName + " VALUES (3, 'one')", 1L);
            this.assertUpdate(currentSession, "INSERT INTO " + tableName + " VALUES (4, 'one')", 1L);
            this.assertUpdate(currentSession, "INSERT INTO " + tableName + " VALUES (5, 'one')", 1L);
            this.assertUpdate(currentSession, "INSERT INTO " + tableName + " VALUES (6, 'one')", 1L);
            this.assertUpdate(currentSession, "INSERT INTO " + tableName + " VALUES (7, 'one')", 1L);
            this.assertUpdate(currentSession, "INSERT INTO " + tableName + " VALUES (8, 'two')", 1L);
            this.assertUpdate(currentSession, "INSERT INTO " + tableName + " VALUES (9, 'two')", 1L);
            this.assertUpdate(currentSession, "INSERT INTO " + tableName + " VALUES (10, 'three')", 1L);
            Set<String> initialFiles = this.getActiveFiles(tableName, currentSession);
            Assertions.assertThat(initialFiles).hasSize(10);
            this.computeActual(currentSession, "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(currentSession, "SELECT sum(key), listagg(value, ' ') WITHIN GROUP (ORDER BY value) FROM " + tableName))).matches("VALUES (BIGINT '55', VARCHAR 'one one one one one one one three two two')");
            Set<String> updatedFiles = this.getActiveFiles(tableName, currentSession);
            Assertions.assertThat(updatedFiles).hasSize(3);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    private void fillWithInserts(String tableName, String values, int toCreate) {
        for (int i = 0; i < toCreate; ++i) {
            this.assertUpdate(String.format("INSERT INTO %s VALUES %s", tableName, values), 1L);
        }
    }

    private void invalidateMetadataCache(String tableName) {
        Set activeFiles = this.computeActual("SELECT \"$path\" FROM " + tableName).getOnlyColumnAsSet();
        String location = (String)this.computeScalar(String.format("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*$', '') FROM %s", tableName));
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableName, location));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.computeActual("SELECT \"$path\" FROM " + tableName).getOnlyColumnAsSet()).as("active files after table recreated", new Object[0])).isEqualTo((Object)activeFiles);
    }

    private void testCountQuery(@Language(value="SQL") String sql, long expectedRowCount, long expectedSplitCount) {
        QueryRunner.MaterializedResultWithPlan result = this.getDistributedQueryRunner().executeWithPlan(this.getSession(), sql);
        Assertions.assertThat((Collection)result.result().getOnlyColumnAsSet()).isEqualTo((Object)ImmutableSet.of((Object)expectedRowCount));
        this.verifySplitCount(result.queryId(), expectedSplitCount);
    }

    private void verifySplitCount(QueryId queryId, long expectedCount) {
        OperatorStats operatorStats = this.getOperatorStats(queryId);
        Assertions.assertThat((long)operatorStats.getTotalDrivers()).isEqualTo(expectedCount);
    }

    private OperatorStats getOperatorStats(QueryId queryId) {
        return (OperatorStats)this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(queryId).getQueryStats().getOperatorSummaries().stream().filter(summary -> summary.getOperatorType().startsWith("Scan")).collect(MoreCollectors.onlyElement());
    }

    @Test
    public void testDelete() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE)) {
            Assumptions.abort((String)"testDelete requires DELETE support");
        }
        String tableName = "test_delete_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (location = '" + this.getLocationForTable(this.bucketName, tableName) + "') AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE orderkey % 2 = 0", "SELECT count(*) FROM orders WHERE orderkey % 2 = 0");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM orders WHERE orderkey % 2 <> 0");
        this.assertUpdate("DELETE FROM " + tableName, "SELECT count(*) FROM orders WHERE orderkey % 2 <> 0");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM orders LIMIT 0");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testOptimizeUsingForcedPartitioning() {
        String tableName = "test_optimize_partitioned_table_" + TestingNames.randomNameSuffix();
        String tableLocation = this.getLocationForTable(this.bucketName, tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " (key varchar, value1 integer, value2 varchar, value3 integer) WITH (location = '" + tableLocation + "', partitioned_by = ARRAY['key', 'value2', 'value3'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 1, 'test1', 9)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 2, 'test2', 9)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 3, 'test1', 9)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 4, 'test2', 9)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 5, 'test1', 9)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 6, 'test2', 9)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 7, 'test1', 9)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('two', 8, 'test1', 9)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('two', 9, 'test2', 9)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('three', 10, 'test1', 9)", 1L);
        Set<String> initialFiles = this.getActiveFiles(tableName);
        Assertions.assertThat(initialFiles).hasSize(10);
        this.computeActual("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(value1), listagg(key, ' ') WITHIN GROUP (ORDER BY key), listagg(value2, ' ') WITHIN GROUP (ORDER BY value2), sum(value3) FROM " + tableName))).matches("VALUES (BIGINT '55', VARCHAR 'one one one one one one one three two two', VARCHAR 'test1 test1 test1 test1 test1 test1 test2 test2 test2 test2', BIGINT '90')");
        Set<String> updatedFiles = this.getActiveFiles(tableName);
        Assertions.assertThat(updatedFiles).hasSize(5);
        Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
    }

    @Test
    public void testHistoryTable() {
        String tableName = "test_history_table_" + TestingNames.randomNameSuffix();
        try (TestTable table = this.newTrinoTable(tableName, "(int_col INTEGER)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 1, 2, 3", 3L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 4, 5, 6", 3L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE int_col = 1", 1L);
            this.assertUpdate("UPDATE " + table.getName() + " SET int_col = int_col * 2 WHERE int_col = 6", 1L);
            this.assertQuery("SELECT version, operation FROM \"" + table.getName() + "$history\"", "VALUES (0, 'CREATE TABLE'), (1, 'WRITE'), (2, 'WRITE'), (3, 'MERGE'), (4, 'MERGE')");
            this.assertQuery("SELECT version, operation FROM \"" + table.getName() + "$history\" WHERE version = 3", "VALUES (3, 'MERGE')");
            this.assertQuery("SELECT version, operation FROM \"" + table.getName() + "$history\" WHERE version > 3", "VALUES (4, 'MERGE')");
            this.assertQuery("SELECT version, operation FROM \"" + table.getName() + "$history\" WHERE version >= 3 OR version = 1", "VALUES (1, 'WRITE'), (3, 'MERGE'), (4, 'MERGE')");
            this.assertQuery("SELECT version, operation FROM \"" + table.getName() + "$history\" WHERE version >= 1 AND version < 3", "VALUES (1, 'WRITE'), (2, 'WRITE')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT version, operation FROM \"" + table.getName() + "$history\" WHERE version > 1 AND version < 2"))).returnsEmptyResult();
        }
    }

    @Test
    public void testHistoryTableWithDeletedTransactionLog() {
        try (TestTable table = this.newTrinoTable("test_history_table_with_deleted_transaction_log", "(int_col INTEGER) WITH (checkpoint_interval = 3)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 1, 2, 3", 3L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 4, 5, 6", 3L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE int_col = 1", 1L);
            this.assertUpdate("UPDATE " + table.getName() + " SET int_col = int_col * 2 WHERE int_col = 6", 1L);
            String tableLocation = this.getTableLocation(table.getName());
            this.deleteFile("%s/_delta_log/%020d.json".formatted(tableLocation, 0));
            this.deleteFile("%s/_delta_log/%020d.json".formatted(tableLocation, 1));
            this.assertQuery("SELECT version, operation FROM \"" + table.getName() + "$history\"", "VALUES (2, 'WRITE'), (3, 'MERGE'), (4, 'MERGE')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT version, operation FROM \"" + table.getName() + "$history\" WHERE version = 1"))).returnsEmptyResult();
            this.assertQuery("SELECT version, operation FROM \"" + table.getName() + "$history\" WHERE version = 3", "VALUES (3, 'MERGE')");
            this.assertQuery("SELECT version, operation FROM \"" + table.getName() + "$history\" WHERE version > 3", "VALUES (4, 'MERGE')");
            this.assertQuery("SELECT version, operation FROM \"" + table.getName() + "$history\" WHERE version < 3", "VALUES (2, 'WRITE')");
            this.assertQuery("SELECT version, operation FROM \"" + table.getName() + "$history\" WHERE version >= 3 OR version = 1", "VALUES (3, 'MERGE'), (4, 'MERGE')");
            this.assertQuery("SELECT version, operation FROM \"" + table.getName() + "$history\" WHERE version >= 1 AND version < 3", "VALUES (2, 'WRITE')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT version, operation FROM \"" + table.getName() + "$history\" WHERE version > 1 AND version < 2"))).returnsEmptyResult();
        }
    }

    @Test
    public void testRegisterTable() {
        String tableName = "test_register_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a INT, b VARCHAR, c BOOLEAN)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES(1, 'INDIA', true)", 1L);
        String tableLocation = this.getTableLocation(tableName);
        String showCreateTableOld = (String)this.computeScalar("SHOW CREATE TABLE " + tableName);
        this.metastore.dropTable(SCHEMA, tableName, false);
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => '" + tableName + "')");
        this.assertQueryFails("SELECT * FROM " + tableName, ".* Table '.*' does not exist");
        this.assertUpdate("CALL system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'INDIA', true)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES(2, 'POLAND', false)", 1L);
        String showCreateTableNew = (String)this.computeScalar("SHOW CREATE TABLE " + tableName);
        Assertions.assertThat((String)showCreateTableOld).isEqualTo(showCreateTableNew);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'INDIA', true), (2, 'POLAND', false)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testRegisterTableWithTrailingSpaceInLocation() {
        String tableName = "test_create_table_with_trailing_space_" + TestingNames.randomNameSuffix();
        String tableLocationWithTrailingSpace = this.bucketUrl() + tableName + " ";
        this.assertQuerySucceeds(String.format("CREATE TABLE %s WITH (location = '%s') AS SELECT 1 AS a, 'INDIA' AS b, true AS c", tableName, tableLocationWithTrailingSpace));
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'INDIA', true)");
        Assertions.assertThat((String)this.getTableLocation(tableName)).isEqualTo(tableLocationWithTrailingSpace);
        String registeredTableName = "test_register_table_with_trailing_space_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", registeredTableName, tableLocationWithTrailingSpace));
        this.assertQuery("SELECT * FROM " + registeredTableName, "VALUES (1, 'INDIA', true)");
        Assertions.assertThat((String)this.getTableLocation(registeredTableName)).isEqualTo(tableLocationWithTrailingSpace);
        this.assertUpdate("DROP TABLE " + registeredTableName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testUnregisterTable() {
        String tableName = "test_unregister_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 a", 1L);
        String tableLocation = this.getTableLocation(tableName);
        this.assertUpdate("CALL system.unregister_table(CURRENT_SCHEMA, '" + tableName + "')");
        this.assertQueryFails("SELECT * FROM " + tableName, ".* Table .* does not exist");
        this.assertUpdate("CALL system.register_table(CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testUnregisterBrokenTable() {
        String tableName = "test_unregister_broken_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 a", 1L);
        String tableLocation = this.getTableLocation(tableName);
        String directory = tableLocation.substring(this.bucketUrl().length());
        for (String file : this.listFiles(directory)) {
            this.deleteFile(file);
        }
        this.assertUpdate("CALL system.unregister_table(CURRENT_SCHEMA, '" + tableName + "')");
        this.assertQueryFails("SELECT * FROM " + tableName, ".* Table .* does not exist");
    }

    @Test
    public void testUnregisterNonDeltaLakeTable() {
        String tableName = "test_unregister_non_delta_lake_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE hive.smoke_test." + tableName + " AS SELECT 1 a", 1L);
        this.assertQueryFails("CALL system.unregister_table(CURRENT_SCHEMA, '" + tableName + "')", ".*not a Delta Lake table");
        this.assertUpdate("DROP TABLE hive.smoke_test." + tableName);
    }

    @Test
    public void testUnregisterTableNotExistingSchema() {
        String schemaName = "test_unregister_table_not_existing_schema_" + TestingNames.randomNameSuffix();
        this.assertQueryFails("CALL system.unregister_table('" + schemaName + "', 'non_existent_table')", "Table \\Q'" + schemaName + ".non_existent_table' not found");
    }

    @Test
    public void testUnregisterTableNotExistingTable() {
        String tableName = "test_unregister_table_not_existing_table_" + TestingNames.randomNameSuffix();
        this.assertQueryFails("CALL system.unregister_table(CURRENT_SCHEMA, '" + tableName + "')", "Table .* not found");
    }

    @Test
    public void testRepeatUnregisterTable() {
        String tableName = "test_repeat_unregister_table_not_" + TestingNames.randomNameSuffix();
        this.assertQueryFails("CALL system.unregister_table(CURRENT_SCHEMA, '" + tableName + "')", "Table .* not found");
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 a", 1L);
        String tableLocation = this.getTableLocation(tableName);
        this.assertUpdate("CALL system.unregister_table(CURRENT_SCHEMA, '" + tableName + "')");
        this.assertQueryFails("CALL system.unregister_table(CURRENT_SCHEMA, '" + tableName + "')", "Table .* not found");
        this.assertUpdate("CALL system.register_table(CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testUnregisterTableAccessControl() {
        String tableName = "test_unregister_table_access_control_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 a", 1L);
        this.assertAccessDenied("CALL system.unregister_table(CURRENT_SCHEMA, '" + tableName + "')", "Cannot drop table .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DROP_TABLE)});
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testProjectionPushdownMultipleRows() {
        String tableName = "test_projection_pushdown_multiple_rows_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id BIGINT, nested1 ROW(child1 BIGINT, child2 VARCHAR, child3 INT), nested2 ROW(child1 DOUBLE, child2 BOOLEAN, child3 DATE))");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (100, ROW(10, 'a', 100), ROW(10.10, true, DATE '2023-04-19')), (3, ROW(30, 'to_be_deleted', 300), ROW(30.30, false, DATE '2000-04-16')), (2, ROW(20, 'b', 200), ROW(20.20, false, DATE '1990-04-20')), (4, ROW(40, NULL, 400), NULL), (5, NULL, ROW(NULL, true, NULL))", 5L);
        this.assertUpdate("UPDATE " + tableName + " SET id = 1 WHERE nested2.child3 = DATE '2023-04-19'", 1L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE nested1.child1 = 30 AND nested2.child2 = false", 1L);
        this.assertQuery("SELECT id, nested1.child1 FROM " + tableName, "VALUES (1, 10), (2, 20), (4, 40), (5, NULL)");
        this.assertQuery("SELECT nested2.child3, id FROM " + tableName, "VALUES (DATE '2023-04-19', 1), (DATE '1990-04-20', 2), (NULL, 4), (NULL, 5)");
        this.assertQuery("SELECT nested2.child1, id, nested1.child2 FROM " + tableName, "VALUES (10.10, 1, 'a'), (20.20, 2, 'b'), (NULL, 4, NULL), (NULL, 5, NULL)");
        this.assertQuery("SELECT nested1.child3, id, nested1.child2 FROM " + tableName, "VALUES (100, 1, 'a'), (200, 2, 'b'), (400, 4, NULL), (NULL, 5, NULL)");
        this.assertQuery("SELECT nested2.child2, nested2.child3, id FROM " + tableName, "VALUES (true, DATE '2023-04-19' , 1), (false, DATE '1990-04-20', 2), (NULL, NULL, 4), (true, NULL, 5)");
        this.assertQuery("SELECT id, nested2.child1, nested1.child3, nested2.child2, nested1.child1 FROM " + tableName, "VALUES (1, 10.10, 100, true, 10), (2, 20.20, 200, false, 20), (4, NULL, 400, NULL, 40), (5, NULL, NULL, true, NULL)");
        this.assertQuery("SELECT nested2.child2, nested1.child3 FROM " + tableName, "VALUES (true, 100), (false, 200), (NULL, 400), (true, NULL)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPartitionFilterIncluded() {
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "query_partition_filter_required", "true").build();
        try (TestTable table = this.newTrinoTable("test_no_partition_filter", "(x varchar, part varchar) WITH (PARTITIONED_BY = ARRAY['part'])", (List)ImmutableList.of((Object)"'a', 'part_a'", (Object)"'b', 'part_b'"));){
            this.assertQueryFails(session, "SELECT * FROM %s WHERE x='a'".formatted(table.getName()), "Filter required on .*" + table.getName() + " for at least one partition column:.*");
            this.assertQuery(session, "SELECT * FROM %s WHERE part='part_a'".formatted(table.getName()), "VALUES ('a', 'part_a')");
        }
    }

    @Test
    public void testCreateOrReplaceTable() {
        try (TestTable table = this.newTrinoTable("test_table", " AS SELECT BIGINT '42' a, DOUBLE '-38.5' b");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(a AS bigint), b FROM " + table.getName()))).matches("VALUES (BIGINT '42', -385e-1)");
            this.assertUpdate("CREATE OR REPLACE TABLE %s (a bigint, b double)".formatted(table.getName()));
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + table.getName());
            this.assertTableVersion(table.getName(), 1L);
            this.assertTableOperation(table.getName(), 1L, "CREATE OR REPLACE TABLE");
        }
    }

    @Test
    public void testCreateOrReplaceTableAs() {
        try (TestTable table = this.newTrinoTable("test_table", " AS SELECT BIGINT '42' a, DOUBLE '-38.5' b");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(a AS bigint), b FROM " + table.getName()))).matches("VALUES (BIGINT '42', -385e-1)");
            this.assertUpdate("CREATE OR REPLACE TABLE %s AS SELECT BIGINT '-53' a, DOUBLE '49.6' b".formatted(table.getName()), 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(a AS bigint), b FROM " + table.getName()))).matches("VALUES (BIGINT '-53', 496e-1)");
            this.assertTableVersion(table.getName(), 1L);
            this.assertTableOperation(table.getName(), 1L, "CREATE OR REPLACE TABLE AS SELECT");
        }
    }

    @Test
    public void testCreateOrReplaceTableChangeColumnNamesAndTypes() {
        try (TestTable table = this.newTrinoTable("test_table", " AS SELECT BIGINT '42' a, DOUBLE '-38.5' b");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(a AS bigint), b FROM " + table.getName()))).matches("VALUES (BIGINT '42', -385e-1)");
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " AS SELECT VARCHAR 'test' c, VARCHAR 'test2' d", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT c, d FROM " + table.getName()))).matches("VALUES (VARCHAR 'test', VARCHAR 'test2')");
            this.assertTableVersion(table.getName(), 1L);
            this.assertTableOperation(table.getName(), 1L, "CREATE OR REPLACE TABLE AS SELECT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    public void testCreateOrReplaceTableConcurrently() throws Exception {
        int threads = 4;
        int numOfCreateOrReplaceStatements = 4;
        int numOfReads = 16;
        CyclicBarrier barrier = new CyclicBarrier(threads + 1);
        ExecutorService executor = Executors.newFixedThreadPool(threads + 1);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        try (TestTable table = this.newTrinoTable("test_create_or_replace", "(col integer)");){
            String tableName = table.getName();
            this.getQueryRunner().execute("CREATE OR REPLACE TABLE " + tableName + " AS SELECT 1 a");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES 1");
            futures.add(executor.submit(() -> {
                barrier.await(30L, TimeUnit.SECONDS);
                IntStream.range(0, numOfCreateOrReplaceStatements).forEach(index -> {
                    try {
                        this.getQueryRunner().execute("CREATE OR REPLACE TABLE " + tableName + " AS SELECT * FROM (VALUES (1), (2)) AS t(a) ");
                    }
                    catch (Exception e) {
                        RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause((Throwable)e);
                        try {
                            throw new AssertionError("Unexpected concurrent CREATE OR REPLACE failure", trinoException);
                        }
                        catch (Throwable verifyFailure) {
                            if (verifyFailure != e) {
                                verifyFailure.addSuppressed(e);
                            }
                            throw verifyFailure;
                        }
                    }
                });
                return null;
            }));
            IntStream.range(0, threads).forEach(threadNumber -> futures.add(executor.submit(() -> {
                barrier.await(30L, TimeUnit.SECONDS);
                IntStream.range(0, numOfReads).forEach(readIndex -> {
                    try {
                        MaterializedResult result = this.computeActual("SELECT * FROM " + tableName);
                        if (result.getRowCount() == 1) {
                            QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), List.of(new MaterializedRow(List.of(Integer.valueOf(1)))));
                        } else {
                            QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), List.of(new MaterializedRow(List.of(Integer.valueOf(1))), new MaterializedRow(List.of(Integer.valueOf(2)))));
                        }
                    }
                    catch (Exception e) {
                        RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause((Throwable)e);
                        try {
                            throw new AssertionError("Unexpected concurrent CREATE OR REPLACE failure", trinoException);
                        }
                        catch (Throwable verifyFailure) {
                            if (verifyFailure != e) {
                                verifyFailure.addSuppressed(e);
                            }
                            throw verifyFailure;
                        }
                    }
                });
                return null;
            })));
            futures.forEach(Futures::getUnchecked);
            this.getQueryRunner().execute("CREATE OR REPLACE TABLE " + tableName + " AS SELECT * FROM (VALUES (1), (2), (3)) AS t(a)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES 1, 2, 3");
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    private void assertTableVersion(String tableName, long version) {
        Assertions.assertThat((Object)this.computeScalar(String.format("SELECT max(version) FROM \"%s$history\"", tableName))).isEqualTo((Object)version);
    }

    private void assertTableOperation(String tableName, long version, String operation) {
        this.assertQuery("SELECT operation FROM \"%s$history\" WHERE version = %s".formatted(tableName, version), "VALUES '%s'".formatted(operation));
    }

    @RepeatedTest(value=3)
    public void testConcurrentInsertsReconciliationForBlindInserts() throws Exception {
        this.testConcurrentInsertsReconciliationForBlindInserts(false);
        this.testConcurrentInsertsReconciliationForBlindInserts(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentInsertsReconciliationForBlindInserts(boolean partitioned) throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_inserts_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a INT, part INT) " + (partitioned ? " WITH (partitioned_by = ARRAY['part'])" : ""));
        try {
            executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (1, 10)");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (11, 20)");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (21, 30)");
                return null;
            }).build()).forEach(MoreFutures::getDone);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (1, 10), (11, 20), (21, 30)");
            this.assertQuery("SELECT version, operation, isolation_level, read_version FROM \"" + tableName + "$history\"", "VALUES\n    (0, 'CREATE TABLE', 'WriteSerializable', 0),\n    (1, 'WRITE', 'WriteSerializable', 0),\n    (2, 'WRITE', 'WriteSerializable', 1),\n    (3, 'WRITE', 'WriteSerializable', 2)\n");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    @RepeatedTest(value=3)
    public void testConcurrentInsertsSelectingFromTheSameTable() throws Exception {
        this.testConcurrentInsertsSelectingFromTheSameTable(true);
        this.testConcurrentInsertsSelectingFromTheSameTable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentInsertsSelectingFromTheSameTable(boolean partitioned) throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_inserts_select_from_same_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part) " + (partitioned ? " WITH (partitioned_by = ARRAY['part'])" : "") + "  AS VALUES (0, 10)", 1L);
        try {
            List futures = (List)IntStream.range(0, threads).mapToObj(threadNumber -> executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                try {
                    this.getQueryRunner().execute("INSERT INTO " + tableName + " SELECT COUNT(*), 10 AS part FROM " + tableName);
                    return true;
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause((Throwable)e);
                    try {
                        Assertions.assertThat((Throwable)trinoException).hasMessage("Failed to write Delta Lake transaction log entry");
                    }
                    catch (Throwable verifyFailure) {
                        if (verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return false;
                }
            })).collect(ImmutableList.toImmutableList());
            long successfulInsertsCount = futures.stream().map(MoreFutures::getFutureValue).filter(success -> success).count();
            Assertions.assertThat((long)successfulInsertsCount).isGreaterThanOrEqualTo(1L);
            String string = "(%d, 10)";
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (0, 10)" + LongStream.rangeClosed(1L, successfulInsertsCount).boxed().map(arg_0 -> BaseDeltaLakeConnectorSmokeTest.lambda$testConcurrentInsertsSelectingFromTheSameTable$3("(%d, 10)", arg_0)).collect(Collectors.joining(", ", ", ", "")));
            this.assertQuery("SELECT version, operation, isolation_level, read_version, is_blind_append FROM \"" + tableName + "$history\"", "VALUES (0, 'CREATE TABLE AS SELECT', 'WriteSerializable', 0, true)" + LongStream.rangeClosed(1L, successfulInsertsCount).boxed().map(version -> "(%s, 'WRITE', 'WriteSerializable', %s, false)".formatted(version, version - 1L)).collect(Collectors.joining(", ", ", ", "")));
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    public void testConcurrentInsertsReconciliationForMixedInserts() throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_mixed_inserts_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part) WITH (partitioned_by = ARRAY['part']) AS VALUES (0, 10), (11, 20)", 2L);
        try {
            executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " SELECT COUNT(*) AS a, 10 AS part FROM " + tableName + " WHERE part = 10");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " SELECT COUNT(*) AS a, 20 AS part FROM " + tableName + " WHERE part = 20");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (22, 30)");
                return null;
            }).build()).forEach(MoreFutures::getDone);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (0, 10), (1, 10), (11, 20), (1, 20), (22, 30)");
            this.assertQuery("SELECT operation, isolation_level, is_blind_append FROM \"" + tableName + "$history\"", "VALUES\n    ('CREATE TABLE AS SELECT', 'WriteSerializable', true),\n    ('WRITE', 'WriteSerializable', false),\n    ('WRITE', 'WriteSerializable', false),\n    ('WRITE', 'WriteSerializable', true)\n");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    public void testConcurrentDeletePushdownReconciliation() throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_inserts_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part)  WITH (partitioned_by = ARRAY['part']) AS VALUES (1, 10), (11, 20), (21, 30), (31, 40)", 4L);
        try {
            executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("DELETE FROM " + tableName + " WHERE part = 10");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("DELETE FROM " + tableName + " WHERE part = 20");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("DELETE FROM " + tableName + " WHERE part = 30");
                return null;
            }).build()).forEach(MoreFutures::getDone);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (31, 40)");
            this.assertQuery("SELECT version, operation, isolation_level FROM \"" + tableName + "$history\"", "VALUES\n    (0, 'CREATE TABLE AS SELECT', 'WriteSerializable'),\n    (1, 'DELETE', 'WriteSerializable'),\n    (2, 'DELETE', 'WriteSerializable'),\n    (3, 'DELETE', 'WriteSerializable')\n");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    public void testConcurrentMergeReconciliation() throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_merges_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part)  WITH (partitioned_by = ARRAY['part']) AS VALUES (1, 10), (11, 20), (21, 30), (31, 40)", 4L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (22, 30)", 1L);
        try {
            executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("MERGE INTO %s t USING (VALUES (12, 20)) AS s(a, part)\n  ON (FALSE)\n    WHEN NOT MATCHED THEN INSERT (a, part) VALUES(s.a, s.part)\n".formatted(tableName));
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("MERGE INTO %s t USING (VALUES (21, 30)) AS s(a, part)\n  ON (t.part = s.part)\n    WHEN MATCHED THEN DELETE\n".formatted(tableName));
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("MERGE INTO %s t USING (VALUES (32, 40)) AS s(a, part)\n  ON (t.part = s.part)\n    WHEN MATCHED THEN UPDATE SET a = s.a\n".formatted(tableName));
                return null;
            }).build()).forEach(MoreFutures::getDone);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (1, 10), (11, 20), (12, 20), (32, 40)");
            this.assertQuery("SELECT operation, isolation_level, is_blind_append FROM \"" + tableName + "$history\"", "VALUES\n    ('CREATE TABLE AS SELECT', 'WriteSerializable', true),\n    ('WRITE', 'WriteSerializable', true),\n    ('MERGE', 'WriteSerializable', true),\n    ('MERGE', 'WriteSerializable', false),\n    ('MERGE', 'WriteSerializable', false)\n");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    protected List<String> listCheckpointFiles(String transactionLogDirectory) {
        return (List)this.listFiles(transactionLogDirectory).stream().filter(path -> path.contains("checkpoint.parquet")).collect(ImmutableList.toImmutableList());
    }

    private Set<String> getActiveFiles(String tableName) {
        return this.getActiveFiles(tableName, this.getQueryRunner().getDefaultSession());
    }

    private Set<String> getActiveFiles(String tableName, Session session) {
        return (Set)this.computeActual(session, "SELECT DISTINCT \"$path\" FROM " + tableName).getOnlyColumnAsSet().stream().map(String.class::cast).collect(ImmutableSet.toImmutableSet());
    }

    private Set<String> getAllDataFilesFromTableDirectory(String tableName) {
        return (Set)this.getTableFiles(tableName).stream().filter(path -> !path.contains("/_delta_log")).collect(ImmutableSet.toImmutableSet());
    }

    private Session broadcastJoinDistribution(boolean dynamicFilteringEnabled) {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("enable_dynamic_filtering", Boolean.toString(dynamicFilteringEnabled)).build();
    }

    private String getTableLocation(String tableName) {
        Pattern locationPattern = Pattern.compile(".*location = '(.*?)'.*", 32);
        Matcher m = locationPattern.matcher((String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue());
        if (m.find()) {
            String location = m.group(1);
            Verify.verify((!m.find() ? 1 : 0) != 0, (String)"Unexpected second match", (Object[])new Object[0]);
            return location;
        }
        throw new IllegalStateException("Location not found in SHOW CREATE TABLE result");
    }

    private static Session disableStatisticsCollectionOnWrite(Session session) {
        return Session.builder((Session)session).setCatalogSessionProperty((String)session.getCatalog().orElseThrow(), "extended_statistics_collect_on_write", "false").build();
    }

    private static /* synthetic */ String lambda$testConcurrentInsertsSelectingFromTheSameTable$3(String rec$, Object xva$0) {
        return "(%d, 10)".formatted(xva$0);
    }
}

