/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Verify;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.plugin.deltalake.TestingDeltaLakeUtils;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class BaseDeltaLakeRegisterTableProcedureTest
extends AbstractTestQueryFramework {
    @Test
    public void testRegisterTable() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String tableName = "test_register_table_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + " AS SELECT 1 as a, 'INDIA' as b, true as c");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'INDIA', true)");
        String tableLocation = this.getTableLocation(tableName);
        String showCreateTableOld = (String)this.computeScalar("SHOW CREATE TABLE " + tableName);
        this.metastore().dropTable(schema, tableName, false);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        this.assertQuerySucceeds(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableName, tableLocation));
        String showCreateTableNew = (String)this.computeScalar("SHOW CREATE TABLE " + tableName);
        Assertions.assertThat((String)showCreateTableOld).isEqualTo(showCreateTableNew);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'INDIA', true)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testRegisterPartitionedTable() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String tableName = "test_register_partitioned_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH(partitioned_by = ARRAY['part']) AS SELECT 1 AS data, 'a' AS part", 1L);
        String tableLocation = this.getTableLocation(tableName);
        this.metastore().dropTable(schema, tableName, false);
        this.assertUpdate(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableName, tableLocation));
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + tableName))).contains(new CharSequence[]{"partitioned_by = ARRAY['part']"});
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'a')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testRegisterTableWithComments() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String tableName = "test_register_table_with_comments_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + " (a, b, c) COMMENT 'my-table-comment' AS VALUES (1, 'INDIA', true)");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'INDIA', true)");
        String tableLocation = this.getTableLocation(tableName);
        this.metastore().dropTable(schema, tableName, false);
        this.assertQuerySucceeds("CALL system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')");
        Assertions.assertThat((String)this.getTableComment(tableName)).isEqualTo("my-table-comment");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testRegisterTableWithDifferentTableName() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String tableName = "test_register_table_with_different_table_name_old_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + " AS SELECT 1 as a, 'INDIA' as b, true as c");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'INDIA', true)");
        String showCreateTableOld = (String)this.computeScalar("SHOW CREATE TABLE " + tableName);
        String tableLocation = this.getTableLocation(tableName);
        this.metastore().dropTable(schema, tableName, false);
        String tableNameNew = "test_register_table_with_different_table_name_new_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableNameNew, tableLocation));
        String showCreateTableNew = (String)this.computeScalar("SHOW CREATE TABLE " + tableNameNew);
        Assertions.assertThat((String)showCreateTableOld).isEqualTo(showCreateTableNew.replaceFirst(tableNameNew, tableName));
        this.assertQuery("SELECT * FROM " + tableNameNew, "VALUES (1, 'INDIA', true)");
        this.assertUpdate(String.format("DROP TABLE %s", tableNameNew));
    }

    @Test
    public void testRegisterTableWithTrailingSpaceInLocation() {
        String tableName = "test_register_table_with_trailing_space_" + TestingNames.randomNameSuffix();
        String tableLocationWithTrailingSpace = "local:///" + tableName + " ";
        this.assertQuerySucceeds(String.format("CREATE TABLE %s WITH (location = '%s') AS SELECT 1 AS a, 'INDIA' AS b, true AS c", tableName, tableLocationWithTrailingSpace));
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'INDIA', true)");
        Assertions.assertThat((String)this.getTableLocation(tableName)).isEqualTo(tableLocationWithTrailingSpace);
        String registeredTableName = "test_register_table_with_trailing_space_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", registeredTableName, tableLocationWithTrailingSpace));
        this.assertQuery("SELECT * FROM " + registeredTableName, "VALUES (1, 'INDIA', true)");
        Assertions.assertThat((String)this.getTableLocation(registeredTableName)).isEqualTo(tableLocationWithTrailingSpace);
        this.assertUpdate("DROP TABLE " + registeredTableName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testRegisterEmptyTable() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String tableName = "test_register_table_with_no_data_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + "(a INT, b VARCHAR, c BOOLEAN)");
        String tableLocation = this.getTableLocation(tableName);
        this.metastore().dropTable(schema, tableName, false);
        this.assertQuerySucceeds(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableName, tableLocation));
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @Test
    public void testRegisterTableWithInvalidDeltaTable() throws Exception {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String tableName = "test_register_table_with_no_transaction_log_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + " AS SELECT 1 as a, 'INDIA' as b, true as c");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'INDIA', true)");
        String tableLocation = this.getTableLocation(tableName);
        String tableNameNew = "test_register_table_with_no_transaction_log_new_" + TestingNames.randomNameSuffix();
        QueryRunner queryRunner = this.getQueryRunner();
        TrinoFileSystem fileSystem = TestingDeltaLakeUtils.getConnectorService(queryRunner, TrinoFileSystemFactory.class).create(ConnectorIdentity.ofUser((String)"test"));
        fileSystem.deleteDirectory(Location.of((String)tableLocation));
        fileSystem.newOutputFile(TransactionLogUtil.getTransactionLogJsonEntryPath((String)TransactionLogUtil.getTransactionLogDir((String)tableLocation), (long)0L)).create().close();
        this.assertQueryFails(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableNameNew, tableLocation), ".*Metadata not found in transaction log for (.*)");
        fileSystem.deleteDirectory(Location.of((String)tableLocation));
        this.metastore().dropTable(schema, tableName, false);
    }

    @Test
    public void testRegisterTableWithNoTransactionLog() throws Exception {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String tableName = "test_register_table_with_no_transaction_log_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + " AS SELECT 1 as a, 'INDIA' as b, true as c");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'INDIA', true)");
        String tableLocation = this.getTableLocation(tableName);
        String tableNameNew = "test_register_table_with_no_transaction_log_new_" + TestingNames.randomNameSuffix();
        QueryRunner queryRunner = this.getQueryRunner();
        TrinoFileSystem fileSystem = TestingDeltaLakeUtils.getConnectorService(queryRunner, TrinoFileSystemFactory.class).create(ConnectorIdentity.ofUser((String)"test"));
        fileSystem.deleteDirectory(Location.of((String)tableLocation));
        this.assertQueryFails(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableNameNew, tableLocation), ".*No transaction log found in location (.*)");
        fileSystem.deleteDirectory(Location.of((String)tableLocation));
        this.metastore().dropTable(schema, tableName, false);
    }

    @Test
    public void testRegisterTableWithNonExistingTableLocation() {
        String tableName = "test_register_table_with_non_existing_table_location_" + TestingNames.randomNameSuffix();
        String tableLocation = "/test/delta-lake/hive/warehouse/orders_5-581fad8517934af6be1857a903559d44";
        this.assertQueryFails(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableName, tableLocation), ".*No transaction log found in location (.*).*");
    }

    @Test
    public void testRegisterTableWithNonExistingSchema() {
        String tableLocation = "/test/delta-lake/hive/warehouse/orders_5-581fad8517934af6be1857a903559d44";
        this.assertQueryFails(String.format("CALL system.register_table('nonexistentschema', '%s', '%s')", "delta_table_1", tableLocation), "Schema (.*) not found");
    }

    @Test
    public void testRegisterTableWithExistingTable() {
        String tableName = "test_register_table_with_existing_table_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + " AS SELECT 1 as a, 'INDIA' as b, true as c");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'INDIA', true)");
        String tableLocation = this.getTableLocation(tableName);
        this.assertQueryFails(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableName, tableLocation), ".*Table already exists: '(.*)'.*");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testRegisterTableWithInvalidUriScheme() {
        String tableName = "test_register_table_with_invalid_uri_scheme_" + TestingNames.randomNameSuffix();
        String tableLocation = "invalid://hadoop-master:9000/test/delta-lake/hive/orders_5-581fad8517934af6be1857a903559d44";
        this.assertQueryFails(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableName, tableLocation), ".*Failed checking table location (.*)");
    }

    @Test
    public void testRegisterTableWithInvalidParameter() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String tableName = "test_register_table_with_invalid_parameter_" + TestingNames.randomNameSuffix();
        String tableLocation = "/test/delta-lake/hive/table1/";
        this.assertQueryFails(String.format("CALL system.register_table('%s', '%s')", schema, tableName), ".*'TABLE_LOCATION' is missing.*");
        this.assertQueryFails(String.format("CALL system.register_table('%s')", schema), ".*'TABLE_NAME' is missing.*");
        this.assertQueryFails("CALL system.register_table()", ".*'SCHEMA_NAME' is missing.*");
        this.assertQueryFails(String.format("CALL system.register_table(NULL, '%s', '%s')", tableName, tableLocation), ".*schema_name cannot be null or empty.*");
        this.assertQueryFails(String.format("CALL system.register_table('%s', NULL, '%s')", schema, tableLocation), ".*table_name cannot be null or empty.*");
        this.assertQueryFails(String.format("CALL system.register_table('%s', '%s', NULL)", schema, tableName), ".*table_location cannot be null or empty.*");
        this.assertQueryFails(String.format("CALL system.register_table('', '%s', '%s')", tableName, tableLocation), ".*schema_name cannot be null or empty.*");
        this.assertQueryFails(String.format("CALL system.register_table('%s', '', '%s')", schema, tableLocation), ".*table_name cannot be null or empty.*");
        this.assertQueryFails(String.format("CALL system.register_table('%s', '%s', '')", schema, tableName), ".*table_location cannot be null or empty.*");
    }

    @Test
    public void testRegisterUnregisteredTable() {
        String tableName = "test_unregister_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 a", 1L);
        String tableLocation = this.getTableLocation(tableName);
        this.assertUpdate("CALL system.unregister_table(CURRENT_SCHEMA, '" + tableName + "')");
        this.assertQueryFails("SELECT * FROM " + tableName, ".* Table .* does not exist");
        this.assertUpdate("CALL system.register_table(CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    protected String getTableLocation(String tableName) {
        Pattern locationPattern = Pattern.compile(".*location = '(.*?)'.*", 32);
        Matcher m = locationPattern.matcher((String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue());
        if (m.find()) {
            String location = m.group(1);
            Verify.verify((!m.find() ? 1 : 0) != 0, (String)"Unexpected second match", (Object[])new Object[0]);
            return location;
        }
        throw new IllegalStateException("Location not found in SHOW CREATE TABLE result");
    }

    protected HiveMetastore metastore() {
        return TestingDeltaLakeUtils.getConnectorService(this.getQueryRunner(), HiveMetastoreFactory.class).createMetastore(Optional.empty());
    }
}

