/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.Session;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.deltalake.TestingDeltaLakePlugin;
import io.trino.plugin.deltalake.metastore.TestingDeltaLakeMetastoreModule;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.spi.Plugin;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class BaseDeltaLakeSharedMetastoreViewsTest
extends AbstractTestQueryFramework {
    protected static final String DELTA_CATALOG_NAME = "delta_lake";
    protected static final String HIVE_CATALOG_NAME = "hive";
    protected static final String SCHEMA = "test_shared_schema_views_" + TestingNames.randomNameSuffix();
    private Path dataDirectory;
    private HiveMetastore metastore;

    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setCatalog(DELTA_CATALOG_NAME).setSchema(SCHEMA).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).build();
        this.dataDirectory = queryRunner.getCoordinator().getBaseDataDir().resolve("shared_data");
        this.metastore = this.createTestMetastore(this.dataDirectory);
        queryRunner.installPlugin((Plugin)new TestingDeltaLakePlugin(this.dataDirectory, Optional.of(new TestingDeltaLakeMetastoreModule(this.metastore))));
        queryRunner.createCatalog(DELTA_CATALOG_NAME, DELTA_CATALOG_NAME, (Map)ImmutableMap.of((Object)"fs.hadoop.enabled", (Object)"true"));
        queryRunner.installPlugin((Plugin)new TestingHivePlugin(this.dataDirectory, this.metastore));
        queryRunner.createCatalog(HIVE_CATALOG_NAME, HIVE_CATALOG_NAME, (Map)ImmutableMap.of((Object)"fs.hadoop.enabled", (Object)"true"));
        queryRunner.execute("CREATE SCHEMA " + SCHEMA);
        return queryRunner;
    }

    protected abstract HiveMetastore createTestMetastore(Path var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testViewWithLiteralColumnCreatedInDeltaLakeIsReadableInHive() {
        String deltaViewName = "delta_view_" + TestingNames.randomNameSuffix();
        String deltaView = String.format("%s.%s.%s", DELTA_CATALOG_NAME, SCHEMA, deltaViewName);
        String deltaViewOnHiveCatalog = String.format("%s.%s.%s", HIVE_CATALOG_NAME, SCHEMA, deltaViewName);
        try {
            this.assertUpdate(String.format("CREATE VIEW %s AS SELECT 1 bee", deltaView));
            this.assertQuery(String.format("SELECT * FROM %s", deltaView), "VALUES 1");
            this.assertQuery(String.format("SELECT * FROM %s", deltaViewOnHiveCatalog), "VALUES 1");
            this.assertQuery(String.format("SELECT table_type FROM %s.information_schema.tables WHERE table_name = '%s' AND table_schema='%s'", HIVE_CATALOG_NAME, deltaViewName, SCHEMA), "VALUES 'VIEW'");
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP VIEW IF EXISTS %s", deltaView));
            throw throwable;
        }
        this.assertUpdate(String.format("DROP VIEW IF EXISTS %s", deltaView));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testViewOnDeltaLakeTableCreatedInDeltaLakeIsReadableInHive() {
        String deltaTableName = "delta_table_" + TestingNames.randomNameSuffix();
        String deltaTable = String.format("%s.%s.%s", DELTA_CATALOG_NAME, SCHEMA, deltaTableName);
        String deltaViewName = "delta_view_" + TestingNames.randomNameSuffix();
        String deltaView = String.format("%s.%s.%s", DELTA_CATALOG_NAME, SCHEMA, deltaViewName);
        String deltaViewOnHiveCatalog = String.format("%s.%s.%s", HIVE_CATALOG_NAME, SCHEMA, deltaViewName);
        try {
            this.assertUpdate(String.format("CREATE TABLE %s AS SELECT 1 bee", deltaTable), 1L);
            this.assertUpdate(String.format("CREATE VIEW %s AS SELECT * from %s", deltaView, deltaTable));
            this.assertQuery(String.format("SELECT * FROM %s", deltaView), "VALUES 1");
            this.assertQuery(String.format("SELECT * FROM %s", deltaViewOnHiveCatalog), "VALUES 1");
            this.assertQuery(String.format("SELECT table_type FROM %s.information_schema.tables WHERE table_name = '%s' AND table_schema='%s'", HIVE_CATALOG_NAME, deltaViewName, SCHEMA), "VALUES 'VIEW'");
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP TABLE IF EXISTS %s", deltaTable));
            this.assertUpdate(String.format("DROP VIEW IF EXISTS %s", deltaView));
            throw throwable;
        }
        this.assertUpdate(String.format("DROP TABLE IF EXISTS %s", deltaTable));
        this.assertUpdate(String.format("DROP VIEW IF EXISTS %s", deltaView));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testViewWithLiteralColumnCreatedInHiveIsReadableInDeltaLake() {
        String trinoViewOnHiveName = "trino_view_on_hive_" + TestingNames.randomNameSuffix();
        String trinoViewOnHive = String.format("%s.%s.%s", HIVE_CATALOG_NAME, SCHEMA, trinoViewOnHiveName);
        String trinoViewOnHiveOnDeltaCatalog = String.format("%s.%s.%s", DELTA_CATALOG_NAME, SCHEMA, trinoViewOnHiveName);
        try {
            this.assertUpdate(String.format("CREATE VIEW %s AS SELECT 1 bee", trinoViewOnHive));
            this.assertQuery(String.format("SELECT * FROM %s", trinoViewOnHive), "VALUES 1");
            this.assertQuery(String.format("SELECT * FROM %s", trinoViewOnHiveOnDeltaCatalog), "VALUES 1");
            this.assertQuery(String.format("SELECT table_type FROM %s.information_schema.tables WHERE table_name = '%s' AND table_schema='%s'", HIVE_CATALOG_NAME, trinoViewOnHiveName, SCHEMA), "VALUES 'VIEW'");
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP VIEW IF EXISTS %s", trinoViewOnHive));
            throw throwable;
        }
        this.assertUpdate(String.format("DROP VIEW IF EXISTS %s", trinoViewOnHive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testViewOnHiveTableCreatedInHiveIsReadableInDeltaLake() {
        String hiveTableName = "hive_table_" + TestingNames.randomNameSuffix();
        String hiveTable = String.format("%s.%s.%s", HIVE_CATALOG_NAME, SCHEMA, hiveTableName);
        String trinoViewOnHiveName = "trino_view_on_hive_" + TestingNames.randomNameSuffix();
        String trinoViewOnHive = String.format("%s.%s.%s", HIVE_CATALOG_NAME, SCHEMA, trinoViewOnHiveName);
        String trinoViewOnHiveOnDeltaCatalog = String.format("%s.%s.%s", DELTA_CATALOG_NAME, SCHEMA, trinoViewOnHiveName);
        try {
            this.assertUpdate(String.format("CREATE TABLE %s AS SELECT 1 bee", hiveTable), 1L);
            this.assertUpdate(String.format("CREATE VIEW %s AS SELECT 1 bee", trinoViewOnHive));
            this.assertQuery(String.format("SELECT * FROM %s", trinoViewOnHive), "VALUES 1");
            this.assertQuery(String.format("SELECT * FROM %s", trinoViewOnHiveOnDeltaCatalog), "VALUES 1");
            this.assertQuery(String.format("SELECT table_type FROM %s.information_schema.tables WHERE table_name = '%s' AND table_schema='%s'", DELTA_CATALOG_NAME, trinoViewOnHiveName, SCHEMA), "VALUES 'VIEW'");
            this.assertQuery(String.format("SELECT table_name FROM %s.information_schema.columns WHERE table_name = '%s' AND table_schema='%s'", DELTA_CATALOG_NAME, trinoViewOnHiveName, SCHEMA), "VALUES '" + trinoViewOnHiveName + "'");
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP TABLE IF EXISTS %s", hiveTable));
            this.assertUpdate(String.format("DROP VIEW IF EXISTS %s", trinoViewOnHive));
            throw throwable;
        }
        this.assertUpdate(String.format("DROP TABLE IF EXISTS %s", hiveTable));
        this.assertUpdate(String.format("DROP VIEW IF EXISTS %s", trinoViewOnHive));
    }

    @Test
    public void testNonDeltaTablesCannotBeAccessed() {
        String schemaName = "test_schema" + TestingNames.randomNameSuffix();
        String tableName = "hive_table";
        this.assertUpdate("CREATE SCHEMA %s.%s".formatted(HIVE_CATALOG_NAME, schemaName));
        try {
            this.assertUpdate("CREATE TABLE %s.%s.%s(id BIGINT)".formatted(HIVE_CATALOG_NAME, schemaName, tableName));
            Assertions.assertThat((Object)this.computeScalar(String.format("SHOW TABLES FROM %s LIKE '%s'", schemaName, tableName))).isEqualTo((Object)tableName);
            this.assertQueryFails("DESCRIBE " + schemaName + "." + tableName, ".* is not a Delta Lake table");
        }
        catch (Throwable throwable) {
            this.assertUpdate("DROP SCHEMA %s.%s CASCADE".formatted(HIVE_CATALOG_NAME, schemaName));
            throw throwable;
        }
        this.assertUpdate("DROP SCHEMA %s.%s CASCADE".formatted(HIVE_CATALOG_NAME, schemaName));
    }

    @AfterAll
    public void cleanup() throws IOException {
        if (this.metastore != null) {
            this.metastore.dropDatabase(SCHEMA, false);
            HiveMetastore hiveMetastore = this.metastore;
            if (hiveMetastore instanceof GlueHiveMetastore) {
                GlueHiveMetastore glueMetastore = (GlueHiveMetastore)hiveMetastore;
                glueMetastore.shutdown();
            }
            MoreFiles.deleteRecursively((Path)this.dataDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }
}

