/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.TestingNames;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class BaseDeltaLakeSharedMetastoreWithTableRedirectionsTest
extends AbstractTestQueryFramework {
    protected final String schema = "test_shared_schema_" + TestingNames.randomNameSuffix();

    protected abstract String getExpectedHiveCreateSchema(String var1);

    protected abstract String getExpectedDeltaLakeCreateSchema(String var1);

    @Test
    public void testReadInformationSchema() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_schema FROM hive_with_redirections.information_schema.tables WHERE table_name = 'hive_table' AND table_schema='" + this.schema + "'"))).skippingTypesCheck().containsAll("VALUES '" + this.schema + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_schema FROM hive_with_redirections.information_schema.tables WHERE table_name = 'delta_table' AND table_schema='" + this.schema + "'"))).skippingTypesCheck().containsAll("VALUES '" + this.schema + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_schema FROM delta_with_redirections.information_schema.tables WHERE table_name = 'hive_table' AND table_schema='" + this.schema + "'"))).skippingTypesCheck().containsAll("VALUES '" + this.schema + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_schema FROM delta_with_redirections.information_schema.tables WHERE table_name = 'delta_table' AND table_schema='" + this.schema + "'"))).skippingTypesCheck().containsAll("VALUES '" + this.schema + "'");
        this.assertQuery("SELECT table_name, column_name from hive_with_redirections.information_schema.columns WHERE table_schema = '" + this.schema + "'", "VALUES('hive_table', 'a_integer'), ('delta_table', 'a_varchar')");
        this.assertQuery("SELECT table_name, column_name from delta_with_redirections.information_schema.columns WHERE table_schema = '" + this.schema + "'", "VALUES('hive_table', 'a_integer'), ('delta_table', 'a_varchar')");
    }

    @Test
    public void testSelect() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM hive_with_redirections." + this.schema + ".hive_table"))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM hive_with_redirections." + this.schema + ".delta_table"))).matches("VALUES CAST('a' AS varchar), CAST('b' AS varchar), CAST('c' AS varchar)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM delta_with_redirections." + this.schema + ".hive_table"))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM delta_with_redirections." + this.schema + ".delta_table"))).matches("VALUES CAST('a' AS varchar), CAST('b' AS varchar), CAST('c' AS varchar)");
    }

    @Test
    public void testShowTables() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW TABLES FROM hive_with_redirections." + this.schema))).matches("VALUES CAST('hive_table' AS varchar), CAST('delta_table' AS varchar)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW TABLES FROM delta_with_redirections." + this.schema))).matches("VALUES CAST('hive_table' AS varchar), CAST('delta_table' AS varchar)");
    }

    @Test
    public void testShowSchemas() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW SCHEMAS FROM hive_with_redirections"))).skippingTypesCheck().containsAll("VALUES '" + this.schema + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW SCHEMAS FROM delta_with_redirections"))).skippingTypesCheck().containsAll("VALUES '" + this.schema + "'");
        String showCreateHiveWithRedirectionsSchema = (String)this.computeActual("SHOW CREATE SCHEMA hive_with_redirections." + this.schema).getOnlyValue();
        Assertions.assertThat((String)showCreateHiveWithRedirectionsSchema).isEqualTo(this.getExpectedHiveCreateSchema("hive_with_redirections"));
        String showCreateDeltaLakeWithRedirectionsSchema = (String)this.computeActual("SHOW CREATE SCHEMA delta_with_redirections." + this.schema).getOnlyValue();
        Assertions.assertThat((String)showCreateDeltaLakeWithRedirectionsSchema).isEqualTo(this.getExpectedDeltaLakeCreateSchema("delta_with_redirections"));
    }

    @Test
    public void testPropertiesTable() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM delta_with_redirections." + this.schema + ".\"delta_table$properties\""))).matches("SELECT * FROM hive_with_redirections." + this.schema + ".\"delta_table$properties\"");
    }

    @Test
    public void testPartitionsTable() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM delta_with_redirections." + this.schema + ".\"delta_table$partitions\""))).matches("SELECT * FROM hive_with_redirections." + this.schema + ".\"delta_table$partitions\"");
    }
}

