/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.Table;
import io.trino.plugin.deltalake.TestingDeltaLakeUtils;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.TableType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedRow;
import io.trino.testing.TestingNames;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseDeltaLakeTableWithCustomLocation
extends AbstractTestQueryFramework {
    @Test
    public void testTableHasUuidSuffixInLocation() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String tableName = "table_with_uuid" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds(String.format("CREATE TABLE %s AS SELECT 1 as val", tableName));
        Optional table = this.metastore().getTable(schema, tableName);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.isPresent()).describedAs("Table should exists", new Object[0])).isTrue();
        String location = ((Table)table.get()).getStorage().getLocation();
        Assertions.assertThat((String)location).matches((CharSequence)String.format(".*%s-[0-9a-f]{32}", tableName));
    }

    @Test
    public void testCreateAndDrop() throws IOException {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String tableName = "test_create_and_drop" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds(String.format("CREATE TABLE %s AS SELECT 1 as val", tableName));
        Table table = (Table)this.metastore().getTable(schema, tableName).orElseThrow();
        Assertions.assertThat((String)table.getTableType()).isEqualTo(TableType.MANAGED_TABLE.name());
        Location tableLocation = Location.of((String)table.getStorage().getLocation());
        TrinoFileSystem fileSystem = HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY.create(this.getSession().toConnectorSession());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fileSystem.listFiles(tableLocation).hasNext()).describedAs("The directory corresponding to the table storage location should exist", new Object[0])).isTrue();
        List materializedRows = this.computeActual("SELECT \"$path\" FROM " + tableName).getMaterializedRows();
        Assertions.assertThat((List)materializedRows).hasSize(1);
        Location filePath = Location.of((String)((String)((MaterializedRow)materializedRows.get(0)).getField(0)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fileSystem.listFiles(filePath).hasNext()).describedAs("The data file should exist", new Object[0])).isTrue();
        this.assertQuerySucceeds(String.format("DROP TABLE %s", tableName));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metastore().getTable(schema, tableName).isPresent()).describedAs("Table should be dropped", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fileSystem.listFiles(filePath).hasNext()).describedAs("The data file should have been removed", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fileSystem.listFiles(tableLocation).hasNext()).describedAs("The directory corresponding to the dropped Delta Lake table should be removed", new Object[0])).isFalse();
    }

    protected HiveMetastore metastore() {
        return TestingDeltaLakeUtils.getConnectorService(this.getQueryRunner(), HiveMetastoreFactory.class).createMetastore(Optional.empty());
    }
}

