/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.trino.filesystem.tracing.CacheFileSystemTraceUtils;
import io.trino.filesystem.tracing.CacheSystemAttributes;
import io.trino.filesystem.tracing.FileSystemAttributes;
import io.trino.testing.QueryRunner;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class DeltaLakeAlluxioCacheTestUtils {
    private static final Pattern dataFilePattern = Pattern.compile(".*?/(?<partition>((\\w+)=[^/]*/)*)(?<queryId>\\d{8}_\\d{6}_\\d{5}_\\w{5})_(?<uuid>[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})");

    private DeltaLakeAlluxioCacheTestUtils() {
    }

    public static Multiset<CacheFileSystemTraceUtils.CacheOperation> getCacheOperations(QueryRunner queryRunner) {
        return (Multiset)CacheFileSystemTraceUtils.getCacheOperationSpans((QueryRunner)queryRunner).stream().map(DeltaLakeAlluxioCacheTestUtils::createCacheOperation).collect(Collectors.toCollection(HashMultiset::create));
    }

    private static CacheFileSystemTraceUtils.CacheOperation createCacheOperation(SpanData span) {
        OptionalLong length;
        String operationName = span.getName();
        Attributes attributes = span.getAttributes();
        String path = CacheFileSystemTraceUtils.getFileLocation((SpanData)span);
        String fileName = path.replaceFirst(".*/", "");
        OptionalLong position = switch (operationName) {
            case "Alluxio.readCached", "Alluxio.readExternalStream" -> OptionalLong.of(Objects.requireNonNull((Long)attributes.get(CacheSystemAttributes.CACHE_FILE_READ_POSITION)));
            case "Alluxio.writeCache" -> OptionalLong.of(Objects.requireNonNull((Long)attributes.get(CacheSystemAttributes.CACHE_FILE_WRITE_POSITION)));
            case "Input.readFully" -> OptionalLong.of(Objects.requireNonNull((Long)attributes.get(FileSystemAttributes.FILE_READ_POSITION)));
            default -> OptionalLong.empty();
        };
        switch (operationName) {
            case "Alluxio.readCached": 
            case "Alluxio.readExternalStream": {
                OptionalLong optionalLong = OptionalLong.of(Objects.requireNonNull((Long)attributes.get(CacheSystemAttributes.CACHE_FILE_READ_SIZE)));
                break;
            }
            case "Alluxio.writeCache": {
                OptionalLong optionalLong = OptionalLong.of(Objects.requireNonNull((Long)attributes.get(CacheSystemAttributes.CACHE_FILE_WRITE_SIZE)));
                break;
            }
            case "Input.readFully": {
                OptionalLong optionalLong = OptionalLong.of(Objects.requireNonNull((Long)attributes.get(FileSystemAttributes.FILE_READ_SIZE)));
                break;
            }
            default: {
                OptionalLong optionalLong = length = OptionalLong.empty();
            }
        }
        if (!path.contains("_delta_log") && !path.contains("/.trino")) {
            Matcher matcher = dataFilePattern.matcher(path);
            if (matcher.matches()) {
                String changeData;
                String string = changeData = path.contains("/_change_data/") ? "change_data/" : "";
                if (!path.contains("=")) {
                    return new CacheFileSystemTraceUtils.CacheOperation(operationName, "data", position, length);
                }
                return new CacheFileSystemTraceUtils.CacheOperation(operationName, changeData + matcher.group("partition"), position, length);
            }
            if (path.contains("/part-00000-")) {
                return new CacheFileSystemTraceUtils.CacheOperation(operationName, "data", position, length);
            }
            if (path.contains("/deletion_vector_")) {
                return new CacheFileSystemTraceUtils.CacheOperation(operationName, "deletion_vector", position, length);
            }
        } else {
            return new CacheFileSystemTraceUtils.CacheOperation(operationName, fileName, position, length);
        }
        throw new IllegalArgumentException("File not recognized: " + path);
    }
}

