/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.airlift.log.Level;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.testing.Closeables;
import io.trino.plugin.deltalake.SparkDeltaLake;
import io.trino.plugin.deltalake.TestingDeltaLakePlugin;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.containers.Minio;
import io.trino.tpch.TpchTable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class DeltaLakeQueryRunner {
    public static final String DELTA_CATALOG = "delta";
    public static final String TPCH_SCHEMA = "tpch";

    private DeltaLakeQueryRunner() {
    }

    public static Builder builder() {
        return new Builder(TPCH_SCHEMA);
    }

    public static Builder builder(String schemaName) {
        return new Builder(schemaName);
    }

    static {
        Logging logging = Logging.initialize();
        logging.setLevel("org.apache.parquet.filter2.compat.FilterCompat", Level.OFF);
        logging.setLevel("com.amazonaws.util.Base64", Level.OFF);
        logging.setLevel("com.google.cloud", Level.OFF);
    }

    public static class Builder
    extends DistributedQueryRunner.Builder<Builder> {
        private final String schemaName;
        private ImmutableMap.Builder<String, String> deltaProperties = ImmutableMap.builder();
        private Optional<String> schemaLocation = Optional.empty();
        private List<TpchTable<?>> initialTables = ImmutableList.of();

        protected Builder(String schemaName) {
            super(TestingSession.testSessionBuilder().setCatalog(DeltaLakeQueryRunner.DELTA_CATALOG).setSchema(schemaName).build());
            this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        }

        @CanIgnoreReturnValue
        public Builder setDeltaProperties(Map<String, String> deltaProperties) {
            this.deltaProperties = ImmutableMap.builder().putAll(Objects.requireNonNull(deltaProperties, "deltaProperties is null"));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addDeltaProperties(Map<String, String> deltaProperties) {
            this.deltaProperties.putAll(deltaProperties);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addDeltaProperty(String key, String value) {
            return this.addDeltaProperties(Map.of(key, value));
        }

        @CanIgnoreReturnValue
        public Builder addMetastoreProperties(HiveHadoop hiveHadoop) {
            return this.addDeltaProperties((Map<String, String>)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)hiveHadoop.getHiveMetastoreEndpoint().toString()).put((Object)"hive.metastore.thrift.client.read-timeout", (Object)"1m").buildOrThrow());
        }

        @CanIgnoreReturnValue
        public Builder addS3Properties(Minio minio, String bucketName) {
            this.addDeltaProperties((Map<String, String>)ImmutableMap.builder().put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)minio.getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"s3.streaming.part-size", (Object)"5MB").buildOrThrow());
            this.setSchemaLocation("s3://%s/%s".formatted(bucketName, this.schemaName));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSchemaLocation(String schemaLocation) {
            this.schemaLocation = Optional.of(schemaLocation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInitialTables(Iterable<TpchTable<?>> initialTables) {
            this.initialTables = ImmutableList.copyOf(Objects.requireNonNull(initialTables, "initialTables is null"));
            return this;
        }

        public DistributedQueryRunner build() throws Exception {
            DistributedQueryRunner queryRunner = super.build();
            try {
                queryRunner.installPlugin((Plugin)new TpchPlugin());
                queryRunner.createCatalog(DeltaLakeQueryRunner.TPCH_SCHEMA, DeltaLakeQueryRunner.TPCH_SCHEMA);
                queryRunner.installPlugin((Plugin)new TestingDeltaLakePlugin(queryRunner.getCoordinator().getBaseDataDir().resolve("delta_lake_data")));
                HashMap<String, String> deltaProperties = new HashMap<String, String>((Map<String, String>)this.deltaProperties.buildOrThrow());
                if (!deltaProperties.containsKey("hive.metastore") && !deltaProperties.containsKey("hive.metastore.uri")) {
                    deltaProperties.put("hive.metastore", "file");
                }
                if (deltaProperties.keySet().stream().noneMatch(key -> key.equals("fs.hadoop.enabled") || key.startsWith("fs.native-"))) {
                    deltaProperties.put("fs.hadoop.enabled", "true");
                }
                queryRunner.createCatalog(DeltaLakeQueryRunner.DELTA_CATALOG, "delta_lake", deltaProperties);
                String schemaName = (String)queryRunner.getDefaultSession().getSchema().orElseThrow();
                String createSchema = "CREATE SCHEMA IF NOT EXISTS " + schemaName;
                if (this.schemaLocation.isPresent()) {
                    createSchema = createSchema + " WITH (location = '" + this.schemaLocation.get() + "')";
                }
                queryRunner.execute(createSchema);
                QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)DeltaLakeQueryRunner.TPCH_SCHEMA, (String)"tiny", this.initialTables);
                return queryRunner;
            }
            catch (Exception e) {
                Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
                throw e;
            }
        }
    }

    public static final class S3DeltaLakeQueryRunnerMain {
        private S3DeltaLakeQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            String bucketName = "test-bucket";
            Hive3MinioDataLake hiveMinioDataLake = new Hive3MinioDataLake(bucketName);
            hiveMinioDataLake.start();
            DistributedQueryRunner queryRunner = ((Builder)DeltaLakeQueryRunner.builder().addCoordinatorProperty("http-server.http.port", "8080")).addMetastoreProperties(hiveMinioDataLake.getHiveHadoop()).addS3Properties(hiveMinioDataLake.getMinio(), bucketName).addDeltaProperty("delta.enable-non-concurrent-writes", "true").setInitialTables(TpchTable.getTables()).build();
            Logger log = Logger.get(DeltaLakeQueryRunner.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }

    public static final class DeltaLakeSparkQueryRunnerMain {
        private DeltaLakeSparkQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            String bucketName = "test-bucket";
            SparkDeltaLake sparkDeltaLake = new SparkDeltaLake(bucketName);
            DistributedQueryRunner queryRunner = ((Builder)DeltaLakeQueryRunner.builder().addCoordinatorProperty("http-server.http.port", "8080")).addMetastoreProperties(sparkDeltaLake.hiveHadoop()).addS3Properties(sparkDeltaLake.minio(), bucketName).addDeltaProperty("delta.enable-non-concurrent-writes", "true").build();
            Logger log = Logger.get(DeltaLakeSparkQueryRunnerMain.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }

    public static final class DeltaLakeExternalQueryRunnerMain {
        private DeltaLakeExternalQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            DistributedQueryRunner queryRunner = ((Builder)DeltaLakeQueryRunner.builder().addCoordinatorProperty("http-server.http.port", "8080")).addDeltaProperty("hive.metastore", System.getProperty("hive.metastore")).build();
            Logger log = Logger.get(DeltaLakeExternalQueryRunnerMain.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }

    public static final class DefaultDeltaLakeQueryRunnerMain {
        private DefaultDeltaLakeQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            File metastoreDir = Files.createTempDirectory("delta_query_runner", new FileAttribute[0]).toFile();
            metastoreDir.deleteOnExit();
            DistributedQueryRunner queryRunner = ((Builder)DeltaLakeQueryRunner.builder().addCoordinatorProperty("http-server.http.port", "8080")).addDeltaProperty("delta.enable-non-concurrent-writes", "true").addDeltaProperty("hive.metastore.catalog.dir", metastoreDir.toURI().toString()).setInitialTables(TpchTable.getTables()).build();
            Logger log = Logger.get(DeltaLakeQueryRunner.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }
}

