/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;

public class FileTestingTransactionLogSynchronizer
implements TransactionLogSynchronizer {
    private final TrinoFileSystemFactory fileSystemFactory;

    @Inject
    public FileTestingTransactionLogSynchronizer(TrinoFileSystemFactory fileSystemFactory) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    public boolean isUnsafe() {
        return true;
    }

    public void write(ConnectorSession session, String clusterId, Location newLogEntryPath, byte[] entryContents) {
        try {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            TrinoOutputFile outputFile = fileSystem.newOutputFile(newLogEntryPath);
            outputFile.createOrOverwrite(entryContents);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

