/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import io.trino.plugin.base.util.AutoCloseableCloser;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.testing.TestingProperties;
import io.trino.testing.containers.Minio;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.MountableFile;

public final class SparkDeltaLake
implements AutoCloseable {
    private final AutoCloseableCloser closer = AutoCloseableCloser.create();
    private final Hive3MinioDataLake hiveMinio;

    public SparkDeltaLake(String bucketName) {
        this.hiveMinio = (Hive3MinioDataLake)this.closer.register((AutoCloseable)new Hive3MinioDataLake(bucketName));
        this.hiveMinio.start();
        ((GenericContainer)this.closer.register((AutoCloseable)new GenericContainer("ghcr.io/trinodb/testing/spark3-delta:" + TestingProperties.getDockerImagesVersion()))).withCopyFileToContainer(MountableFile.forClasspathResource((String)"spark-defaults.conf"), "/spark/conf/spark-defaults.conf").withNetwork(this.hiveMinio.getNetwork()).start();
    }

    public HiveHadoop hiveHadoop() {
        return this.hiveMinio.getHiveHadoop();
    }

    public Minio minio() {
        return this.hiveMinio.getMinio();
    }

    @Override
    public void close() throws Exception {
        this.closer.close();
    }
}

