/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

public class TestCdfWithNumberOfSplitsGreaterThanMaxBatchSizeInSplitSource
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return ((DeltaLakeQueryRunner.Builder)DeltaLakeQueryRunner.builder().setExtraProperties((Map)ImmutableMap.of((Object)"query.schedule-split-batch-size", (Object)"1", (Object)"node-scheduler.max-splits-per-node", (Object)"1", (Object)"node-scheduler.min-pending-splits-per-task", (Object)"1"))).addDeltaProperty("delta.enable-non-concurrent-writes", "true").build();
    }

    @Test
    public void testReadCdfChanges() {
        String tableName = "test_basic_operations_on_table_with_cdf_enabled_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (page_url VARCHAR, domain VARCHAR, views INTEGER) WITH (change_data_feed_enabled = true)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url1', 'domain1', 1), ('url2', 'domain2', 2), ('url3', 'domain3', 3)", 3L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url4', 'domain4', 4), ('url5', 'domain5', 2), ('url6', 'domain6', 6)", 3L);
        this.assertUpdate("UPDATE " + tableName + " SET page_url = 'url22' WHERE views = 2", 2L);
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "'))", "VALUES\n    ('url1', 'domain1', 1, 'insert', BIGINT '1'),\n    ('url2', 'domain2', 2, 'insert', BIGINT '1'),\n    ('url3', 'domain3', 3, 'insert', BIGINT '1'),\n    ('url4', 'domain4', 4, 'insert', BIGINT '2'),\n    ('url5', 'domain5', 2, 'insert', BIGINT '2'),\n    ('url6', 'domain6', 6, 'insert', BIGINT '2'),\n    ('url2', 'domain2', 2, 'update_preimage', BIGINT '3'),\n    ('url22', 'domain2', 2, 'update_postimage', BIGINT '3'),\n    ('url5', 'domain5', 2, 'update_preimage', BIGINT '3'),\n    ('url22', 'domain5', 2, 'update_postimage', BIGINT '3')\n");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE views = 2", 2L);
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 3))", "VALUES\n    ('url22', 'domain2', 2, 'delete', BIGINT '4'),\n    ('url22', 'domain5', 2, 'delete', BIGINT '4')\n");
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "')) ORDER BY _commit_version, _change_type, domain", "VALUES\n    ('url1', 'domain1', 1, 'insert', BIGINT '1'),\n    ('url2', 'domain2', 2, 'insert', BIGINT '1'),\n    ('url3', 'domain3', 3, 'insert', BIGINT '1'),\n    ('url4', 'domain4', 4, 'insert', BIGINT '2'),\n    ('url5', 'domain5', 2, 'insert', BIGINT '2'),\n    ('url6', 'domain6', 6, 'insert', BIGINT '2'),\n    ('url22', 'domain2', 2, 'update_postimage', BIGINT '3'),\n    ('url22', 'domain5', 2, 'update_postimage', BIGINT '3'),\n    ('url2', 'domain2', 2, 'update_preimage', BIGINT '3'),\n    ('url5', 'domain5', 2, 'update_preimage', BIGINT '3'),\n    ('url22', 'domain2', 2, 'delete', BIGINT '4'),\n    ('url22', 'domain5', 2, 'delete', BIGINT '4')\n");
    }

    private void assertTableChangesQuery(@Language(value="SQL") String sql, @Language(value="SQL") String expectedResult) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(sql))).result().exceptColumns(new String[]{"_commit_timestamp"}).skippingTypesCheck().matches(expectedResult);
    }
}

